/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.index;

import java.util.ArrayList;
import org.gridgain.internal.h2.command.dml.AllColumnsForPlan;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.index.Cursor;
import org.gridgain.internal.h2.index.Index;
import org.gridgain.internal.h2.index.IndexLookupBatch;
import org.gridgain.internal.h2.index.IndexType;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.SearchRow;
import org.gridgain.internal.h2.result.SortOrder;
import org.gridgain.internal.h2.schema.SchemaObjectBase;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.IndexColumn;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.value.DataType;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueNull;

public abstract class BaseIndex
extends SchemaObjectBase
implements Index {
    protected IndexColumn[] indexColumns;
    protected Column[] columns;
    protected int[] columnIds;
    protected final Table table;
    protected final IndexType indexType;

    protected BaseIndex(Table newTable, int id, String name, IndexColumn[] newIndexColumns, IndexType newIndexType) {
        super(newTable.getSchema(), id, name, 5);
        this.indexType = newIndexType;
        this.table = newTable;
        if (newIndexColumns != null) {
            this.indexColumns = newIndexColumns;
            this.columns = new Column[newIndexColumns.length];
            int len = this.columns.length;
            this.columnIds = new int[len];
            for (int i = 0; i < len; ++i) {
                Column col;
                this.columns[i] = col = newIndexColumns[i].column;
                this.columnIds[i] = col.getColumnId();
            }
        }
    }

    protected static void checkIndexColumnTypes(IndexColumn[] columns) {
        for (IndexColumn c : columns) {
            if (!DataType.isLargeObject(c.column.getType().getValueType())) continue;
            throw DbException.getUnsupportedException("Index on BLOB or CLOB column: " + c.column.getCreateSQL());
        }
    }

    @Override
    public String getDropSQL() {
        return null;
    }

    protected DbException getDuplicateKeyException(String key) {
        StringBuilder builder = new StringBuilder();
        this.getSQL(builder, false).append(" ON ");
        this.table.getSQL(builder, false).append('(');
        builder.append(this.getColumnListSQL(false));
        builder.append(')');
        if (key != null) {
            builder.append(" VALUES ").append(key);
        }
        DbException e = DbException.get(23505, builder.toString());
        e.setSource(this);
        return e;
    }

    @Override
    public String getPlanSQL() {
        return this.getSQL(false);
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        this.table.removeIndex(this);
        this.remove(session);
        this.database.removeMeta(session, this.getId());
    }

    @Override
    public boolean canFindNext() {
        return false;
    }

    @Override
    public boolean isFindUsingFullTableScan() {
        return false;
    }

    @Override
    public Cursor find(TableFilter filter, SearchRow first, SearchRow last) {
        return this.find(filter.getSession(), first, last);
    }

    @Override
    public Cursor findNext(Session session, SearchRow higherThan, SearchRow last) {
        throw DbException.throwInternalError(this.toString());
    }

    protected final long getCostRangeIndex(int[] masks, long rowCount, TableFilter[] filters, int filter, SortOrder sortOrder, boolean isScanIndex, AllColumnsForPlan allColumnsSet) {
        int totalSelectivity = 0;
        long rowsCost = rowCount += 1000L;
        if (masks != null) {
            int i = 0;
            int len = this.columns.length;
            boolean tryAdditional = false;
            while (i < len) {
                Column column;
                int index;
                int mask;
                if (((mask = masks[index = (column = this.columns[i++]).getColumnId()]) & 1) == 1) {
                    if (i == len && this.getIndexType().isUnique()) {
                        rowsCost = 3L;
                        break;
                    }
                    long distinctRows = rowCount * (long)(totalSelectivity = 100 - (100 - totalSelectivity) * (100 - column.getSelectivity()) / 100) / 100L;
                    if (distinctRows <= 0L) {
                        distinctRows = 1L;
                    }
                    rowsCost = 2L + Math.max(rowCount / distinctRows, 1L);
                    continue;
                }
                if ((mask & 6) == 6) {
                    rowsCost = 2L + rowsCost / 4L;
                    tryAdditional = true;
                    break;
                }
                if ((mask & 2) == 2) {
                    rowsCost = 2L + rowsCost / 3L;
                    tryAdditional = true;
                    break;
                }
                if ((mask & 4) == 4) {
                    rowsCost /= 3L;
                    tryAdditional = true;
                    break;
                }
                if (mask != 0) break;
                --i;
                break;
            }
            if (tryAdditional) {
                while (i < len && masks[this.columns[i].getColumnId()] != 0) {
                    ++i;
                    --rowsCost;
                }
            }
            rowsCost += (long)(len - i);
        }
        long sortingCost = 0L;
        if (sortOrder != null) {
            sortingCost = 100L + rowCount / 10L;
        }
        if (sortOrder != null && !isScanIndex) {
            boolean sortOrderMatches = true;
            int coveringCount = 0;
            int[] sortTypes = sortOrder.getSortTypes();
            TableFilter tableFilter = filters == null ? null : filters[filter];
            int len = sortTypes.length;
            for (int i = 0; i < len && i < this.indexColumns.length; ++i) {
                Column col = sortOrder.getColumn(i, tableFilter);
                if (col == null) {
                    sortOrderMatches = false;
                    break;
                }
                IndexColumn indexCol = this.indexColumns[i];
                if (!col.equals(indexCol.column)) {
                    sortOrderMatches = false;
                    break;
                }
                int sortType = sortTypes[i];
                if (sortType != indexCol.sortType) {
                    sortOrderMatches = false;
                    break;
                }
                ++coveringCount;
            }
            if (sortOrderMatches) {
                sortingCost = 100 - coveringCount;
            }
        }
        boolean needsToReadFromScanIndex = true;
        if (!isScanIndex && allColumnsSet != null) {
            boolean foundAllColumnsWeNeed = true;
            ArrayList<Column> foundCols = allColumnsSet.get(this.getTable());
            if (foundCols != null) {
                for (Column c : foundCols) {
                    boolean found = false;
                    for (Column c2 : this.columns) {
                        if (c != c2) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    foundAllColumnsWeNeed = false;
                    break;
                }
            }
            if (foundAllColumnsWeNeed) {
                needsToReadFromScanIndex = false;
            }
        }
        long rc = isScanIndex ? rowsCost + sortingCost + 20L : (needsToReadFromScanIndex ? rowsCost + rowsCost + sortingCost + 20L : rowsCost + sortingCost + (long)this.columns.length);
        return rc;
    }

    @Override
    public int compareRows(SearchRow rowData, SearchRow compare) {
        if (rowData == compare) {
            return 0;
        }
        int len = this.indexColumns.length;
        for (int i = 0; i < len; ++i) {
            int index = this.columnIds[i];
            Value v1 = rowData.getValue(index);
            Value v2 = compare.getValue(index);
            if (v1 == null || v2 == null) {
                return 0;
            }
            int c = this.compareValues(v1, v2, this.indexColumns[i].sortType);
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    protected boolean mayHaveNullDuplicates(SearchRow searchRow) {
        switch (this.database.getMode().uniqueIndexNullsHandling) {
            case ALLOW_DUPLICATES_WITH_ANY_NULL: {
                for (int index : this.columnIds) {
                    if (searchRow.getValue(index) != ValueNull.INSTANCE) continue;
                    return true;
                }
                return false;
            }
            case ALLOW_DUPLICATES_WITH_ALL_NULLS: {
                for (int index : this.columnIds) {
                    if (searchRow.getValue(index) == ValueNull.INSTANCE) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    int compareKeys(SearchRow rowData, SearchRow compare) {
        long k2;
        long k1 = rowData.getKey();
        if (k1 == (k2 = compare.getKey())) {
            return 0;
        }
        return k1 > k2 ? 1 : -1;
    }

    private int compareValues(Value a, Value b, int sortType) {
        boolean bNull;
        if (a == b) {
            return 0;
        }
        boolean aNull = a == ValueNull.INSTANCE;
        boolean bl = bNull = b == ValueNull.INSTANCE;
        if (aNull || bNull) {
            return SortOrder.compareNull(aNull, sortType);
        }
        int comp = this.table.compareValues(a, b);
        if ((sortType & 1) != 0) {
            comp = -comp;
        }
        return comp;
    }

    @Override
    public int getColumnIndex(Column col) {
        int len = this.columns.length;
        for (int i = 0; i < len; ++i) {
            if (!this.columns[i].equals(col)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isFirstColumn(Column column) {
        return column.equals(this.columns[0]);
    }

    private String getColumnListSQL(boolean alwaysQuote) {
        return IndexColumn.writeColumns(new StringBuilder(), this.indexColumns, alwaysQuote).toString();
    }

    @Override
    public String getCreateSQLForCopy(Table targetTable, String quotedName) {
        StringBuilder buff = new StringBuilder("CREATE ");
        buff.append(this.indexType.getSQL());
        buff.append(' ');
        if (this.table.isHidden()) {
            buff.append("IF NOT EXISTS ");
        }
        buff.append(quotedName);
        buff.append(" ON ");
        targetTable.getSQL(buff, true);
        if (this.comment != null) {
            buff.append(" COMMENT ");
            StringUtils.quoteStringSQL(buff, this.comment);
        }
        buff.append('(').append(this.getColumnListSQL(true)).append(')');
        return buff.toString();
    }

    @Override
    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.table, this.getSQL(true));
    }

    @Override
    public IndexColumn[] getIndexColumns() {
        return this.indexColumns;
    }

    @Override
    public Column[] getColumns() {
        return this.columns;
    }

    @Override
    public IndexType getIndexType() {
        return this.indexType;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public Row getRow(Session session, long key) {
        throw DbException.getUnsupportedException(this.toString());
    }

    @Override
    public boolean isHidden() {
        return this.table.isHidden();
    }

    @Override
    public boolean isRowIdIndex() {
        return false;
    }

    @Override
    public boolean canScan() {
        return true;
    }

    @Override
    public void setSortedInsertMode(boolean sortedInsertMode) {
    }

    @Override
    public IndexLookupBatch createLookupBatch(TableFilter[] filters, int filter) {
        return null;
    }

    @Override
    public void update(Session session, Row oldRow, Row newRow) {
        this.remove(session, oldRow);
        this.add(session, newRow);
    }
}

