/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.index;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.internal.processors.query.h2.H2MemoryTracker;
import org.gridgain.internal.h2.command.dml.AllColumnsForPlan;
import org.gridgain.internal.h2.engine.DbObject;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.ExpressionVisitor;
import org.gridgain.internal.h2.index.BaseIndex;
import org.gridgain.internal.h2.index.Cursor;
import org.gridgain.internal.h2.index.Index;
import org.gridgain.internal.h2.index.IndexCondition;
import org.gridgain.internal.h2.index.IndexType;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.message.Trace;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.SearchRow;
import org.gridgain.internal.h2.result.SortOrder;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.IndexColumn;
import org.gridgain.internal.h2.table.IndexHints;
import org.gridgain.internal.h2.table.PlanItem;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueArray;

public class HashJoinIndex
extends BaseIndex {
    public static final String HASH_JOIN_IDX = "HASH_JOIN_IDX";
    private final IteratorCursor cur = new IteratorCursor();
    private Map<Value, List<Row>> hashTbl;
    private HashColumn[] hashColumns;
    private Index fillFromIndex;
    private Set<ConditionChecker> condsCheckers;
    private ArrayList<IndexCondition> filterIdxCond;
    private H2MemoryTracker tracker;

    public HashJoinIndex(Table tbl) {
        super(tbl, 0, HASH_JOIN_IDX, IndexColumn.wrap(tbl.getColumns()), IndexType.createUnique(false, true));
    }

    public static boolean isEquiJoinCondition(IndexCondition cond) {
        if (cond.getExpression() == null || !cond.isEvaluatable()) {
            return false;
        }
        int cmpType = cond.getCompareType();
        if (cmpType != 0 && cmpType != 16) {
            return false;
        }
        HashSet<DbObject> dependencies = new HashSet<DbObject>();
        ExpressionVisitor depsVisitor = ExpressionVisitor.getDependenciesVisitor(dependencies);
        cond.getExpression().isEverything(depsVisitor);
        return dependencies.size() == 1;
    }

    public static boolean isApplicable(Session ses, Table tbl) {
        return tbl.getRowCountApproximation(ses) < (long)ses.getHashJoinMaxTableSize();
    }

    public static boolean isEnableByHint(IndexHints indexHints) {
        return indexHints != null && indexHints.getAllowedIndexes() != null && indexHints.getAllowedIndexes().size() == 1 && indexHints.getAllowedIndexes().contains(HASH_JOIN_IDX);
    }

    @Override
    public void add(Session ses, Row row) {
        throw new UnsupportedOperationException("Runtime HASH_JOIN_IDX index doesn't support 'add'");
    }

    @Override
    public void remove(Session ses, Row row) {
        throw new UnsupportedOperationException("Runtime HASH_JOIN_IDX index doesn't support 'remove'");
    }

    @Override
    public long getRowCount(Session ses) {
        return this.getRowCountApproximation(ses);
    }

    @Override
    public long getRowCountApproximation(Session session) {
        return 0L;
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public void close(Session ses) {
    }

    @Override
    public void remove(Session ses) {
    }

    @Override
    public void truncate(Session ses) {
    }

    @Override
    public double getCost(Session ses, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan allColumnsSet) {
        if (ses.isJoinBatchEnabled()) {
            return 9.223372036854776E18;
        }
        double cost = 0.0;
        for (Column column : this.columns) {
            int index = column.getColumnId();
            int mask = masks[index];
            if (mask == 0 || (mask & 1) != 1) continue;
            if (cost > 0.0) {
                cost -= 2.0;
                continue;
            }
            cost = (long)(2 * this.columns.length) + this.table.getRowCountApproximation(ses) / 1000L;
        }
        return cost > 0.0 ? cost : 9.223372036854776E18;
    }

    @Override
    public void checkRename() {
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return false;
    }

    @Override
    public Cursor findFirstOrLast(Session ses, boolean first) {
        throw DbException.getUnsupportedException("HASH");
    }

    @Override
    public boolean canScan() {
        return false;
    }

    @Override
    public Cursor find(Session ses, SearchRow first, SearchRow last) {
        Value key;
        if (this.hashTbl == null) {
            this.build(ses);
        }
        if ((key = this.hashKey(first)).containsNull()) {
            return Cursor.EMPTY;
        }
        if (!this.hashKey(first).equals(this.hashKey(last))) {
            return Cursor.EMPTY;
        }
        List<Row> res = this.hashTbl.get(key);
        if (res == null) {
            return Cursor.EMPTY;
        }
        this.cur.open(res.iterator());
        return this.cur;
    }

    @Override
    public String getPlanSQL() {
        if (this.fillFromIndex == null) {
            return HASH_JOIN_IDX;
        }
        StringBuilder builder = new StringBuilder("HASH_JOIN_IDX ");
        builder.append("[fillFromIndex=").append(this.fillFromIndex.getName());
        builder.append(", hashedCols=[");
        for (int i = 0; i < this.hashColumns.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(this.table.getColumn(this.hashColumns[i].colId).getName());
        }
        builder.append("]");
        if (this.condsCheckers != null && !this.condsCheckers.isEmpty()) {
            builder.append(", filters=[");
            int cnt = 0;
            for (ConditionChecker c : this.condsCheckers) {
                if (cnt > 0) {
                    builder.append(", ");
                }
                builder.append(c.getSQL());
                ++cnt;
            }
            builder.append("]");
        }
        builder.append("]");
        return builder.toString();
    }

    public boolean isBuilt() {
        return this.hashTbl != null;
    }

    public void prepare(Session ses, ArrayList<IndexCondition> indexConditions) {
        assert (this.hashTbl == null);
        ArrayList<HashColumn> hashCols = new ArrayList<HashColumn>();
        this.filterIdxCond = new ArrayList();
        for (IndexCondition idxCond : indexConditions) {
            if (HashJoinIndex.isEquiJoinCondition(idxCond)) {
                int colType = idxCond.getColumn().getType().getValueType();
                int expType = idxCond.getExpression().getType().getValueType();
                int targetType = Value.getHigherOrder(expType, colType);
                HashColumn col = new HashColumn(idxCond.getColumn().getColumnId(), targetType);
                if (hashCols.contains(col)) continue;
                hashCols.add(col);
                continue;
            }
            if (idxCond.isAlwaysFalse()) continue;
            this.filterIdxCond.add(idxCond);
        }
        assert (!hashCols.isEmpty()) : "The set of join columns is empty for table '" + this.table.getName() + '\'';
        this.hashColumns = hashCols.toArray(new HashColumn[0]);
        this.prepareFillFromIndex(ses);
        for (IndexCondition idxCond : this.filterIdxCond) {
            ConditionChecker checker = ConditionChecker.create(ses, idxCond);
            if (this.condsCheckers == null && checker != null) {
                this.condsCheckers = new HashSet<ConditionChecker>();
            }
            if (checker == null) continue;
            this.condsCheckers.add(checker);
        }
    }

    private void prepareFillFromIndex(Session ses) {
        int[] masks = IndexCondition.createMasksForTable(this.table, this.filterIdxCond);
        if (!ses.isJoinBatchEnabled()) {
            PlanItem plan = this.table.getBestPlanItem(ses, masks, null, 0, null, null, false);
            this.fillFromIndex = plan.getIndex();
        } else {
            this.fillFromIndex = this.table.getScanIndex(ses);
        }
    }

    private Cursor openCursorToFillHashTable(Session ses) {
        if (this.fillFromIndex.isFindUsingFullTableScan()) {
            return this.fillFromIndex.find(ses, null, null);
        }
        SearchRow first = null;
        SearchRow last = null;
        boolean[] colIndexed = new boolean[this.table.getColumns().length];
        for (Column c : this.fillFromIndex.getColumns()) {
            colIndexed[c.getColumnId()] = true;
        }
        for (IndexCondition condition : this.filterIdxCond) {
            IndexColumn idxCol;
            Column column = condition.getColumn();
            if (!colIndexed[column.getColumnId()] || condition.getCompareType() == 9 || condition.getCompareType() == 10) continue;
            Value v = condition.getCurrentValue(ses);
            boolean isStart = condition.isStart();
            boolean isEnd = condition.isEnd();
            int columnId = column.getColumnId();
            if (columnId != -1 && (idxCol = this.indexColumns[columnId]) != null && (idxCol.sortType & 1) != 0) {
                boolean temp = isStart;
                isStart = isEnd;
                isEnd = temp;
            }
            if (isStart) {
                first = this.table.getSearchRow(first, columnId, v, true);
            }
            if (!isEnd) continue;
            last = this.table.getSearchRow(last, columnId, v, false);
        }
        return this.fillFromIndex.find(ses, first, last);
    }

    private void build(Session ses) {
        long t0 = System.currentTimeMillis();
        if (this.condsCheckers != null) {
            for (ConditionChecker c : this.condsCheckers) {
                c.calculateValue(ses);
            }
        }
        Cursor cur = this.openCursorToFillHashTable(ses);
        this.hashTbl = new HashMap<Value, List<Row>>();
        H2MemoryTracker h2MemoryTracker = this.tracker = ses.memoryTracker() != null ? ses.memoryTracker().createChildTracker() : null;
        while (cur.next()) {
            Value key;
            Row r = cur.get();
            if (!this.checkConditions(ses, r) || (key = this.hashKey(r)).containsNull()) continue;
            List<Row> keyRows = this.hashTbl.get(key);
            if (this.tracker != null) {
                int size = keyRows != null ? 0 : 40 + key.getMemory() + 24;
                this.tracker.reserve(size += 8 + r.getMemory());
            }
            if (keyRows == null) {
                keyRows = new ArrayList<Row>();
                this.hashTbl.put(key, keyRows);
            }
            keyRows.add(r);
        }
        Trace t = ses.getTrace();
        if (t.isDebugEnabled()) {
            t.debug("Build hash table for {0}, size={1}. Duration={2} ms", this.table.getName(), this.hashTbl.size(), System.currentTimeMillis() - t0);
        }
    }

    private Value hashKey(SearchRow r) {
        if (this.hashColumns.length == 1) {
            return r.getValue(this.hashColumns[0].colId).convertTo(this.hashColumns[0].targetType);
        }
        Value[] key = new Value[this.hashColumns.length];
        for (int i = 0; i < this.hashColumns.length; ++i) {
            HashColumn col = this.hashColumns[i];
            key[i] = r.getValue(col.colId).convertTo(col.targetType);
        }
        return ValueArray.get(key);
    }

    private boolean checkConditions(Session ses, Row r) {
        if (this.condsCheckers != null) {
            for (ConditionChecker checker : this.condsCheckers) {
                if (checker.check(this.getTable(), r)) continue;
                return false;
            }
        }
        return true;
    }

    public void clearHashTable(Session session) {
        this.hashTbl = null;
        if (this.tracker != null) {
            this.tracker.close();
        }
        this.tracker = null;
    }

    private static class HashColumn {
        private final int colId;
        private final int targetType;

        private HashColumn(int colId, int targetType) {
            this.colId = colId;
            this.targetType = targetType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HashColumn column = (HashColumn)o;
            return this.colId == column.colId;
        }

        public int hashCode() {
            return this.colId;
        }
    }

    private static class ConditionSmallerEqualChecker
    extends ConditionChecker {
        private ConditionSmallerEqualChecker() {
        }

        @Override
        boolean checkValue(Table tbl, Value o) {
            return tbl.compareValues(o, this.v) <= 0;
        }
    }

    private static class ConditionSmallerChecker
    extends ConditionChecker {
        private ConditionSmallerChecker() {
        }

        @Override
        boolean checkValue(Table tbl, Value o) {
            return tbl.compareValues(o, this.v) < 0;
        }
    }

    private static class ConditionBiggerChecker
    extends ConditionChecker {
        private ConditionBiggerChecker() {
        }

        @Override
        boolean checkValue(Table tbl, Value o) {
            return tbl.compareValues(o, this.v) > 0;
        }
    }

    private static class ConditionBiggerEqualChecker
    extends ConditionChecker {
        private ConditionBiggerEqualChecker() {
        }

        @Override
        boolean checkValue(Table tbl, Value o) {
            return tbl.compareValues(o, this.v) >= 0;
        }
    }

    private static class ConditionEqualChecker
    extends ConditionChecker {
        private ConditionEqualChecker() {
        }

        @Override
        boolean checkValue(Table tbl, Value o) {
            return tbl.compareValues(o, this.v) == 0;
        }
    }

    private static abstract class ConditionChecker {
        int colId;
        Value v;
        IndexCondition idxCond;

        private ConditionChecker() {
        }

        boolean check(Table tbl, Row r) {
            Value o = r.getValue(this.colId);
            if (o.containsNull()) {
                return false;
            }
            return this.checkValue(tbl, o);
        }

        void calculateValue(Session ses) {
            this.v = this.idxCond.getCurrentValue(ses);
        }

        public String getSQL() {
            return this.idxCond.getSQL(false);
        }

        abstract boolean checkValue(Table var1, Value var2);

        static ConditionChecker create(Session ses, IndexCondition idxCond) {
            ConditionChecker checker;
            switch (idxCond.getCompareType()) {
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    return null;
                }
                case 0: 
                case 16: {
                    checker = new ConditionEqualChecker();
                    break;
                }
                case 1: {
                    checker = new ConditionBiggerEqualChecker();
                    break;
                }
                case 2: {
                    checker = new ConditionBiggerChecker();
                    break;
                }
                case 3: {
                    checker = new ConditionSmallerEqualChecker();
                    break;
                }
                case 4: {
                    checker = new ConditionSmallerChecker();
                    break;
                }
                default: {
                    throw DbException.throwInternalError("type=" + idxCond.getCompareType());
                }
            }
            if (checker != null) {
                checker.colId = idxCond.getColumn().getColumnId();
                checker.idxCond = idxCond;
            }
            return checker;
        }
    }

    private class IteratorCursor
    implements Cursor {
        private Iterator<Row> it;
        private Row current;

        private IteratorCursor() {
        }

        public void open(Iterator<Row> it) {
            this.it = it;
            this.current = null;
        }

        @Override
        public boolean previous() {
            throw DbException.getUnsupportedException("prev");
        }

        @Override
        public boolean next() {
            if (this.it.hasNext()) {
                this.current = this.it.next();
                return true;
            }
            this.current = null;
            return false;
        }

        @Override
        public Row getSearchRow() {
            return this.get();
        }

        @Override
        public Row get() {
            return this.current;
        }

        public String toString() {
            return "IteratorCursor->" + this.current;
        }
    }
}

