/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.index;

import org.gridgain.internal.h2.command.dml.AllColumnsForPlan;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.engine.SysProperties;
import org.gridgain.internal.h2.index.Cursor;
import org.gridgain.internal.h2.index.IndexType;
import org.gridgain.internal.h2.index.PageData;
import org.gridgain.internal.h2.index.PageDataLeaf;
import org.gridgain.internal.h2.index.PageDataNode;
import org.gridgain.internal.h2.index.PageDataOverflow;
import org.gridgain.internal.h2.index.PageIndex;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.SearchRow;
import org.gridgain.internal.h2.result.SortOrder;
import org.gridgain.internal.h2.store.Page;
import org.gridgain.internal.h2.store.PageStore;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.IndexColumn;
import org.gridgain.internal.h2.table.PageStoreTable;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.util.MathUtils;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueNull;

public class PageDataIndex
extends PageIndex {
    private final PageStore store;
    private final PageStoreTable tableData;
    private long lastKey;
    private long rowCount;
    private int mainIndexColumn = -1;
    private DbException fastDuplicateKeyException;
    private int memoryPerPage;
    private int memoryCount;

    public PageDataIndex(PageStoreTable table, int id, IndexColumn[] columns, IndexType indexType, boolean create, Session session) {
        super(table, id, table.getName() + "_DATA", columns, indexType);
        this.tableData = table;
        this.store = this.database.getPageStore();
        this.store.addIndex(this);
        if (!this.database.isPersistent()) {
            throw DbException.throwInternalError(table.getName());
        }
        if (create) {
            this.rootPageId = this.store.allocatePage();
            this.store.addMeta(this, session);
            PageDataLeaf root = PageDataLeaf.create(this, this.rootPageId, 0);
            this.store.update(root);
        } else {
            this.rootPageId = this.store.getRootPageId(id);
            PageData root = this.getPage(this.rootPageId, 0);
            this.lastKey = root.getLastKey();
            this.rowCount = root.getRowCount();
        }
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("{0} opened rows: {1}", this, this.rowCount);
        }
        table.setRowCount(this.rowCount);
        this.memoryPerPage = 240 + this.store.getPageSize() >> 2;
    }

    @Override
    public DbException getDuplicateKeyException(String key) {
        if (this.fastDuplicateKeyException == null) {
            this.fastDuplicateKeyException = super.getDuplicateKeyException(null);
        }
        return this.fastDuplicateKeyException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Session session, Row row) {
        boolean retry = false;
        if (this.mainIndexColumn != -1) {
            row.setKey(row.getValue(this.mainIndexColumn).getLong());
        } else if (row.getKey() == 0L) {
            row.setKey((int)(++this.lastKey));
            retry = true;
        }
        if (this.tableData.getContainsLargeObject()) {
            int len = row.getColumnCount();
            for (int i = 0; i < len; ++i) {
                Value v = row.getValue(i);
                Value v2 = v.copy(this.database, this.getId());
                if (v2.isLinkedToTable()) {
                    session.removeAtCommitStop(v2);
                }
                if (v == v2) continue;
                row.setValue(i, v2);
            }
        }
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("{0} add {1}", this.getName(), row);
        }
        long add = 0L;
        while (true) {
            try {
                this.addTry(session, row);
            }
            catch (DbException e) {
                if (e != this.fastDuplicateKeyException) {
                    throw e;
                }
                if (!retry) {
                    throw this.getNewDuplicateKeyException();
                }
                if (add == 0L) {
                    row.setKey((long)((double)row.getKey() + Math.random() * 10000.0));
                } else {
                    row.setKey(row.getKey() + add);
                }
                ++add;
                continue;
            }
            finally {
                this.store.incrementChangeCount();
                continue;
            }
            break;
        }
        this.lastKey = Math.max(this.lastKey, row.getKey());
    }

    public DbException getNewDuplicateKeyException() {
        StringBuilder builder = new StringBuilder("PRIMARY KEY ON ");
        this.table.getSQL(builder, false);
        if (this.mainIndexColumn >= 0 && this.mainIndexColumn < this.indexColumns.length) {
            builder.append('(');
            this.indexColumns[this.mainIndexColumn].getSQL(builder, false).append(')');
        }
        DbException e = DbException.get(23505, builder.toString());
        e.setSource(this);
        return e;
    }

    private void addTry(Session session, Row row) {
        PageData root;
        int splitPoint;
        while ((splitPoint = (root = this.getPage(this.rootPageId, 0)).addRowTry(row)) != -1) {
            if (this.trace.isDebugEnabled()) {
                this.trace.debug("{0} split", this);
            }
            long pivot = splitPoint == 0 ? row.getKey() : root.getKey(splitPoint - 1);
            PageData page1 = root;
            PageData page2 = root.split(splitPoint);
            int id = this.store.allocatePage();
            page1.setPageId(id);
            page1.setParentPageId(this.rootPageId);
            page2.setParentPageId(this.rootPageId);
            PageDataNode newRoot = PageDataNode.create(this, this.rootPageId, 0);
            newRoot.init(page1, pivot, page2);
            this.store.update(page1);
            this.store.update(page2);
            this.store.update(newRoot);
            PageDataNode pageDataNode = newRoot;
        }
        row.setDeleted(false);
        this.invalidateRowCount();
        ++this.rowCount;
        this.store.logAddOrRemoveRow(session, this.tableData.getId(), row, true);
    }

    PageDataOverflow getPageOverflow(int id) {
        Page p = this.store.getPage(id);
        if (p instanceof PageDataOverflow) {
            return (PageDataOverflow)p;
        }
        throw DbException.get(90030, p == null ? "null" : p.toString());
    }

    PageData getPage(int id, int parent) {
        Page pd = this.store.getPage(id);
        if (pd == null) {
            PageDataLeaf empty = PageDataLeaf.create(this, id, parent);
            this.store.logUndo(empty, null);
            this.store.update(empty);
            return empty;
        }
        if (!(pd instanceof PageData)) {
            throw DbException.get(90030, String.valueOf(pd));
        }
        PageData p = (PageData)pd;
        if (parent != -1 && p.getParentPageId() != parent) {
            throw DbException.throwInternalError(p + " parent " + p.getParentPageId() + " expected " + parent);
        }
        return p;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return false;
    }

    long getKey(SearchRow row, long ifEmpty, long ifNull) {
        if (row == null) {
            return ifEmpty;
        }
        Value v = row.getValue(this.mainIndexColumn);
        if (v == null) {
            return row.getKey();
        }
        if (v == ValueNull.INSTANCE) {
            return ifNull;
        }
        return v.getLong();
    }

    @Override
    public Cursor find(Session session, SearchRow first, SearchRow last) {
        long from = first == null ? Long.MIN_VALUE : first.getKey();
        long to = last == null ? Long.MAX_VALUE : last.getKey();
        PageData root = this.getPage(this.rootPageId, 0);
        return root.find(session, from, to);
    }

    Cursor find(Session session, long first, long last) {
        PageData root = this.getPage(this.rootPageId, 0);
        return root.find(session, first, last);
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean first) {
        throw DbException.throwInternalError(this.toString());
    }

    long getLastKey() {
        PageData root = this.getPage(this.rootPageId, 0);
        return root.getLastKey();
    }

    @Override
    public double getCost(Session session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan allColumnsSet) {
        return 10L * (this.tableData.getRowCountApproximation(session) + 1000L) + 200L;
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Session session, Row row) {
        if (this.tableData.getContainsLargeObject()) {
            int len = row.getColumnCount();
            for (int i = 0; i < len; ++i) {
                Value v = row.getValue(i);
                if (!v.isLinkedToTable()) continue;
                session.removeAtCommit(v);
            }
        }
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("{0} remove {1}", this.getName(), row);
        }
        if (this.rowCount == 1L) {
            this.removeAllRows();
        } else {
            try {
                long key = row.getKey();
                PageData root = this.getPage(this.rootPageId, 0);
                root.remove(key);
                this.invalidateRowCount();
                --this.rowCount;
            }
            finally {
                this.store.incrementChangeCount();
            }
        }
        this.store.logAddOrRemoveRow(session, this.tableData.getId(), row, false);
    }

    @Override
    public void remove(Session session) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("{0} remove", this);
        }
        this.removeAllRows();
        this.store.free(this.rootPageId);
        this.store.removeMeta(this, session);
    }

    @Override
    public void truncate(Session session) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("{0} truncate", this);
        }
        this.store.logTruncate(session, this.tableData.getId());
        this.removeAllRows();
        if (this.tableData.getContainsLargeObject() && this.tableData.isPersistData()) {
            session.commit(false);
            this.database.getLobStorage().removeAllForTable(this.table.getId());
        }
        this.tableData.setRowCount(0L);
    }

    private void removeAllRows() {
        try {
            PageData root = this.getPage(this.rootPageId, 0);
            root.freeRecursive();
            root = PageDataLeaf.create(this, this.rootPageId, 0);
            this.store.removeFromCache(this.rootPageId);
            this.store.update(root);
            this.rowCount = 0L;
            this.lastKey = 0L;
        }
        finally {
            this.store.incrementChangeCount();
        }
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("PAGE");
    }

    @Override
    public Row getRow(Session session, long key) {
        return this.getRowWithKey(key);
    }

    public Row getRowWithKey(long key) {
        PageData root = this.getPage(this.rootPageId, 0);
        return root.getRowWithKey(key);
    }

    PageStore getPageStore() {
        return this.store;
    }

    @Override
    public long getRowCountApproximation(Session ses) {
        return this.rowCount;
    }

    @Override
    public long getRowCount(Session session) {
        return this.rowCount;
    }

    @Override
    public long getDiskSpaceUsed() {
        PageData root = this.getPage(this.rootPageId, 0);
        return root.getDiskSpaceUsed();
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public int getColumnIndex(Column col) {
        return -1;
    }

    @Override
    public boolean isFirstColumn(Column column) {
        return false;
    }

    @Override
    public void close(Session session) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("{0} close", this);
        }
        this.writeRowCount();
    }

    void setRootPageId(Session session, int newPos) {
        this.store.removeMeta(this, session);
        this.rootPageId = newPos;
        this.store.addMeta(this, session);
        this.store.addIndex(this);
    }

    public void setMainIndexColumn(int mainIndexColumn) {
        this.mainIndexColumn = mainIndexColumn;
    }

    public int getMainIndexColumn() {
        return this.mainIndexColumn;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    private void invalidateRowCount() {
        PageData root = this.getPage(this.rootPageId, 0);
        root.setRowCountStored(-1);
    }

    @Override
    public void writeRowCount() {
        if (SysProperties.MODIFY_ON_WRITE && this.rootPageId == 0) {
            return;
        }
        try {
            PageData root = this.getPage(this.rootPageId, 0);
            root.setRowCountStored(MathUtils.convertLongToInt(this.rowCount));
        }
        finally {
            this.store.incrementChangeCount();
        }
    }

    @Override
    public String getPlanSQL() {
        return this.table.getSQL(new StringBuilder(), false).append(".tableScan").toString();
    }

    int getMemoryPerPage() {
        return this.memoryPerPage;
    }

    void memoryChange(int x) {
        this.memoryPerPage = this.memoryCount < 64 ? (this.memoryPerPage += (x - this.memoryPerPage) / ++this.memoryCount) : (this.memoryPerPage += (x > this.memoryPerPage ? 1 : -1) + (x - this.memoryPerPage) / 64);
    }

    @Override
    public boolean isRowIdIndex() {
        return true;
    }
}

