/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.index;

import java.util.ArrayList;
import org.gridgain.internal.h2.command.dml.AllColumnsForPlan;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.index.BaseIndex;
import org.gridgain.internal.h2.index.Cursor;
import org.gridgain.internal.h2.index.IndexType;
import org.gridgain.internal.h2.index.ScanCursor;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.SearchRow;
import org.gridgain.internal.h2.result.SortOrder;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.IndexColumn;
import org.gridgain.internal.h2.table.PageStoreTable;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.util.Utils;

public class ScanIndex
extends BaseIndex {
    private long firstFree = -1L;
    private ArrayList<Row> rows = Utils.newSmallArrayList();
    private final PageStoreTable tableData;
    private long rowCount;

    public ScanIndex(PageStoreTable table, int id, IndexColumn[] columns, IndexType indexType) {
        super(table, id, table.getName() + "_DATA", columns, indexType);
        this.tableData = table;
    }

    @Override
    public void remove(Session session) {
        this.truncate(session);
    }

    @Override
    public void truncate(Session session) {
        this.rows = Utils.newSmallArrayList();
        this.firstFree = -1L;
        if (this.tableData.getContainsLargeObject() && this.tableData.isPersistData()) {
            this.database.getLobStorage().removeAllForTable(this.table.getId());
        }
        this.tableData.setRowCount(0L);
        this.rowCount = 0L;
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public Row getRow(Session session, long key) {
        return this.rows.get((int)key);
    }

    @Override
    public void add(Session session, Row row) {
        if (this.firstFree == -1L) {
            int key = this.rows.size();
            row.setKey(key);
            this.rows.add(row);
        } else {
            long key = this.firstFree;
            Row free = this.rows.get((int)key);
            this.firstFree = free.getKey();
            row.setKey(key);
            this.rows.set((int)key, row);
        }
        row.setDeleted(false);
        ++this.rowCount;
    }

    @Override
    public void remove(Session session, Row row) {
        if (this.rowCount == 1L) {
            this.rows = Utils.newSmallArrayList();
            this.firstFree = -1L;
        } else {
            Row free = session.createRow(null, 1);
            free.setKey(this.firstFree);
            long key = row.getKey();
            if ((long)this.rows.size() <= key) {
                throw DbException.get(90112, this.rows.size() + ": " + key);
            }
            this.rows.set((int)key, free);
            this.firstFree = key;
        }
        --this.rowCount;
    }

    @Override
    public Cursor find(Session session, SearchRow first, SearchRow last) {
        return new ScanCursor(this);
    }

    @Override
    public double getCost(Session session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan allColumnsSet) {
        return this.tableData.getRowCountApproximation(session) + 1000L;
    }

    @Override
    public long getRowCount(Session session) {
        return this.rowCount;
    }

    Row getNextRow(Row row) {
        long key = row == null ? -1L : row.getKey();
        do {
            if (++key < (long)this.rows.size()) continue;
            return null;
        } while ((row = this.rows.get((int)key)).isEmpty());
        return row;
    }

    @Override
    public int getColumnIndex(Column col) {
        return -1;
    }

    @Override
    public boolean isFirstColumn(Column column) {
        return false;
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("SCAN");
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return false;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean first) {
        throw DbException.getUnsupportedException("SCAN");
    }

    @Override
    public long getRowCountApproximation(Session ses) {
        return this.rowCount;
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public String getPlanSQL() {
        return this.table.getSQL(new StringBuilder(), false).append(".tableScan").toString();
    }
}

