/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.jdbc;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.sql.SQLXML;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.gridgain.internal.h2.jdbc.JdbcConnection;
import org.gridgain.internal.h2.jdbc.JdbcLob;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.value.Value;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class JdbcSQLXML
extends JdbcLob
implements SQLXML {
    private DOMResult domResult;
    private Closeable closable;

    public JdbcSQLXML(JdbcConnection conn, Value value, JdbcLob.State state, int id) {
        super(conn, value, state, 17, id);
    }

    @Override
    void checkReadable() throws SQLException, IOException {
        this.checkClosed();
        if (this.state == JdbcLob.State.SET_CALLED) {
            if (this.domResult != null) {
                Node node = this.domResult.getNode();
                this.domResult = null;
                TransformerFactory factory = TransformerFactory.newInstance();
                try {
                    Transformer transformer = factory.newTransformer();
                    DOMSource domSource = new DOMSource(node);
                    StringWriter stringWriter = new StringWriter();
                    StreamResult streamResult = new StreamResult(stringWriter);
                    transformer.transform(domSource, streamResult);
                    this.completeWrite(this.conn.createClob(new StringReader(stringWriter.toString()), -1L));
                }
                catch (Exception e) {
                    throw this.logAndConvert(e);
                }
                return;
            }
            if (this.closable != null) {
                this.closable.close();
                this.closable = null;
                return;
            }
            throw DbException.getUnsupportedException("Stream setter is not yet closed.");
        }
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return super.getBinaryStream();
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return super.getCharacterStream();
    }

    @Override
    public <T extends Source> T getSource(Class<T> sourceClass) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCodeCall("getSource(" + (sourceClass != null ? sourceClass.getSimpleName() + ".class" : "null") + ')');
            }
            this.checkReadable();
            if (sourceClass == null || sourceClass == DOMSource.class) {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                return (T)new DOMSource(dbf.newDocumentBuilder().parse(new InputSource(this.value.getInputStream())));
            }
            if (sourceClass == SAXSource.class) {
                return (T)new SAXSource(new InputSource(this.value.getInputStream()));
            }
            if (sourceClass == StAXSource.class) {
                XMLInputFactory xif = XMLInputFactory.newInstance();
                return (T)new StAXSource(xif.createXMLStreamReader(this.value.getInputStream()));
            }
            if (sourceClass == StreamSource.class) {
                return (T)new StreamSource(this.value.getInputStream());
            }
            throw this.unsupported(sourceClass.getName());
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public String getString() throws SQLException {
        try {
            this.debugCodeCall("getString");
            this.checkReadable();
            return this.value.getString();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public OutputStream setBinaryStream() throws SQLException {
        try {
            this.debugCodeCall("setBinaryStream");
            this.checkEditable();
            this.state = JdbcLob.State.SET_CALLED;
            return new BufferedOutputStream(this.setClobOutputStreamImpl());
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Writer setCharacterStream() throws SQLException {
        try {
            this.debugCodeCall("setCharacterStream");
            this.checkEditable();
            this.state = JdbcLob.State.SET_CALLED;
            return this.setCharacterStreamImpl();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public <T extends Result> T setResult(Class<T> resultClass) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCodeCall("getSource(" + (resultClass != null ? resultClass.getSimpleName() + ".class" : "null") + ')');
            }
            this.checkEditable();
            if (resultClass == null || resultClass == DOMResult.class) {
                this.domResult = new DOMResult();
                this.state = JdbcLob.State.SET_CALLED;
                return (T)this.domResult;
            }
            if (resultClass == SAXResult.class) {
                SAXTransformerFactory transformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
                TransformerHandler transformerHandler = transformerFactory.newTransformerHandler();
                Writer writer = this.setCharacterStreamImpl();
                transformerHandler.setResult(new StreamResult(writer));
                SAXResult saxResult = new SAXResult(transformerHandler);
                this.closable = writer;
                this.state = JdbcLob.State.SET_CALLED;
                return (T)saxResult;
            }
            if (resultClass == StAXResult.class) {
                XMLOutputFactory xof = XMLOutputFactory.newInstance();
                Writer writer = this.setCharacterStreamImpl();
                StAXResult staxResult = new StAXResult(xof.createXMLStreamWriter(writer));
                this.closable = writer;
                this.state = JdbcLob.State.SET_CALLED;
                return (T)staxResult;
            }
            if (StreamResult.class.equals(resultClass)) {
                Writer writer = this.setCharacterStreamImpl();
                StreamResult streamResult = new StreamResult(writer);
                this.closable = writer;
                this.state = JdbcLob.State.SET_CALLED;
                return (T)streamResult;
            }
            throw this.unsupported(resultClass.getName());
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void setString(String value) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCodeCall("getSource", value);
            }
            this.checkEditable();
            this.completeWrite(this.conn.createClob(new StringReader(value), -1L));
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }
}

