/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.jdbcx;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.gridgain.internal.h2.Driver;
import org.gridgain.internal.h2.engine.SysProperties;
import org.gridgain.internal.h2.jdbcx.JdbcDataSource;
import org.gridgain.internal.h2.message.Trace;
import org.gridgain.internal.h2.message.TraceSystem;

public class JdbcDataSourceFactory
implements ObjectFactory {
    private static TraceSystem cachedTraceSystem;
    private final Trace trace = JdbcDataSourceFactory.getTraceSystem().getTrace(15);

    @Override
    public synchronized Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) {
        Reference ref;
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("getObjectInstance obj={0} name={1} nameCtx={2} environment={3}", obj, name, nameCtx, environment);
        }
        if (obj instanceof Reference && (ref = (Reference)obj).getClassName().equals(JdbcDataSource.class.getName())) {
            JdbcDataSource dataSource = new JdbcDataSource();
            dataSource.setURL((String)ref.get("url").getContent());
            dataSource.setUser((String)ref.get("user").getContent());
            dataSource.setPassword((String)ref.get("password").getContent());
            dataSource.setDescription((String)ref.get("description").getContent());
            String s = (String)ref.get("loginTimeout").getContent();
            dataSource.setLoginTimeout(Integer.parseInt(s));
            return dataSource;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TraceSystem getTraceSystem() {
        Class<JdbcDataSourceFactory> clazz = JdbcDataSourceFactory.class;
        synchronized (JdbcDataSourceFactory.class) {
            if (cachedTraceSystem == null) {
                cachedTraceSystem = new TraceSystem(SysProperties.CLIENT_TRACE_DIRECTORY + "h2datasource" + ".trace.db");
                cachedTraceSystem.setLevelFile(SysProperties.DATASOURCE_TRACE_LEVEL);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return cachedTraceSystem;
        }
    }

    Trace getTrace() {
        return this.trace;
    }

    static {
        Driver.load();
    }
}

