/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.mode;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.ValueExpression;
import org.gridgain.internal.h2.expression.function.Function;
import org.gridgain.internal.h2.expression.function.FunctionInfo;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.mode.FunctionsBase;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueInt;
import org.gridgain.internal.h2.value.ValueNull;
import org.gridgain.internal.h2.value.ValueString;

public class FunctionsMySQL
extends FunctionsBase {
    private static final int UNIX_TIMESTAMP = 1001;
    private static final int FROM_UNIXTIME = 1002;
    private static final int DATE = 1003;
    private static final HashMap<String, FunctionInfo> FUNCTIONS = new HashMap();
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String[] FORMAT_REPLACE;

    public static int unixTimestamp() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    public static int unixTimestamp(Timestamp timestamp) {
        return (int)(timestamp.getTime() / 1000L);
    }

    public static String fromUnixTime(int seconds) {
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_TIME_FORMAT, Locale.ENGLISH);
        return formatter.format(new Date((long)seconds * 1000L));
    }

    public static String fromUnixTime(int seconds, String format) {
        format = FunctionsMySQL.convertToSimpleDateFormat(format);
        SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.ENGLISH);
        return formatter.format(new Date((long)seconds * 1000L));
    }

    private static String convertToSimpleDateFormat(String format) {
        String[] replace = FORMAT_REPLACE;
        for (int i = 0; i < replace.length; i += 2) {
            format = StringUtils.replaceAll(format, replace[i], replace[i + 1]);
        }
        return format;
    }

    public static Function getFunction(Database database, String upperName) {
        FunctionInfo info = FUNCTIONS.get(upperName);
        return info != null ? new FunctionsMySQL(database, info) : null;
    }

    FunctionsMySQL(Database database, FunctionInfo info) {
        super(database, info);
    }

    @Override
    protected void checkParameterCount(int len) {
        int max;
        int min;
        switch (this.info.type) {
            case 1001: {
                min = 0;
                max = 2;
                break;
            }
            case 1002: {
                min = 1;
                max = 2;
                break;
            }
            case 1003: {
                min = 1;
                max = 1;
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.info.type);
                return;
            }
        }
        if (len < min || len > max) {
            throw DbException.get(7001, this.info.name, min + ".." + max);
        }
    }

    @Override
    public Expression optimize(Session session) {
        boolean allConst = this.info.deterministic;
        for (int i = 0; i < this.args.length; ++i) {
            Expression e = this.args[i];
            if (e == null) continue;
            this.args[i] = e = e.optimize(session);
            if (e.isConstant()) continue;
            allConst = false;
        }
        if (allConst) {
            return ValueExpression.get(this.getValue(session));
        }
        this.type = TypeInfo.getTypeInfo(this.info.returnDataType);
        return this;
    }

    @Override
    protected Value getValueWithArgs(Session session, Expression[] args) {
        Value result;
        Value[] values = new Value[args.length];
        Value v0 = FunctionsMySQL.getNullOrValue(session, args, values, 0);
        Value v1 = FunctionsMySQL.getNullOrValue(session, args, values, 1);
        block1 : switch (this.info.type) {
            case 1001: {
                result = ValueInt.get(v0 == null ? FunctionsMySQL.unixTimestamp() : FunctionsMySQL.unixTimestamp(v0.getTimestamp()));
                break;
            }
            case 1002: {
                result = ValueString.get(v1 == null ? FunctionsMySQL.fromUnixTime(v0.getInt()) : FunctionsMySQL.fromUnixTime(v0.getInt(), v1.getString()));
                break;
            }
            case 1003: {
                switch (v0.getValueType()) {
                    case 10: {
                        result = v0;
                        break block1;
                    }
                    default: {
                        try {
                            v0 = v0.convertTo(11);
                            break;
                        }
                        catch (DbException ex) {
                            v0 = ValueNull.INSTANCE;
                        }
                    }
                    case 11: 
                    case 24: 
                }
                result = v0.convertTo(10);
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + this.info.type);
            }
        }
        return result;
    }

    static {
        FUNCTIONS.put("UNIX_TIMESTAMP", new FunctionInfo("UNIX_TIMESTAMP", 1001, -1, 4, false, false, false, true));
        FUNCTIONS.put("FROM_UNIXTIME", new FunctionInfo("FROM_UNIXTIME", 1002, -1, 13, false, true, false, true));
        FUNCTIONS.put("DATE", new FunctionInfo("DATE", 1003, 1, 10, false, true, false, true));
        FORMAT_REPLACE = new String[]{"%a", "EEE", "%b", "MMM", "%c", "MM", "%d", "dd", "%e", "d", "%H", "HH", "%h", "hh", "%I", "hh", "%i", "mm", "%j", "DDD", "%k", "H", "%l", "h", "%M", "MMMM", "%m", "MM", "%p", "a", "%r", "hh:mm:ss a", "%S", "ss", "%s", "ss", "%T", "HH:mm:ss", "%W", "EEEE", "%w", "F", "%Y", "yyyy", "%y", "yy", "%%", "%"};
    }
}

