/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.mvstore.db;

import java.util.Arrays;
import java.util.BitSet;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.mvstore.Cursor;
import org.gridgain.internal.h2.mvstore.MVMap;
import org.gridgain.internal.h2.mvstore.db.MVTempResult;
import org.gridgain.internal.h2.mvstore.db.ValueDataType;
import org.gridgain.internal.h2.result.ResultExternal;
import org.gridgain.internal.h2.result.SortOrder;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueRow;

class MVSortedTempResult
extends MVTempResult {
    private final boolean distinct;
    private final int[] distinctIndexes;
    private final int[] indexes;
    private final MVMap<ValueRow, Long> map;
    private MVMap<ValueRow, Object> index;
    private ValueDataType orderedDistinctOnType;
    private Cursor<ValueRow, Long> cursor;
    private Value[] current;
    private long valueCount;

    private MVSortedTempResult(MVSortedTempResult parent) {
        super(parent);
        this.distinct = parent.distinct;
        this.distinctIndexes = parent.distinctIndexes;
        this.indexes = parent.indexes;
        this.map = parent.map;
        this.rowCount = parent.rowCount;
    }

    MVSortedTempResult(Database database, Expression[] expressions, boolean distinct, int[] distinctIndexes, int visibleColumnCount, SortOrder sort) {
        int[] indexes;
        int[] sortTypes;
        int length;
        block9: {
            super(database, expressions, visibleColumnCount);
            this.distinct = distinct;
            this.distinctIndexes = distinctIndexes;
            length = expressions.length;
            sortTypes = new int[length];
            if (sort != null) {
                int i;
                indexes = new int[length];
                int[] colIndex = sort.getQueryColumnIndexes();
                int len = colIndex.length;
                BitSet used = new BitSet();
                for (int i2 = 0; i2 < len; ++i2) {
                    int idx = colIndex[i2];
                    assert (!used.get(idx));
                    used.set(idx);
                    indexes[i2] = idx;
                    sortTypes[i2] = sort.getSortTypes()[i2];
                }
                int idx = 0;
                for (i = len; i < length; ++i) {
                    idx = used.nextClearBit(idx);
                    indexes[i] = idx++;
                }
                for (i = 0; i < length; ++i) {
                    if (indexes[i] == i) {
                        continue;
                    }
                    break block9;
                }
                indexes = null;
            } else {
                indexes = null;
            }
        }
        this.indexes = indexes;
        ValueDataType keyType = new ValueDataType(database, sortTypes);
        MVMap.BasicBuilder builder = new MVMap.Builder().keyType(keyType);
        this.map = this.store.openMap("tmp", builder);
        if (distinct && length != visibleColumnCount || distinctIndexes != null) {
            int count = distinctIndexes != null ? distinctIndexes.length : visibleColumnCount;
            ValueDataType distinctType = new ValueDataType(database, new int[count]);
            MVMap.BasicBuilder indexBuilder = new MVMap.Builder().keyType(distinctType);
            if (distinctIndexes != null && sort != null) {
                ((MVMap.Builder)indexBuilder).valueType(keyType);
                this.orderedDistinctOnType = keyType;
            }
            this.index = this.store.openMap("idx", indexBuilder);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int addRow(Value[] values) {
        assert (this.parent == null);
        ValueRow key = this.getKey(values);
        if (this.distinct || this.distinctIndexes != null) {
            ValueRow distinctRow;
            if (this.distinctIndexes != null) {
                int cnt = this.distinctIndexes.length;
                Value[] newValues = new Value[cnt];
                for (int i = 0; i < cnt; ++i) {
                    newValues[i] = values[this.distinctIndexes[i]];
                }
                ValueRow distinctRow2 = ValueRow.get(newValues);
                if (this.orderedDistinctOnType == null) {
                    if (this.index.putIfAbsent(distinctRow2, true) != null) {
                        return this.rowCount;
                    }
                } else {
                    ValueRow previous = (ValueRow)this.index.get(distinctRow2);
                    if (previous == null) {
                        this.index.put(distinctRow2, key);
                    } else {
                        if (this.orderedDistinctOnType.compare(previous, key) <= 0) return this.rowCount;
                        this.map.remove(previous);
                        --this.rowCount;
                        this.index.put(distinctRow2, key);
                    }
                }
            } else if (this.expressions.length != this.visibleColumnCount && this.index.putIfAbsent(distinctRow = ValueRow.get(Arrays.copyOf(values, this.visibleColumnCount)), true) != null) {
                return this.rowCount;
            }
            if (this.map.putIfAbsent(key, 1L) != null) return this.rowCount;
            ++this.rowCount;
            return this.rowCount;
        } else {
            Long old = this.map.putIfAbsent(key, 1L);
            if (old != null) {
                this.map.put(key, old + 1L);
            }
            ++this.rowCount;
        }
        return this.rowCount;
    }

    @Override
    public boolean contains(Value[] values) {
        if (this.parent != null) {
            return this.parent.contains(values);
        }
        assert (this.distinct);
        if (this.expressions.length != this.visibleColumnCount) {
            return this.index.containsKey(ValueRow.get(values));
        }
        return this.map.containsKey(this.getKey(values));
    }

    @Override
    public synchronized ResultExternal createShallowCopy() {
        if (this.parent != null) {
            return this.parent.createShallowCopy();
        }
        if (this.closed) {
            return null;
        }
        ++this.childCount;
        return new MVSortedTempResult(this);
    }

    private ValueRow getKey(Value[] values) {
        if (this.indexes != null) {
            Value[] r = new Value[this.indexes.length];
            for (int i = 0; i < this.indexes.length; ++i) {
                r[i] = values[this.indexes[i]];
            }
            values = r;
        }
        return ValueRow.get(values);
    }

    private Value[] getValue(Value[] key) {
        if (this.indexes != null) {
            Value[] r = new Value[this.indexes.length];
            for (int i = 0; i < this.indexes.length; ++i) {
                r[this.indexes[i]] = key[i];
            }
            key = r;
        }
        return key;
    }

    @Override
    public Value[] next() {
        if (this.cursor == null) {
            this.cursor = this.map.cursor(null);
            this.current = null;
            this.valueCount = 0L;
        }
        if (--this.valueCount > 0L) {
            return this.current;
        }
        if (!this.cursor.hasNext()) {
            this.current = null;
            return null;
        }
        this.current = this.getValue(this.cursor.next().getList());
        if (this.hasEnum) {
            this.fixEnum(this.current);
        }
        this.valueCount = this.cursor.getValue();
        return this.current;
    }

    @Override
    public int removeRow(Value[] values) {
        assert (this.parent == null && this.distinct);
        if (this.expressions.length != this.visibleColumnCount) {
            throw DbException.getUnsupportedException("removeRow()");
        }
        if (this.map.remove(this.getKey(values)) != null) {
            --this.rowCount;
        }
        return this.rowCount;
    }

    @Override
    public void reset() {
        this.cursor = null;
        this.current = null;
        this.valueCount = 0L;
    }
}

