/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.mvstore.rtree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.gridgain.internal.h2.mvstore.CursorPos;
import org.gridgain.internal.h2.mvstore.DataUtils;
import org.gridgain.internal.h2.mvstore.MVMap;
import org.gridgain.internal.h2.mvstore.Page;
import org.gridgain.internal.h2.mvstore.RootReference;
import org.gridgain.internal.h2.mvstore.rtree.SpatialDataType;
import org.gridgain.internal.h2.mvstore.rtree.SpatialKey;
import org.gridgain.internal.h2.mvstore.type.DataType;

public final class MVRTreeMap<V>
extends MVMap<SpatialKey, V> {
    final SpatialDataType keyType;
    private boolean quadraticSplit;

    public MVRTreeMap(Map<String, Object> config) {
        super(config);
        this.keyType = (SpatialDataType)config.get("key");
        this.quadraticSplit = Boolean.valueOf(String.valueOf(config.get("quadraticSplit")));
    }

    private MVRTreeMap(MVRTreeMap<V> source) {
        super(source);
        this.keyType = source.keyType;
        this.quadraticSplit = source.quadraticSplit;
    }

    public MVRTreeMap<V> cloneIt() {
        return new MVRTreeMap<V>(this);
    }

    public RTreeCursor findIntersectingKeys(SpatialKey x) {
        return new RTreeCursor(this.getRootPage(), x){

            @Override
            protected boolean check(boolean leaf, SpatialKey key, SpatialKey test) {
                return MVRTreeMap.this.keyType.isOverlap(key, test);
            }
        };
    }

    public RTreeCursor findContainedKeys(SpatialKey x) {
        return new RTreeCursor(this.getRootPage(), x){

            @Override
            protected boolean check(boolean leaf, SpatialKey key, SpatialKey test) {
                if (leaf) {
                    return MVRTreeMap.this.keyType.isInside(key, test);
                }
                return MVRTreeMap.this.keyType.isOverlap(key, test);
            }
        };
    }

    private boolean contains(Page p, int index, Object key) {
        return this.keyType.contains(p.getKey(index), key);
    }

    @Override
    public V get(Page p, Object key) {
        int keyCount = p.getKeyCount();
        if (!p.isLeaf()) {
            for (int i = 0; i < keyCount; ++i) {
                V o;
                if (!this.contains(p, i, key) || (o = this.get(p.getChildPage(i), key)) == null) continue;
                return o;
            }
        } else {
            for (int i = 0; i < keyCount; ++i) {
                if (!this.keyType.equals(p.getKey(i), key)) continue;
                return (V)p.getValue(i);
            }
        }
        return null;
    }

    @Override
    public V remove(Object key) {
        return (V)this.operate((SpatialKey)key, (V)null, (MVMap.DecisionMaker<? super V>)MVMap.DecisionMaker.REMOVE);
    }

    @Override
    public V operate(SpatialKey key, V value, MVMap.DecisionMaker<? super V> decisionMaker) {
        this.beforeWrite();
        int attempt = 0;
        while (true) {
            ++attempt;
            RootReference rootReference = this.flushAndGetRoot();
            Page p = rootReference.root.copy(true);
            V result = this.operate(p, key, value, decisionMaker);
            if (!p.isLeaf() && p.getTotalCount() == 0L) {
                p.removePage();
                p = this.createEmptyLeaf();
            } else if (p.getKeyCount() > this.store.getKeysPerPage() || (long)p.getMemory() > this.store.getMaxPageSize() && p.getKeyCount() > 3) {
                long totalCount = p.getTotalCount();
                Page split = this.split(p);
                Object k1 = this.getBounds(p);
                Object k2 = this.getBounds(split);
                Object[] keys = new Object[]{k1, k2};
                Page.PageReference[] children = new Page.PageReference[]{new Page.PageReference(p), new Page.PageReference(split), Page.PageReference.EMPTY};
                p = Page.createNode(this, keys, children, totalCount, 0);
                if (this.store.getFileStore() != null) {
                    this.store.registerUnsavedPage(p.getMemory());
                }
            }
            if (this.updateRoot(rootReference, p, attempt)) {
                return result;
            }
            decisionMaker.reset();
        }
    }

    private V operate(Page p, Object key, V value, MVMap.DecisionMaker<? super V> decisionMaker) {
        Object result = null;
        if (p.isLeaf()) {
            int index = -1;
            int keyCount = p.getKeyCount();
            for (int i = 0; i < keyCount; ++i) {
                if (!this.keyType.equals(p.getKey(i), key)) continue;
                index = i;
            }
            result = index < 0 ? null : p.getValue(index);
            MVMap.Decision decision = decisionMaker.decide(result, value);
            switch (decision) {
                case REPEAT: {
                    break;
                }
                case ABORT: {
                    break;
                }
                case REMOVE: {
                    if (index < 0) break;
                    p.remove(index);
                    break;
                }
                case PUT: {
                    value = decisionMaker.selectValue(result, value);
                    if (index < 0) {
                        p.insertLeaf(p.getKeyCount(), key, value);
                        break;
                    }
                    p.setKey(index, key);
                    p.setValue(index, value);
                }
            }
            return (V)result;
        }
        if (value == null) {
            for (int i = 0; i < p.getKeyCount(); ++i) {
                if (!this.contains(p, i, key)) continue;
                Page cOld = p.getChildPage(i);
                Page c = cOld.copy(true);
                long oldSize = c.getTotalCount();
                result = this.operate(c, key, value, decisionMaker);
                p.setChild(i, c);
                if (oldSize == c.getTotalCount()) {
                    decisionMaker.reset();
                    continue;
                }
                if (c.getTotalCount() == 0L) {
                    p.remove(i);
                    if (p.getKeyCount() == 0) {
                        c.removePage();
                    }
                } else {
                    Object oldBounds = p.getKey(i);
                    if (!this.keyType.isInside(key, oldBounds)) {
                        p.setKey(i, this.getBounds(c));
                    }
                }
                break;
            }
        } else {
            Page c;
            int index = -1;
            for (int i = 0; i < p.getKeyCount(); ++i) {
                if (!this.contains(p, i, key)) continue;
                Page c2 = p.getChildPage(i);
                if (this.get(c2, key) != null) {
                    index = i;
                    break;
                }
                if (index >= 0) continue;
                index = i;
            }
            if (index < 0) {
                float min = Float.MAX_VALUE;
                for (int i = 0; i < p.getKeyCount(); ++i) {
                    Object k = p.getKey(i);
                    float areaIncrease = this.keyType.getAreaIncrease(k, key);
                    if (!(areaIncrease < min)) continue;
                    index = i;
                    min = areaIncrease;
                }
            }
            if ((c = p.getChildPage(index).copy(true)).getKeyCount() > this.store.getKeysPerPage() || (long)c.getMemory() > this.store.getMaxPageSize() && c.getKeyCount() > 4) {
                Page split = this.split(c);
                p.setKey(index, this.getBounds(c));
                p.setChild(index, c);
                p.insertNode(index, this.getBounds(split), split);
                result = this.operate(p, key, value, decisionMaker);
            } else {
                result = this.operate(c, key, value, decisionMaker);
                Object bounds = p.getKey(index);
                if (!this.keyType.contains(bounds, key)) {
                    bounds = this.keyType.createBoundingBox(bounds);
                    this.keyType.increaseBounds(bounds, key);
                    p.setKey(index, bounds);
                }
                p.setChild(index, c);
            }
        }
        return (V)result;
    }

    private Object getBounds(Page x) {
        Object bounds = this.keyType.createBoundingBox(x.getKey(0));
        int keyCount = x.getKeyCount();
        for (int i = 1; i < keyCount; ++i) {
            this.keyType.increaseBounds(bounds, x.getKey(i));
        }
        return bounds;
    }

    @Override
    public V put(SpatialKey key, V value) {
        return (V)this.operate(key, value, MVMap.DecisionMaker.PUT);
    }

    public void add(SpatialKey key, V value) {
        this.operate(key, value, MVMap.DecisionMaker.PUT);
    }

    private Page split(Page p) {
        return this.quadraticSplit ? this.splitQuadratic(p) : this.splitLinear(p);
    }

    private Page splitLinear(Page p) {
        int keyCount = p.getKeyCount();
        ArrayList<Object> keys = new ArrayList<Object>(keyCount);
        for (int i = 0; i < keyCount; ++i) {
            keys.add(p.getKey(i));
        }
        int[] extremes = this.keyType.getExtremes(keys);
        if (extremes == null) {
            return this.splitQuadratic(p);
        }
        Page splitA = this.newPage(p.isLeaf());
        Page splitB = this.newPage(p.isLeaf());
        MVRTreeMap.move(p, splitA, extremes[0]);
        if (extremes[1] > extremes[0]) {
            extremes[1] = extremes[1] - 1;
        }
        MVRTreeMap.move(p, splitB, extremes[1]);
        Object boundsA = this.keyType.createBoundingBox(splitA.getKey(0));
        Object boundsB = this.keyType.createBoundingBox(splitB.getKey(0));
        while (p.getKeyCount() > 0) {
            float b;
            Object o = p.getKey(0);
            float a = this.keyType.getAreaIncrease(boundsA, o);
            if (a < (b = this.keyType.getAreaIncrease(boundsB, o))) {
                this.keyType.increaseBounds(boundsA, o);
                MVRTreeMap.move(p, splitA, 0);
                continue;
            }
            this.keyType.increaseBounds(boundsB, o);
            MVRTreeMap.move(p, splitB, 0);
        }
        while (splitB.getKeyCount() > 0) {
            MVRTreeMap.move(splitB, p, 0);
        }
        return splitA;
    }

    private Page splitQuadratic(Page p) {
        Page splitA = this.newPage(p.isLeaf());
        Page splitB = this.newPage(p.isLeaf());
        float largest = Float.MIN_VALUE;
        int ia = 0;
        int ib = 0;
        int keyCount = p.getKeyCount();
        for (int a = 0; a < keyCount; ++a) {
            Object objA = p.getKey(a);
            for (int b = 0; b < keyCount; ++b) {
                Object objB;
                float area;
                if (a == b || !((area = this.keyType.getCombinedArea(objA, objB = p.getKey(b))) > largest)) continue;
                largest = area;
                ia = a;
                ib = b;
            }
        }
        MVRTreeMap.move(p, splitA, ia);
        if (ia < ib) {
            --ib;
        }
        MVRTreeMap.move(p, splitB, ib);
        Object boundsA = this.keyType.createBoundingBox(splitA.getKey(0));
        Object boundsB = this.keyType.createBoundingBox(splitB.getKey(0));
        while (p.getKeyCount() > 0) {
            float diff = 0.0f;
            float bestA = 0.0f;
            float bestB = 0.0f;
            int best = 0;
            keyCount = p.getKeyCount();
            for (int i = 0; i < keyCount; ++i) {
                float incB;
                Object o = p.getKey(i);
                float incA = this.keyType.getAreaIncrease(boundsA, o);
                float d = Math.abs(incA - (incB = this.keyType.getAreaIncrease(boundsB, o)));
                if (!(d > diff)) continue;
                diff = d;
                bestA = incA;
                bestB = incB;
                best = i;
            }
            if (bestA < bestB) {
                this.keyType.increaseBounds(boundsA, p.getKey(best));
                MVRTreeMap.move(p, splitA, best);
                continue;
            }
            this.keyType.increaseBounds(boundsB, p.getKey(best));
            MVRTreeMap.move(p, splitB, best);
        }
        while (splitB.getKeyCount() > 0) {
            MVRTreeMap.move(splitB, p, 0);
        }
        return splitA;
    }

    private Page newPage(boolean leaf) {
        Page page;
        Page page2 = page = leaf ? this.createEmptyLeaf() : this.createEmptyNode();
        if (this.store.getFileStore() != null) {
            this.store.registerUnsavedPage(page.getMemory());
        }
        return page;
    }

    private static void move(Page source, Page target, int sourceIndex) {
        Object k = source.getKey(sourceIndex);
        if (source.isLeaf()) {
            Object v = source.getValue(sourceIndex);
            target.insertLeaf(0, k, v);
        } else {
            Page c = source.getChildPage(sourceIndex);
            target.insertNode(0, k, c);
        }
        source.remove(sourceIndex);
    }

    public void addNodeKeys(ArrayList<SpatialKey> list, Page p) {
        if (p != null && !p.isLeaf()) {
            int keyCount = p.getKeyCount();
            for (int i = 0; i < keyCount; ++i) {
                list.add((SpatialKey)p.getKey(i));
                this.addNodeKeys(list, p.getChildPage(i));
            }
        }
    }

    public boolean isQuadraticSplit() {
        return this.quadraticSplit;
    }

    public void setQuadraticSplit(boolean quadraticSplit) {
        this.quadraticSplit = quadraticSplit;
    }

    @Override
    protected int getChildPageCount(Page p) {
        return p.getRawChildPageCount() - 1;
    }

    @Override
    public String getType() {
        return "rtree";
    }

    public static class Builder<V>
    extends MVMap.BasicBuilder<MVRTreeMap<V>, SpatialKey, V> {
        private int dimensions = 2;

        public Builder() {
            this.setKeyType(new SpatialDataType(this.dimensions));
        }

        public Builder<V> dimensions(int dimensions) {
            this.dimensions = dimensions;
            this.setKeyType(new SpatialDataType(dimensions));
            return this;
        }

        public Builder<V> valueType(DataType valueType) {
            this.setValueType(valueType);
            return this;
        }

        @Override
        public MVRTreeMap<V> create(Map<String, Object> config) {
            return new MVRTreeMap(config);
        }
    }

    public static class RTreeCursor
    implements Iterator<SpatialKey> {
        private final SpatialKey filter;
        private CursorPos pos;
        private SpatialKey current;
        private final Page root;
        private boolean initialized;

        protected RTreeCursor(Page root, SpatialKey filter) {
            this.root = root;
            this.filter = filter;
        }

        @Override
        public boolean hasNext() {
            if (!this.initialized) {
                this.pos = new CursorPos(this.root, 0, null);
                this.fetchNext();
                this.initialized = true;
            }
            return this.current != null;
        }

        public void skip(long n) {
            while (this.hasNext() && n-- > 0L) {
                this.fetchNext();
            }
        }

        @Override
        public SpatialKey next() {
            if (!this.hasNext()) {
                return null;
            }
            SpatialKey c = this.current;
            this.fetchNext();
            return c;
        }

        @Override
        public void remove() {
            throw DataUtils.newUnsupportedOperationException("Removing is not supported");
        }

        protected void fetchNext() {
            while (this.pos != null) {
                Page p = this.pos.page;
                if (p.isLeaf()) {
                    while (this.pos.index < p.getKeyCount()) {
                        SpatialKey c = (SpatialKey)p.getKey(this.pos.index++);
                        if (this.filter != null && !this.check(true, c, this.filter)) continue;
                        this.current = c;
                        return;
                    }
                } else {
                    boolean found = false;
                    while (this.pos.index < p.getKeyCount()) {
                        int index;
                        ++this.pos.index;
                        SpatialKey c = (SpatialKey)p.getKey(index);
                        if (this.filter != null && !this.check(false, c, this.filter)) continue;
                        Page child = this.pos.page.getChildPage(index);
                        this.pos = new CursorPos(child, 0, this.pos);
                        found = true;
                        break;
                    }
                    if (found) continue;
                }
                this.pos = this.pos.parent;
            }
            this.current = null;
        }

        protected boolean check(boolean leaf, SpatialKey key, SpatialKey test) {
            return true;
        }
    }
}

