/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.result;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeMap;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.engine.SessionInterface;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.mvstore.db.MVTempResult;
import org.gridgain.internal.h2.result.LocalResult;
import org.gridgain.internal.h2.result.ResultExternal;
import org.gridgain.internal.h2.result.SortOrder;
import org.gridgain.internal.h2.util.Utils;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueRow;

public class LocalResultImpl
implements LocalResult {
    private int maxMemoryRows;
    private Session session;
    private int visibleColumnCount;
    private Expression[] expressions;
    private int rowId;
    private int rowCount;
    private ArrayList<Value[]> rows;
    private SortOrder sort;
    private TreeMap<Value, Value[]> distinctRows;
    private Value[] currentRow;
    private int offset;
    private int limit = -1;
    private boolean fetchPercent;
    private SortOrder withTiesSortOrder;
    private boolean limitsWereApplied;
    private ResultExternal external;
    private boolean distinct;
    private int[] distinctIndexes;
    private boolean closed;
    private boolean containsLobs;
    private Boolean containsNull;

    public LocalResultImpl() {
    }

    public LocalResultImpl(Session session, Expression[] expressions, int visibleColumnCount) {
        Database db;
        this.session = session;
        this.maxMemoryRows = session == null ? Integer.MAX_VALUE : ((db = session.getDatabase()).isPersistent() && !db.isReadOnly() ? session.getDatabase().getMaxMemoryRows() : Integer.MAX_VALUE);
        this.rows = Utils.newSmallArrayList();
        this.visibleColumnCount = visibleColumnCount;
        this.rowId = -1;
        this.expressions = expressions;
    }

    @Override
    public boolean isLazy() {
        return false;
    }

    @Override
    public void setMaxMemoryRows(int maxValue) {
        this.maxMemoryRows = maxValue;
    }

    @Override
    public LocalResultImpl createShallowCopy(SessionInterface targetSession) {
        if (this.external == null && (this.rows == null || this.rows.size() < this.rowCount)) {
            return null;
        }
        if (this.containsLobs) {
            return null;
        }
        ResultExternal e2 = null;
        if (this.external != null && (e2 = this.external.createShallowCopy()) == null) {
            return null;
        }
        LocalResultImpl copy = new LocalResultImpl();
        copy.maxMemoryRows = this.maxMemoryRows;
        copy.session = (Session)targetSession;
        copy.visibleColumnCount = this.visibleColumnCount;
        copy.expressions = this.expressions;
        copy.rowId = -1;
        copy.rowCount = this.rowCount;
        copy.rows = this.rows;
        copy.sort = this.sort;
        copy.distinctRows = this.distinctRows;
        copy.distinct = this.distinct;
        copy.distinctIndexes = this.distinctIndexes;
        copy.currentRow = null;
        copy.offset = 0;
        copy.limit = -1;
        copy.external = e2;
        copy.containsNull = this.containsNull;
        return copy;
    }

    @Override
    public void setSortOrder(SortOrder sort) {
        this.sort = sort;
    }

    @Override
    public void setDistinct() {
        assert (this.distinctIndexes == null);
        this.distinct = true;
        this.distinctRows = new TreeMap(this.session.getDatabase().getCompareMode());
    }

    @Override
    public void setDistinct(int[] distinctIndexes) {
        assert (!this.distinct);
        this.distinctIndexes = distinctIndexes;
        this.distinctRows = new TreeMap(this.session.getDatabase().getCompareMode());
    }

    private boolean isAnyDistinct() {
        return this.distinct || this.distinctIndexes != null;
    }

    @Override
    public void removeDistinct(Value[] values) {
        if (!this.distinct) {
            DbException.throwInternalError();
        }
        assert (values.length == this.visibleColumnCount);
        if (this.distinctRows != null) {
            ValueRow array = ValueRow.get(values);
            this.distinctRows.remove(array);
            this.rowCount = this.distinctRows.size();
        } else {
            this.rowCount = this.external.removeRow(values);
        }
    }

    @Override
    public boolean containsDistinct(Value[] values) {
        ValueRow array;
        assert (values.length == this.visibleColumnCount);
        if (this.external != null) {
            return this.external.contains(values);
        }
        if (this.distinctRows == null) {
            this.distinctRows = new TreeMap(this.session.getDatabase().getCompareMode());
            for (Value[] row : this.rows) {
                ValueRow array2 = this.getDistinctRow(row);
                this.distinctRows.put(array2, array2.getList());
            }
        }
        return this.distinctRows.get(array = ValueRow.get(values)) != null;
    }

    @Override
    public boolean containsNull() {
        Boolean r = this.containsNull;
        if (r == null) {
            r = false;
            this.reset();
            block0: while (this.next()) {
                Value[] row = this.currentRow;
                for (int i = 0; i < this.visibleColumnCount; ++i) {
                    if (!row[i].containsNull()) continue;
                    r = true;
                    break block0;
                }
            }
            this.reset();
            this.containsNull = r;
        }
        return r;
    }

    @Override
    public void reset() {
        this.rowId = -1;
        this.currentRow = null;
        if (this.external != null) {
            this.external.reset();
        }
    }

    @Override
    public Value[] currentRow() {
        return this.currentRow;
    }

    @Override
    public boolean next() {
        if (!this.closed && this.rowId < this.rowCount) {
            ++this.rowId;
            if (this.rowId < this.rowCount) {
                this.currentRow = this.external != null ? this.external.next() : this.rows.get(this.rowId);
                return true;
            }
            this.currentRow = null;
        }
        return false;
    }

    @Override
    public int getRowId() {
        return this.rowId;
    }

    @Override
    public boolean isAfterLast() {
        return this.rowId >= this.rowCount;
    }

    private void cloneLobs(Value[] values) {
        for (int i = 0; i < values.length; ++i) {
            Value v = values[i];
            Value v2 = v.copyToResult();
            if (v2 == v) continue;
            this.containsLobs = true;
            this.session.addTemporaryLob(v2);
            values[i] = v2;
        }
    }

    private ValueRow getDistinctRow(Value[] values) {
        if (this.distinctIndexes != null) {
            int cnt = this.distinctIndexes.length;
            Value[] newValues = new Value[cnt];
            for (int i = 0; i < cnt; ++i) {
                newValues[i] = values[this.distinctIndexes[i]];
            }
            values = newValues;
        } else if (values.length > this.visibleColumnCount) {
            values = Arrays.copyOf(values, this.visibleColumnCount);
        }
        return ValueRow.get(values);
    }

    private void createExternalResult() {
        this.external = MVTempResult.of(this.session.getDatabase(), this.expressions, this.distinct, this.distinctIndexes, this.visibleColumnCount, this.sort);
    }

    @Override
    public void addRow(Value[] values) {
        this.cloneLobs(values);
        if (this.isAnyDistinct()) {
            if (this.distinctRows != null) {
                ValueRow array = this.getDistinctRow(values);
                Value[] previous = this.distinctRows.get(array);
                if (previous == null || this.sort != null && this.sort.compare(previous, values) > 0) {
                    this.distinctRows.put(array, values);
                }
                this.rowCount = this.distinctRows.size();
                if (this.rowCount > this.maxMemoryRows) {
                    this.createExternalResult();
                    this.rowCount = this.external.addRows(this.distinctRows.values());
                    this.distinctRows = null;
                }
            } else {
                this.rowCount = this.external.addRow(values);
            }
        } else {
            this.rows.add(values);
            ++this.rowCount;
            if (this.rows.size() > this.maxMemoryRows) {
                this.addRowsToDisk();
            }
        }
    }

    private void addRowsToDisk() {
        if (this.external == null) {
            this.createExternalResult();
        }
        this.rowCount = this.external.addRows(this.rows);
        this.rows.clear();
    }

    @Override
    public int getVisibleColumnCount() {
        return this.visibleColumnCount;
    }

    @Override
    public void done() {
        if (this.external != null) {
            this.addRowsToDisk();
        } else {
            if (this.isAnyDistinct()) {
                this.rows = new ArrayList<Value[]>(this.distinctRows.values());
            }
            if (this.sort != null && this.limit != 0 && !this.limitsWereApplied) {
                boolean withLimit;
                boolean bl = withLimit = this.limit > 0 && this.withTiesSortOrder == null;
                if (this.offset > 0 || withLimit) {
                    this.sort.sort(this.rows, this.offset, withLimit ? this.limit : this.rows.size());
                } else {
                    this.sort.sort(this.rows);
                }
            }
        }
        this.applyOffsetAndLimit();
        this.reset();
    }

    private void applyOffsetAndLimit() {
        boolean clearAll;
        if (this.limitsWereApplied) {
            return;
        }
        int offset = Math.max(this.offset, 0);
        int limit = this.limit;
        if (offset == 0 && limit < 0 && !this.fetchPercent || this.rowCount == 0) {
            return;
        }
        if (this.fetchPercent) {
            if (limit < 0 || limit > 100) {
                throw DbException.getInvalidValueException("FETCH PERCENT", limit);
            }
            limit = (int)(((long)limit * (long)this.rowCount + 99L) / 100L);
        }
        boolean bl = clearAll = offset >= this.rowCount || limit == 0;
        if (!clearAll) {
            int remaining = this.rowCount - offset;
            int n = limit = limit < 0 ? remaining : Math.min(remaining, limit);
            if (offset == 0 && remaining <= limit) {
                return;
            }
        } else {
            limit = 0;
        }
        this.distinctRows = null;
        this.rowCount = limit;
        if (this.external == null) {
            if (clearAll) {
                this.rows.clear();
                return;
            }
            int to = offset + limit;
            if (this.withTiesSortOrder != null) {
                Value[] expected = this.rows.get(to - 1);
                while (to < this.rows.size() && this.withTiesSortOrder.compare(expected, this.rows.get(to)) == 0) {
                    ++to;
                    ++this.rowCount;
                }
            }
            if (offset != 0 || to != this.rows.size()) {
                this.rows = new ArrayList<Value[]>(this.rows.subList(offset, to));
            }
        } else {
            if (clearAll) {
                this.external.close();
                this.external = null;
                return;
            }
            this.trimExternal(offset, limit);
        }
    }

    private void trimExternal(int offset, int limit) {
        ResultExternal temp = this.external;
        this.external = null;
        temp.reset();
        while (--offset >= 0) {
            temp.next();
        }
        Value[] row = null;
        while (--limit >= 0) {
            row = temp.next();
            this.rows.add(row);
            if (this.rows.size() <= this.maxMemoryRows) continue;
            this.addRowsToDisk();
        }
        if (this.withTiesSortOrder != null && row != null) {
            Value[] expected = row;
            while ((row = temp.next()) != null && this.withTiesSortOrder.compare(expected, row) == 0) {
                this.rows.add(row);
                ++this.rowCount;
                if (this.rows.size() <= this.maxMemoryRows) continue;
                this.addRowsToDisk();
            }
        }
        if (this.external != null) {
            this.addRowsToDisk();
        }
        temp.close();
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public void limitsWereApplied() {
        this.limitsWereApplied = true;
    }

    @Override
    public boolean hasNext() {
        return !this.closed && this.rowId < this.rowCount - 1;
    }

    @Override
    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Override
    public void setFetchPercent(boolean fetchPercent) {
        this.fetchPercent = fetchPercent;
    }

    @Override
    public void setWithTies(SortOrder withTiesSortOrder) {
        assert (this.sort == null || this.sort == withTiesSortOrder);
        this.withTiesSortOrder = withTiesSortOrder;
    }

    @Override
    public boolean needToClose() {
        return this.external != null;
    }

    @Override
    public void close() {
        if (this.external != null) {
            this.external.close();
            this.external = null;
            this.closed = true;
        }
    }

    @Override
    public String getAlias(int i) {
        return this.expressions[i].getAlias();
    }

    @Override
    public String getTableName(int i) {
        return this.expressions[i].getTableName();
    }

    @Override
    public String getSchemaName(int i) {
        return this.expressions[i].getSchemaName();
    }

    @Override
    public String getColumnName(int i) {
        return this.expressions[i].getColumnName();
    }

    @Override
    public TypeInfo getColumnType(int i) {
        return this.expressions[i].getType();
    }

    @Override
    public int getNullable(int i) {
        return this.expressions[i].getNullable();
    }

    @Override
    public boolean isAutoIncrement(int i) {
        return this.expressions[i].isAutoIncrement();
    }

    @Override
    public void setOffset(int offset) {
        this.offset = offset;
    }

    public String toString() {
        return super.toString() + " columns: " + this.visibleColumnCount + " rows: " + this.rowCount + " pos: " + this.rowId;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public int getFetchSize() {
        return 0;
    }

    @Override
    public void setFetchSize(int fetchSize) {
    }
}

