/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.security.auth;

import org.gridgain.internal.h2.engine.ConnectionInfo;
import org.gridgain.internal.h2.util.StringUtils;

public class AuthenticationInfo {
    private ConnectionInfo connectionInfo;
    private String password;
    private String realm;
    Object nestedIdentity;

    public AuthenticationInfo(ConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
        this.realm = connectionInfo.getProperty("AUTHREALM", null);
        if (this.realm != null) {
            this.realm = StringUtils.toUpperEnglish(this.realm);
        }
        this.password = connectionInfo.getProperty("AUTHZPWD", null);
    }

    public String getUserName() {
        return this.connectionInfo.getUserName();
    }

    public String getRealm() {
        return this.realm;
    }

    public String getPassword() {
        return this.password;
    }

    public ConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    public String getFullyQualifiedName() {
        if (this.realm == null) {
            return this.connectionInfo.getUserName();
        }
        return this.connectionInfo.getUserName() + "@" + this.realm;
    }

    public Object getNestedIdentity() {
        return this.nestedIdentity;
    }

    public void setNestedIdentity(Object nestedIdentity) {
        this.nestedIdentity = nestedIdentity;
    }

    public void clean() {
        this.password = null;
        this.nestedIdentity = null;
        this.connectionInfo.cleanAuthenticationInfo();
    }
}

