/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.store.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonWritableChannelException;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.gridgain.internal.h2.store.fs.FileBase;

class FileAsync
extends FileBase {
    private static final OpenOption[] R = new OpenOption[]{StandardOpenOption.READ};
    private static final OpenOption[] W = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE};
    private static final OpenOption[] RWS = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.SYNC};
    private static final OpenOption[] RWD = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.DSYNC};
    private final String name;
    private final AsynchronousFileChannel channel;
    private long position;

    /*
     * Loose catch block
     */
    private static <T> T complete(Future<T> future) throws IOException {
        boolean interrupted = false;
        while (true) {
            try {
                T result = future.get();
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
                return result;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        catch (ExecutionException e) {
            throw new IOException(e.getCause());
        }
    }

    FileAsync(String fileName, String mode) throws IOException {
        OpenOption[] options;
        this.name = fileName;
        switch (mode) {
            case "r": {
                options = R;
                break;
            }
            case "rw": {
                options = W;
                break;
            }
            case "rws": {
                options = RWS;
                break;
            }
            case "rwd": {
                options = RWD;
                break;
            }
            default: {
                throw new IllegalArgumentException(mode);
            }
        }
        this.channel = AsynchronousFileChannel.open(Paths.get(fileName, new String[0]), options);
    }

    @Override
    public void implCloseChannel() throws IOException {
        this.channel.close();
    }

    @Override
    public long position() throws IOException {
        return this.position;
    }

    @Override
    public long size() throws IOException {
        return this.channel.size();
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int read = FileAsync.complete(this.channel.read(dst, this.position));
        if (read > 0) {
            this.position += (long)read;
        }
        return read;
    }

    @Override
    public FileChannel position(long pos) throws IOException {
        if (pos < 0L) {
            throw new IllegalArgumentException();
        }
        this.position = pos;
        return this;
    }

    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        return FileAsync.complete(this.channel.read(dst, position));
    }

    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        try {
            return FileAsync.complete(this.channel.write(src, position));
        }
        catch (NonWritableChannelException e) {
            throw new IOException("read only");
        }
    }

    @Override
    public FileChannel truncate(long newLength) throws IOException {
        this.channel.truncate(newLength);
        if (newLength < this.position) {
            this.position = newLength;
        }
        return this;
    }

    @Override
    public void force(boolean metaData) throws IOException {
        this.channel.force(metaData);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int written;
        try {
            written = FileAsync.complete(this.channel.write(src, this.position));
            this.position += (long)written;
        }
        catch (NonWritableChannelException e) {
            throw new IOException("read only");
        }
        return written;
    }

    @Override
    public synchronized FileLock tryLock(long position, long size, boolean shared) throws IOException {
        return this.channel.tryLock(position, size, shared);
    }

    public String toString() {
        return "async:" + this.name;
    }
}

