/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.table;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.gridgain.internal.h2.command.Parser;
import org.gridgain.internal.h2.command.dml.AllColumnsForPlan;
import org.gridgain.internal.h2.command.dml.Select;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.ExpressionColumn;
import org.gridgain.internal.h2.expression.condition.ConditionAndOr;
import org.gridgain.internal.h2.index.HashJoinIndex;
import org.gridgain.internal.h2.index.Index;
import org.gridgain.internal.h2.index.IndexCondition;
import org.gridgain.internal.h2.index.IndexCursor;
import org.gridgain.internal.h2.index.IndexLookupBatch;
import org.gridgain.internal.h2.index.ViewIndex;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.SearchRow;
import org.gridgain.internal.h2.result.SortOrder;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.ColumnResolver;
import org.gridgain.internal.h2.table.IndexHints;
import org.gridgain.internal.h2.table.JoinBatch;
import org.gridgain.internal.h2.table.PlanItem;
import org.gridgain.internal.h2.table.SubQueryInfo;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.table.TableView;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.util.Utils;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueLong;
import org.gridgain.internal.h2.value.ValueNull;

public class TableFilter
implements ColumnResolver {
    private static final int BEFORE_FIRST = 0;
    private static final int FOUND = 1;
    private static final int AFTER_LAST = 2;
    private static final int NULL_ROW = 3;
    protected boolean joinOuterIndirect;
    private Session session;
    private final Table table;
    private final Select select;
    private String alias;
    private Index index;
    private final IndexHints indexHints;
    private int[] masks;
    private int scanCount;
    private boolean evaluatable;
    private JoinBatch joinBatch;
    private int joinFilterId = -1;
    private boolean used;
    private final IndexCursor cursor;
    private final ArrayList<IndexCondition> indexConditions = Utils.newSmallArrayList();
    private boolean doneWithIndexConditions;
    private Expression filterCondition;
    private Expression joinCondition;
    private SearchRow currentSearchRow;
    private Row current;
    private int state;
    private TableFilter join;
    private boolean joinOuter;
    private TableFilter nestedJoin;
    private ArrayList<Column> naturalJoinColumns;
    private boolean foundOne;
    private Expression fullCondition;
    private final int hashCode;
    private final int orderInFrom;
    private LinkedHashMap<Column, String> derivedColumnMap;

    public TableFilter(Session session, Table table, String alias, boolean rightsChecked, Select select, int orderInFrom, IndexHints indexHints) {
        this.session = session;
        this.table = table;
        this.alias = alias;
        this.select = select;
        this.cursor = new IndexCursor(this);
        if (!rightsChecked) {
            session.getUser().checkRight(table, 1);
        }
        this.hashCode = session.nextObjectId();
        this.orderInFrom = orderInFrom;
        this.indexHints = indexHints;
    }

    public int getOrderInFrom() {
        return this.orderInFrom;
    }

    public IndexCursor getIndexCursor() {
        return this.cursor;
    }

    @Override
    public Select getSelect() {
        return this.select;
    }

    public Table getTable() {
        return this.table;
    }

    public void lock(Session s, boolean exclusive, boolean forceLockEvenInMvcc) {
        this.table.lock(s, exclusive, forceLockEvenInMvcc);
        if (this.join != null) {
            this.join.lock(s, exclusive, forceLockEvenInMvcc);
        }
    }

    public PlanItem getBestPlanItem(Session s, TableFilter[] filters, int filter, AllColumnsForPlan allColumnsSet) {
        SortOrder sortOrder = null;
        if (this.select != null) {
            sortOrder = this.select.getSortOrder();
        }
        PlanItem item1 = null;
        if (this.indexConditions.isEmpty()) {
            item1 = new PlanItem();
            item1.setIndex(this.table.getScanIndex(s, null, filters, filter, sortOrder, allColumnsSet));
            item1.cost = item1.getIndex().getCost(s, null, filters, filter, sortOrder, allColumnsSet);
        }
        int[] masks = IndexCondition.createMasksForTable(this.table, this.indexConditions);
        PlanItem item = this.table.getBestPlanItem(s, masks, filters, filter, sortOrder, allColumnsSet, this.isEquiJoined());
        item.setMasks(masks);
        item.cost -= item.cost * (double)this.indexConditions.size() / 100.0 / (double)(filter + 1);
        if (item1 != null && item1.cost < item.cost) {
            item = item1;
        }
        if (this.nestedJoin != null) {
            this.setEvaluatable(true);
            item.setNestedJoinPlan(this.nestedJoin.getBestPlanItem(s, filters, filter, allColumnsSet));
            item.cost += item.cost * item.getNestedJoinPlan().cost;
        }
        if (this.join != null) {
            this.setEvaluatable(true);
            while (filters[++filter] != this.join) {
            }
            item.setJoinPlan(this.join.getBestPlanItem(s, filters, filter, allColumnsSet));
            item.cost += item.cost * item.getJoinPlan().cost;
        }
        return item;
    }

    private boolean isEquiJoined() {
        for (IndexCondition condition : this.indexConditions) {
            if (!HashJoinIndex.isEquiJoinCondition(condition)) continue;
            return true;
        }
        return false;
    }

    public void setPlanItem(PlanItem item) {
        if (item == null) {
            return;
        }
        this.setIndex(item.getIndex());
        this.masks = item.getMasks();
        if (this.nestedJoin != null) {
            if (item.getNestedJoinPlan() != null) {
                this.nestedJoin.setPlanItem(item.getNestedJoinPlan());
            } else {
                this.nestedJoin.setScanIndexes();
            }
        }
        if (this.join != null) {
            if (item.getJoinPlan() != null) {
                this.join.setPlanItem(item.getJoinPlan());
            } else {
                this.join.setScanIndexes();
            }
        }
    }

    private void setScanIndexes() {
        if (this.index == null) {
            this.setIndex(this.table.getScanIndex(this.session));
        }
        if (this.join != null) {
            this.join.setScanIndexes();
        }
        if (this.nestedJoin != null) {
            this.nestedJoin.setScanIndexes();
        }
    }

    public void prepare() {
        if (this.index.getClass() == HashJoinIndex.class) {
            ((HashJoinIndex)this.index).prepare(this.session, this.indexConditions);
        }
        for (int i = 0; i < this.indexConditions.size(); ++i) {
            Column col;
            IndexCondition condition = this.indexConditions.get(i);
            if (condition.isAlwaysFalse() || (col = condition.getColumn()).getColumnId() < 0 || this.index.getColumnIndex(col) >= 0) continue;
            this.indexConditions.remove(i);
            --i;
        }
        if (this.nestedJoin != null) {
            if (this.nestedJoin == this) {
                DbException.throwInternalError("self join");
            }
            this.nestedJoin.prepare();
        }
        if (this.join != null) {
            if (this.join == this) {
                DbException.throwInternalError("self join");
            }
            this.join.prepare();
        }
        if (this.filterCondition != null) {
            this.filterCondition = this.filterCondition.optimize(this.session);
        }
        if (this.joinCondition != null) {
            this.joinCondition = this.joinCondition.optimize(this.session);
        }
    }

    public void startQuery(Session s) {
        this.session = s;
        this.scanCount = 0;
        if (this.nestedJoin != null) {
            this.nestedJoin.startQuery(s);
        }
        if (this.join != null) {
            this.join.startQuery(s);
        }
    }

    public void reset() {
        if (this.joinBatch != null && this.joinFilterId == 0) {
            this.joinBatch.reset(true);
            return;
        }
        if (this.nestedJoin != null) {
            this.nestedJoin.reset();
        }
        if (this.join != null) {
            this.join.reset();
        }
        this.state = 0;
        this.foundOne = false;
    }

    private boolean isAlwaysTopTableFilter(int filter) {
        if (filter != 0) {
            return false;
        }
        SubQueryInfo info = this.session.getSubQueryInfo();
        while (info != null) {
            if (info.getFilter() != 0) {
                return false;
            }
            info = info.getUpper();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JoinBatch prepareJoinBatch(JoinBatch jb, TableFilter[] filters, int filter) {
        assert (filters[filter] == this);
        this.joinBatch = null;
        this.joinFilterId = -1;
        if (this.getTable().isView()) {
            this.session.pushSubQueryInfo(this.masks, filters, filter, this.select.getSortOrder());
            try {
                ((ViewIndex)this.index).getQuery().prepareJoinBatch();
            }
            finally {
                this.session.popSubQueryInfo();
            }
        }
        IndexLookupBatch lookupBatch = null;
        if (jb == null && this.select != null && !this.isAlwaysTopTableFilter(filter) && (lookupBatch = this.index.createLookupBatch(filters, filter)) != null) {
            jb = new JoinBatch(filter + 1, this.join);
        }
        if (jb != null) {
            if (this.nestedJoin != null) {
                throw DbException.throwInternalError();
            }
            this.joinBatch = jb;
            this.joinFilterId = filter;
            if (lookupBatch == null && !this.isAlwaysTopTableFilter(filter) && (lookupBatch = this.index.createLookupBatch(filters, filter)) == null) {
                lookupBatch = JoinBatch.createFakeIndexLookupBatch(this);
            }
            jb.register(this, lookupBatch);
        }
        return jb;
    }

    public int getJoinFilterId() {
        return this.joinFilterId;
    }

    public JoinBatch getJoinBatch() {
        return this.joinBatch;
    }

    public boolean next() {
        if (this.joinBatch != null) {
            return this.joinBatch.next();
        }
        if (this.state == 2) {
            return false;
        }
        if (this.state == 0) {
            this.cursor.find(this.session, this.indexConditions);
            if (!this.cursor.isAlwaysFalse()) {
                if (this.nestedJoin != null) {
                    this.nestedJoin.reset();
                }
                if (this.join != null) {
                    this.join.reset();
                }
            }
        } else if (this.join != null && this.join.next()) {
            return true;
        }
        while (this.state != 3) {
            if (this.cursor.isAlwaysFalse()) {
                this.state = 2;
            } else if (this.nestedJoin != null) {
                if (this.state == 0) {
                    this.state = 1;
                }
            } else {
                if ((++this.scanCount & 0xFFF) == 0) {
                    this.checkTimeout();
                }
                if (this.cursor.next()) {
                    this.currentSearchRow = this.cursor.getSearchRow();
                    this.current = null;
                    this.state = 1;
                } else {
                    this.state = 2;
                }
            }
            if (this.nestedJoin != null && this.state == 1 && !this.nestedJoin.next()) {
                this.state = 2;
                if (!this.joinOuter || this.foundOne) continue;
            }
            if (this.state == 2) {
                if (!this.joinOuter || this.foundOne) break;
                this.setNullRow();
            }
            if (!this.isOk(this.filterCondition)) continue;
            boolean joinConditionOk = this.isOk(this.joinCondition);
            if (this.state == 1) {
                if (!joinConditionOk) continue;
                this.foundOne = true;
            }
            if (this.join != null) {
                this.join.reset();
                if (!this.join.next()) continue;
            }
            if (this.state != 3 && !joinConditionOk) continue;
            return true;
        }
        this.state = 2;
        return false;
    }

    protected void setNullRow() {
        this.state = 3;
        this.current = this.table.getNullRow();
        this.currentSearchRow = this.current;
        if (this.nestedJoin != null) {
            this.nestedJoin.visit(new TableFilterVisitor(){

                @Override
                public void accept(TableFilter f) {
                    f.setNullRow();
                }
            });
        }
    }

    private void checkTimeout() {
        this.session.checkCanceled();
    }

    boolean isOk(Expression condition) {
        return condition == null || condition.getBooleanValue(this.session);
    }

    public Row get() {
        if (this.current == null && this.currentSearchRow != null) {
            this.current = this.cursor.get();
        }
        return this.current;
    }

    public void set(Row current) {
        this.current = current;
        this.currentSearchRow = current;
    }

    @Override
    public String getTableAlias() {
        if (this.alias != null) {
            return this.alias;
        }
        return this.table.getName();
    }

    public void addIndexCondition(IndexCondition condition) {
        if (!this.doneWithIndexConditions) {
            this.indexConditions.add(condition);
        }
    }

    public void doneWithIndexConditions() {
        this.doneWithIndexConditions = true;
    }

    public void addFilterCondition(Expression condition, boolean isJoin) {
        if (isJoin) {
            this.joinCondition = this.joinCondition == null ? condition : new ConditionAndOr(0, this.joinCondition, condition);
        } else {
            this.filterCondition = this.filterCondition == null ? condition : new ConditionAndOr(0, this.filterCondition, condition);
        }
    }

    public void addJoin(TableFilter filter, boolean outer, Expression on) {
        if (on != null) {
            on.mapColumns(this, 0, 0);
            MapColumnsVisitor visitor = new MapColumnsVisitor(on);
            this.visit(visitor);
            filter.visit(visitor);
        }
        if (this.join == null) {
            this.join = filter;
            filter.joinOuter = outer;
            if (outer) {
                filter.visit(new JOIVisitor());
            }
            if (on != null) {
                filter.mapAndAddFilter(on);
            }
        } else {
            this.join.addJoin(filter, outer, on);
        }
    }

    public void setNestedJoin(TableFilter filter) {
        this.nestedJoin = filter;
    }

    public void mapAndAddFilter(Expression on) {
        on.mapColumns(this, 0, 0);
        this.addFilterCondition(on, true);
        if (this.nestedJoin != null) {
            on.mapColumns(this.nestedJoin, 0, 0);
        }
        if (this.join != null) {
            this.join.mapAndAddFilter(on);
        }
    }

    public void createIndexConditions() {
        if (this.joinCondition != null) {
            this.joinCondition = this.joinCondition.optimize(this.session);
            this.joinCondition.createIndexConditions(this.session, this);
            if (this.nestedJoin != null) {
                this.joinCondition.createIndexConditions(this.session, this.nestedJoin);
            }
        }
        if (this.join != null) {
            this.join.createIndexConditions();
        }
        if (this.nestedJoin != null) {
            this.nestedJoin.createIndexConditions();
        }
    }

    public TableFilter getJoin() {
        return this.join;
    }

    public boolean isJoinOuter() {
        return this.joinOuter;
    }

    public boolean isJoinOuterIndirect() {
        return this.joinOuterIndirect;
    }

    public StringBuilder getPlanSQL(StringBuilder builder, boolean isJoin, boolean alwaysQuote) {
        if (isJoin) {
            if (this.joinOuter) {
                builder.append("LEFT OUTER JOIN ");
            } else {
                builder.append("INNER JOIN ");
            }
        }
        if (this.nestedJoin != null) {
            boolean enclose;
            StringBuilder buffNested = new StringBuilder();
            TableFilter n = this.nestedJoin;
            do {
                n.getPlanSQL(buffNested, n != this.nestedJoin, alwaysQuote).append('\n');
            } while ((n = n.getJoin()) != null);
            String nested = buffNested.toString();
            boolean bl = enclose = !nested.startsWith("(");
            if (enclose) {
                builder.append("(\n");
            }
            StringUtils.indent(builder, nested, 4, false);
            if (enclose) {
                builder.append(')');
            }
            if (isJoin) {
                builder.append(" ON ");
                if (this.joinCondition == null) {
                    builder.append("1=1");
                } else {
                    this.joinCondition.getUnenclosedSQL(builder, alwaysQuote);
                }
            }
            return builder;
        }
        if (this.table.isView() && ((TableView)this.table).isRecursive()) {
            this.table.getSchema().getSQL(builder, alwaysQuote).append('.');
            Parser.quoteIdentifier(builder, this.table.getName(), alwaysQuote);
        } else {
            this.table.getSQL(builder, alwaysQuote);
        }
        if (this.table.isView() && ((TableView)this.table).isInvalid()) {
            throw DbException.get(90109, this.table.getName(), "not compiled");
        }
        if (this.alias != null) {
            builder.append(' ');
            Parser.quoteIdentifier(builder, this.alias, alwaysQuote);
            if (this.derivedColumnMap != null) {
                builder.append('(');
                boolean f = false;
                for (String name : this.derivedColumnMap.values()) {
                    if (f) {
                        builder.append(", ");
                    }
                    f = true;
                    Parser.quoteIdentifier(builder, name, alwaysQuote);
                }
                builder.append(')');
            }
        }
        if (this.indexHints != null) {
            builder.append(" USE INDEX (");
            boolean first = true;
            for (String index : this.indexHints.getAllowedIndexes()) {
                if (!first) {
                    builder.append(", ");
                } else {
                    first = false;
                }
                Parser.quoteIdentifier(builder, index, alwaysQuote);
            }
            builder.append(")");
        }
        if (this.index != null) {
            builder.append('\n');
            StringBuilder planBuilder = new StringBuilder();
            if (this.joinBatch != null) {
                IndexLookupBatch lookupBatch = this.joinBatch.getLookupBatch(this.joinFilterId);
                if (lookupBatch == null) {
                    if (this.joinFilterId != 0) {
                        throw DbException.throwInternalError(Integer.toString(this.joinFilterId));
                    }
                } else {
                    planBuilder.append("batched:").append(lookupBatch.getPlanSQL()).append(' ');
                }
            }
            planBuilder.append(this.index.getPlanSQL());
            if (!this.indexConditions.isEmpty()) {
                planBuilder.append(": ");
                int size = this.indexConditions.size();
                for (int i = 0; i < size; ++i) {
                    if (i > 0) {
                        planBuilder.append("\n    AND ");
                    }
                    planBuilder.append(this.indexConditions.get(i).getSQL(false));
                }
            }
            String plan = StringUtils.quoteRemarkSQL(planBuilder.toString());
            planBuilder.setLength(0);
            planBuilder.append("/* ").append(plan);
            if (plan.indexOf(10) >= 0) {
                planBuilder.append('\n');
            }
            StringUtils.indent(builder, planBuilder.append(" */").toString(), 4, false);
        }
        if (isJoin) {
            builder.append("\n    ON ");
            if (this.joinCondition == null) {
                builder.append("1=1");
            } else {
                this.joinCondition.getUnenclosedSQL(builder, alwaysQuote);
            }
        }
        if (this.filterCondition != null) {
            builder.append('\n');
            String condition = StringUtils.unEnclose(this.filterCondition.getSQL(false));
            condition = "/* WHERE " + StringUtils.quoteRemarkSQL(condition) + "\n*/";
            StringUtils.indent(builder, condition, 4, false);
        }
        if (this.scanCount > 0) {
            builder.append("\n    /* scanCount: ").append(this.scanCount).append(" */");
        }
        return builder;
    }

    void removeUnusableIndexConditions() {
        for (int i = 0; i < this.indexConditions.size(); ++i) {
            IndexCondition cond = this.indexConditions.get(i);
            if (cond.isEvaluatable()) continue;
            this.indexConditions.remove(i--);
        }
    }

    public int[] getMasks() {
        return this.masks;
    }

    public ArrayList<IndexCondition> getIndexConditions() {
        return this.indexConditions;
    }

    public Index getIndex() {
        return this.index;
    }

    public void setIndex(Index index) {
        this.index = index;
        this.cursor.setIndex(index);
    }

    public void setUsed(boolean used) {
        this.used = used;
    }

    public boolean isUsed() {
        return this.used;
    }

    void setSession(Session session) {
        this.session = session;
    }

    public void removeJoin() {
        this.join = null;
    }

    public Expression getJoinCondition() {
        return this.joinCondition;
    }

    public void removeJoinCondition() {
        this.joinCondition = null;
    }

    public Expression getFilterCondition() {
        return this.filterCondition;
    }

    public void removeFilterCondition() {
        this.filterCondition = null;
    }

    public void setFullCondition(Expression condition) {
        this.fullCondition = condition;
        if (this.join != null) {
            this.join.setFullCondition(condition);
        }
    }

    void optimizeFullCondition(boolean fromOuterJoin) {
        if (this.fullCondition != null) {
            this.fullCondition.addFilterConditions(this, fromOuterJoin || this.joinOuter);
            if (this.nestedJoin != null) {
                this.nestedJoin.optimizeFullCondition(fromOuterJoin || this.joinOuter);
            }
            if (this.join != null) {
                this.join.optimizeFullCondition(fromOuterJoin || this.joinOuter);
            }
        }
    }

    public void setEvaluatable(TableFilter filter, boolean b) {
        filter.setEvaluatable(b);
        if (this.filterCondition != null) {
            this.filterCondition.setEvaluatable(filter, b);
        }
        if (this.joinCondition != null) {
            this.joinCondition.setEvaluatable(filter, b);
        }
        if (this.nestedJoin != null && this == filter) {
            this.nestedJoin.setEvaluatable(this.nestedJoin, b);
        }
        if (this.join != null) {
            this.join.setEvaluatable(filter, b);
        }
    }

    public void setEvaluatable(boolean evaluatable) {
        this.evaluatable = evaluatable;
    }

    @Override
    public String getSchemaName() {
        return this.table.getSchema().getName();
    }

    @Override
    public Column[] getColumns() {
        return this.table.getColumns();
    }

    @Override
    public String getDerivedColumnName(Column column) {
        LinkedHashMap<Column, String> map = this.derivedColumnMap;
        return map != null ? (String)((HashMap)map).get(column) : null;
    }

    @Override
    public Column[] getSystemColumns() {
        if (!this.session.getDatabase().getMode().systemColumns) {
            return null;
        }
        Column[] sys = new Column[3];
        sys[0] = new Column("oid", 4);
        sys[0].setTable(this.table, 0);
        sys[1] = new Column("ctid", 13);
        sys[1].setTable(this.table, 0);
        sys[2] = new Column("CTID", 13);
        sys[2].setTable(this.table, 0);
        return sys;
    }

    @Override
    public Column getRowIdColumn() {
        return this.table.getRowIdColumn();
    }

    @Override
    public Value getValue(Column column) {
        if (this.joinBatch != null) {
            return this.joinBatch.getValue(this.joinFilterId, column);
        }
        if (this.currentSearchRow == null) {
            return null;
        }
        int columnId = column.getColumnId();
        if (columnId == -1) {
            return ValueLong.get(this.currentSearchRow.getKey());
        }
        if (this.current == null) {
            Value v = this.currentSearchRow.getValue(columnId);
            if (v != null) {
                return v;
            }
            this.current = this.cursor.get();
            if (this.current == null) {
                return ValueNull.INSTANCE;
            }
        }
        return this.current.getValue(columnId);
    }

    @Override
    public TableFilter getTableFilter() {
        return this;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setDerivedColumns(ArrayList<String> derivedColumnNames) {
        Column[] columns = this.getColumns();
        int count = columns.length;
        if (count != derivedColumnNames.size()) {
            throw DbException.get(21002);
        }
        LinkedHashMap<Column, String> map = new LinkedHashMap<Column, String>();
        for (int i = 0; i < count; ++i) {
            String alias = derivedColumnNames.get(i);
            for (int j = 0; j < i; ++j) {
                if (!alias.equals(derivedColumnNames.get(j))) continue;
                throw DbException.get(42121, alias);
            }
            map.put(columns[i], alias);
        }
        this.derivedColumnMap = map;
    }

    @Override
    public Expression optimize(ExpressionColumn expressionColumn, Column column) {
        return expressionColumn;
    }

    public String toString() {
        return this.alias != null ? this.alias : this.table.toString();
    }

    public void addNaturalJoinColumn(Column c) {
        if (this.naturalJoinColumns == null) {
            this.naturalJoinColumns = Utils.newSmallArrayList();
        }
        this.naturalJoinColumns.add(c);
    }

    public boolean isNaturalJoinColumn(Column c) {
        return this.naturalJoinColumns != null && this.naturalJoinColumns.contains(c);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean hasInComparisons() {
        for (IndexCondition cond : this.indexConditions) {
            int compareType = cond.getCompareType();
            if (compareType != 10 && compareType != 9) continue;
            return true;
        }
        return false;
    }

    public void lockRowAdd(ArrayList<Row> rows) {
        if (this.state == 1) {
            rows.add(this.get());
        }
    }

    public TableFilter getNestedJoin() {
        return this.nestedJoin;
    }

    public void visit(TableFilterVisitor visitor) {
        TableFilter f = this;
        do {
            visitor.accept(f);
            TableFilter n = f.nestedJoin;
            if (n == null) continue;
            n.visit(visitor);
        } while ((f = f.join) != null);
    }

    public boolean isEvaluatable() {
        return this.evaluatable;
    }

    public Session getSession() {
        return this.session;
    }

    public IndexHints getIndexHints() {
        return this.indexHints;
    }

    public void cleanup() {
        this.current = null;
        this.currentSearchRow = null;
        try {
            this.cursor.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final class JOIVisitor
    implements TableFilterVisitor {
        JOIVisitor() {
        }

        @Override
        public void accept(TableFilter f) {
            f.joinOuterIndirect = true;
        }
    }

    private static final class MapColumnsVisitor
    implements TableFilterVisitor {
        private final Expression on;

        MapColumnsVisitor(Expression on) {
            this.on = on;
        }

        @Override
        public void accept(TableFilter f) {
            this.on.mapColumns(f, 0, 0);
        }
    }

    public static interface TableFilterVisitor {
        public void accept(TableFilter var1);
    }
}

