/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.util;

import java.util.HashMap;
import java.util.Iterator;
import org.gridgain.internal.h2.message.DbException;

public class SmallMap {
    private final HashMap<Integer, Object> map = new HashMap();
    private Object cache;
    private int cacheId;
    private int lastId;
    private final int maxElements;

    public SmallMap(int maxElements) {
        this.maxElements = maxElements;
    }

    public int addObject(int id, Object o) {
        if (this.map.size() > this.maxElements * 2) {
            Iterator<Integer> it = this.map.keySet().iterator();
            while (it.hasNext()) {
                Integer k = it.next();
                if (k + this.maxElements >= this.lastId) continue;
                it.remove();
            }
        }
        if (id > this.lastId) {
            this.lastId = id;
        }
        this.map.put(id, o);
        this.cacheId = id;
        this.cache = o;
        return id;
    }

    public void freeObject(int id) {
        if (this.cacheId == id) {
            this.cacheId = -1;
            this.cache = null;
        }
        this.map.remove(id);
    }

    public Object getObject(int id, boolean ifAvailable) {
        if (id == this.cacheId) {
            return this.cache;
        }
        Object obj = this.map.get(id);
        if (obj == null && !ifAvailable) {
            throw DbException.get(90007);
        }
        return obj;
    }
}

