/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.value.CompareMode;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;

public class ValueByte
extends Value {
    static final int PRECISION = 3;
    static final int DISPLAY_SIZE = 4;
    private final byte value;

    private ValueByte(byte value) {
        this.value = value;
    }

    @Override
    public Value add(Value v) {
        ValueByte other = (ValueByte)v;
        return ValueByte.checkRange(this.value + other.value);
    }

    private static ValueByte checkRange(int x) {
        if ((byte)x != x) {
            throw DbException.get(22003, Integer.toString(x));
        }
        return ValueByte.get((byte)x);
    }

    @Override
    public int getSignum() {
        return Integer.signum(this.value);
    }

    @Override
    public Value negate() {
        return ValueByte.checkRange(-this.value);
    }

    @Override
    public Value subtract(Value v) {
        ValueByte other = (ValueByte)v;
        return ValueByte.checkRange(this.value - other.value);
    }

    @Override
    public Value multiply(Value v) {
        ValueByte other = (ValueByte)v;
        return ValueByte.checkRange(this.value * other.value);
    }

    @Override
    public Value divide(Value v) {
        ValueByte other = (ValueByte)v;
        if (other.value == 0) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueByte.checkRange(this.value / other.value);
    }

    @Override
    public Value modulus(Value v) {
        ValueByte other = (ValueByte)v;
        if (other.value == 0) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueByte.get((byte)(this.value % other.value));
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder) {
        return builder.append(this.value);
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_BYTE;
    }

    @Override
    public int getValueType() {
        return 2;
    }

    @Override
    public byte getByte() {
        return this.value;
    }

    @Override
    public int getInt() {
        return this.value;
    }

    @Override
    public int compareTypeSafe(Value o, CompareMode mode) {
        return Integer.compare(this.value, ((ValueByte)o).value);
    }

    @Override
    public String getString() {
        return Integer.toString(this.value);
    }

    @Override
    public int hashCode() {
        return this.value;
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setByte(parameterIndex, this.value);
    }

    public static ValueByte get(byte i) {
        return (ValueByte)Value.cache(new ValueByte(i));
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ValueByte && this.value == ((ValueByte)other).value;
    }
}

