/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.command.ddl;

import org.gridgain.internal.h2.command.ddl.DefineCommand;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.Domain;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.value.DataType;

public class CreateDomain
extends DefineCommand {
    private String typeName;
    private Column column;
    private boolean ifNotExists;

    public CreateDomain(Session session) {
        super(session);
    }

    public void setTypeName(String name) {
        this.typeName = name;
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    @Override
    public int update() {
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database db = this.session.getDatabase();
        this.session.getUser().checkAdmin();
        if (db.findDomain(this.typeName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw DbException.get(90119, this.typeName);
        }
        DataType builtIn = DataType.getTypeByName(this.typeName, this.session.getDatabase().getMode());
        if (builtIn != null) {
            if (!builtIn.hidden) {
                throw DbException.get(90119, this.typeName);
            }
            Table table = this.session.getDatabase().getFirstUserTable();
            if (table != null) {
                StringBuilder builder = new StringBuilder(this.typeName).append(" (");
                table.getSQL(builder, false).append(')');
                throw DbException.get(90119, builder.toString());
            }
        }
        int id = this.getObjectId();
        Domain type = new Domain(db, id, this.typeName);
        type.setColumn(this.column);
        db.addDatabaseObject(this.session, type);
        return 0;
    }

    @Override
    public int getType() {
        return 33;
    }
}

