/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.command.ddl;

import java.util.ArrayList;
import java.util.Iterator;
import org.gridgain.internal.h2.command.ddl.DefineCommand;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.DbObject;
import org.gridgain.internal.h2.engine.DbObjectBase;
import org.gridgain.internal.h2.engine.Role;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.engine.User;
import org.gridgain.internal.h2.schema.Schema;
import org.gridgain.internal.h2.schema.SchemaObject;
import org.gridgain.internal.h2.schema.Sequence;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.table.TableType;

public class DropDatabase
extends DefineCommand {
    private boolean dropAllObjects;
    private boolean deleteFiles;

    public DropDatabase(Session session) {
        super(session);
    }

    @Override
    public int update() {
        if (this.dropAllObjects) {
            this.dropAllObjects();
        }
        if (this.deleteFiles) {
            this.session.getDatabase().setDeleteFilesOnDisconnect(true);
        }
        return 0;
    }

    private void dropAllObjects() {
        boolean runLoopAgain;
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database db = this.session.getDatabase();
        db.lockMeta(this.session);
        do {
            ArrayList<Table> tables = db.getAllTablesAndViews(false);
            ArrayList<Table> arrayList = new ArrayList<Table>(tables.size());
            Iterator<Table> iterator = tables.iterator();
            while (iterator.hasNext()) {
                Table table = iterator.next();
                if (table.getName() == null || TableType.VIEW != table.getTableType()) continue;
                arrayList.add(table);
            }
            iterator = tables.iterator();
            while (iterator.hasNext()) {
                Table table = iterator.next();
                if (table.getName() == null || TableType.TABLE_LINK != table.getTableType()) continue;
                arrayList.add(table);
            }
            iterator = tables.iterator();
            while (iterator.hasNext()) {
                Table table = iterator.next();
                if (table.getName() == null || TableType.TABLE != table.getTableType() || table.isHidden()) continue;
                arrayList.add(table);
            }
            iterator = tables.iterator();
            while (iterator.hasNext()) {
                Table table = iterator.next();
                if (table.getName() == null || TableType.EXTERNAL_TABLE_ENGINE != table.getTableType() || table.isHidden()) continue;
                arrayList.add(table);
            }
            runLoopAgain = false;
            for (Table table : arrayList) {
                if (table.getName() == null) continue;
                if (db.getDependentTable(table, table) == null) {
                    db.removeSchemaObject(this.session, table);
                    continue;
                }
                runLoopAgain = true;
            }
        } while (runLoopAgain);
        for (Schema schema : db.getAllSchemas()) {
            if (!schema.canDrop()) continue;
            db.removeDatabaseObject(this.session, schema);
        }
        ArrayList<SchemaObject> list = new ArrayList<SchemaObject>();
        for (SchemaObject obj : db.getAllSchemaObjects(3)) {
            if (((Sequence)obj).getBelongsToTable()) continue;
            list.add(obj);
        }
        list.addAll(db.getAllSchemaObjects(5));
        list.addAll(db.getAllSchemaObjects(4));
        list.addAll(db.getAllSchemaObjects(11));
        list.addAll(db.getAllSchemaObjects(9));
        for (SchemaObject obj : list) {
            if (obj.isHidden()) continue;
            db.removeSchemaObject(this.session, obj);
        }
        for (User user : db.getAllUsers()) {
            if (user == this.session.getUser()) continue;
            db.removeDatabaseObject(this.session, user);
        }
        for (Role role : db.getAllRoles()) {
            String string = role.getCreateSQL();
            if (string == null) continue;
            db.removeDatabaseObject(this.session, role);
        }
        ArrayList<DbObjectBase> arrayList = new ArrayList<DbObjectBase>();
        arrayList.addAll(db.getAllRights());
        arrayList.addAll(db.getAllAggregates());
        arrayList.addAll(db.getAllDomains());
        for (DbObject dbObject : arrayList) {
            String sql = dbObject.getCreateSQL();
            if (sql == null) continue;
            db.removeDatabaseObject(this.session, dbObject);
        }
    }

    public void setDropAllObjects(boolean b) {
        this.dropAllObjects = b;
    }

    public void setDeleteFiles(boolean b) {
        this.deleteFiles = b;
    }

    @Override
    public int getType() {
        return 38;
    }
}

