/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.command.dml;

import org.apache.ignite.internal.processors.query.h2.H2MemoryTracker;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.value.ValueRow;

public abstract class GroupByData {
    public H2MemoryTracker tracker;
    protected final Session ses;

    protected GroupByData(Session ses) {
        this.ses = ses;
        this.tracker = ses.memoryTracker() != null ? ses.memoryTracker().createChildTracker() : null;
    }

    protected void initTracker() {
        if (this.tracker == null) {
            this.tracker = this.ses.memoryTracker() != null ? this.ses.memoryTracker().createChildTracker() : null;
        }
    }

    public abstract Object[] nextSource(ValueRow var1, int var2);

    public abstract void updateCurrent(Object[] var1);

    public abstract long size();

    public abstract boolean next();

    public abstract ValueRow groupKey();

    public abstract Object[] groupByExprData();

    public abstract void done(int var1);

    public abstract void reset();

    public abstract void remove();

    public abstract void onRowProcessed();

    protected void onGroupChanged(ValueRow groupKey, Object[] old, Object[] row) {
        long size;
        this.initTracker();
        if (this.tracker == null) {
            return;
        }
        assert (old != null || row != null);
        if (row != null && old != null) {
            size = (row.length - old.length) * 24;
        } else if (old == null) {
            size = groupKey != null ? (long)groupKey.getMemory() : 0L;
            size += (long)(24 + row.length * 24);
        } else {
            size = groupKey != null ? (long)(-groupKey.getMemory()) : 0L;
            size -= (long)(24 + old.length * 24);
        }
        if (size > 0L) {
            this.tracker.reserve(size);
        } else if (size < 0L) {
            this.tracker.release(-size);
        }
    }
}

