/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.command.dml;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.gridgain.internal.h2.command.dml.GroupByData;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.value.ValueRow;

public class GroupedGroupByData
extends GroupByData {
    private final int[] grpIdx;
    private TreeMap<ValueRow, Object[]> grpByData;
    private ValueRow lastGrpKey;
    private Iterator<Map.Entry<ValueRow, Object[]>> cursor;
    private Map.Entry<ValueRow, Object[]> curEntry;

    public GroupedGroupByData(Session ses, int[] grpIdx) {
        super(ses);
        this.grpIdx = grpIdx;
        this.grpByData = new TreeMap(ses.getDatabase().getCompareMode());
    }

    @Override
    public Object[] nextSource(ValueRow grpKey, int width) {
        this.lastGrpKey = grpKey;
        Object[] values = this.grpByData.get(grpKey);
        if (values == null) {
            values = new Object[width];
            this.grpByData.put(grpKey, values);
            this.onGroupChanged(grpKey, null, values);
        }
        return values;
    }

    @Override
    public long size() {
        return this.grpByData.size();
    }

    @Override
    public boolean next() {
        assert (this.cursor != null);
        boolean hasNext = this.cursor.hasNext();
        this.curEntry = hasNext ? this.cursor.next() : null;
        return hasNext;
    }

    @Override
    public ValueRow groupKey() {
        assert (this.curEntry != null);
        return this.curEntry.getKey();
    }

    @Override
    public Object[] groupByExprData() {
        assert (this.curEntry != null);
        return this.curEntry.getValue();
    }

    @Override
    public void reset() {
        this.grpByData = new TreeMap(this.ses.getDatabase().getCompareMode());
        this.lastGrpKey = null;
        this.cursor = null;
        this.curEntry = null;
    }

    @Override
    public void remove() {
        assert (this.cursor != null);
        this.cursor.remove();
        this.onGroupChanged(this.curEntry.getKey(), this.curEntry.getValue(), null);
    }

    @Override
    public void onRowProcessed() {
    }

    @Override
    public void updateCurrent(Object[] grpByExprData) {
        Object[] old = this.grpByData.put(this.lastGrpKey, grpByExprData);
        this.onGroupChanged(this.lastGrpKey, old, grpByExprData);
    }

    @Override
    public void done(int width) {
        if (this.grpIdx == null && this.grpByData.isEmpty()) {
            this.grpByData.put(ValueRow.getEmpty(), new Object[width]);
        }
        this.cursor = this.grpByData.entrySet().iterator();
    }
}

