/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.command.dml;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.gridgain.internal.h2.command.Prepared;
import org.gridgain.internal.h2.command.dml.SelectOrderBy;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.Mode;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Alias;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.ExpressionColumn;
import org.gridgain.internal.h2.expression.ExpressionVisitor;
import org.gridgain.internal.h2.expression.Parameter;
import org.gridgain.internal.h2.expression.ValueExpression;
import org.gridgain.internal.h2.expression.function.FunctionCall;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.ResultInterface;
import org.gridgain.internal.h2.result.ResultTarget;
import org.gridgain.internal.h2.result.SortOrder;
import org.gridgain.internal.h2.table.ColumnResolver;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.util.Utils;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueInt;
import org.gridgain.internal.h2.value.ValueNull;

public abstract class Query
extends Prepared {
    ArrayList<Expression> expressions;
    Expression[] expressionArray;
    ArrayList<SelectOrderBy> orderList;
    SortOrder sort;
    Expression limitExpr;
    boolean fetchPercent;
    boolean withTies;
    Expression offsetExpr;
    Expression sampleSizeExpr;
    boolean distinct;
    boolean randomAccessResult;
    private boolean noCache;
    private int lastLimit;
    private long lastEvaluated;
    private ResultInterface lastResult;
    private Value[] lastParameters;
    private boolean cacheableChecked;
    private boolean neverLazy;

    Query(Session session) {
        super(session);
    }

    public void setNeverLazy(boolean b) {
        this.neverLazy = b;
    }

    public boolean isNeverLazy() {
        return this.neverLazy;
    }

    public abstract boolean isUnion();

    public abstract void prepareJoinBatch();

    protected abstract ResultInterface queryWithoutCache(int var1, ResultTarget var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultInterface queryWithoutCacheLazyCheck(int limit, ResultTarget target) {
        boolean disableLazy;
        boolean bl = disableLazy = this.neverLazy && this.session.isLazyQueryExecution();
        if (disableLazy) {
            this.session.setLazyQueryExecution(false);
        }
        try {
            ResultInterface resultInterface = this.queryWithoutCache(limit, target);
            return resultInterface;
        }
        finally {
            if (disableLazy) {
                this.session.setLazyQueryExecution(true);
            }
        }
    }

    public abstract void init();

    public ArrayList<Expression> getExpressions() {
        return this.expressions;
    }

    public abstract double getCost();

    public int getCostAsExpression() {
        return (int)Math.min(1000000.0, 10.0 + 10.0 * this.getCost());
    }

    public abstract HashSet<Table> getTables();

    public void setOrder(ArrayList<SelectOrderBy> order) {
        this.orderList = order;
    }

    public boolean hasOrder() {
        return this.orderList != null || this.sort != null;
    }

    public abstract void setForUpdate(boolean var1);

    public abstract int getColumnCount();

    public abstract void mapColumns(ColumnResolver var1, int var2);

    public abstract void setEvaluatable(TableFilter var1, boolean var2);

    public abstract void addGlobalCondition(Parameter var1, int var2, int var3);

    public abstract boolean allowGlobalConditions();

    public abstract boolean isEverything(ExpressionVisitor var1);

    public abstract void updateAggregate(Session var1, int var2);

    public abstract void fireBeforeSelectTriggers();

    public void setDistinct() {
        this.distinct = true;
    }

    public abstract void setDistinctIfPossible();

    public boolean isStandardDistinct() {
        return this.distinct;
    }

    public boolean isAnyDistinct() {
        return this.distinct;
    }

    public boolean isRandomAccessResult() {
        return this.randomAccessResult;
    }

    public void setRandomAccessResult(boolean b) {
        this.randomAccessResult = b;
    }

    @Override
    public boolean isQuery() {
        return true;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    public void disableCache() {
        this.noCache = true;
    }

    private boolean sameResultAsLast(Session s, Value[] params, Value[] lastParams, long lastEval) {
        if (!this.cacheableChecked) {
            long max = this.getMaxDataModificationId();
            boolean bl = this.noCache = max == Long.MAX_VALUE;
            if (!this.isEverything(ExpressionVisitor.DETERMINISTIC_VISITOR) || !this.isEverything(ExpressionVisitor.INDEPENDENT_VISITOR)) {
                this.noCache = true;
            }
            this.cacheableChecked = true;
        }
        if (this.noCache) {
            return false;
        }
        Database db = s.getDatabase();
        for (int i = 0; i < params.length; ++i) {
            Value a = lastParams[i];
            Value b = params[i];
            if (a.getValueType() == b.getValueType() && db.areEqual(a, b)) continue;
            return false;
        }
        return this.getMaxDataModificationId() <= lastEval;
    }

    private Value[] getParameterValues() {
        ArrayList<Parameter> list = this.getParameters();
        if (list == null) {
            return new Value[0];
        }
        int size = list.size();
        Value[] params = new Value[size];
        for (int i = 0; i < size; ++i) {
            Value v;
            params[i] = v = list.get(i).getParamValue();
        }
        return params;
    }

    @Override
    public final ResultInterface query(int maxrows) {
        return this.query(maxrows, null);
    }

    public final ResultInterface query(int limit, ResultTarget target) {
        ResultInterface r;
        ResultInterface lastResult0;
        if (this.isUnion()) {
            return this.queryWithoutCacheLazyCheck(limit, target);
        }
        this.fireBeforeSelectTriggers();
        if (this.ignoreCaching()) {
            return this.queryWithoutCacheLazyCheck(limit, target);
        }
        Value[] params = this.getParameterValues();
        long now = this.session.getDatabase().getModificationDataId();
        if (this.isEverything(ExpressionVisitor.DETERMINISTIC_VISITOR) && this.lastResult != null && !this.lastResult.isClosed() && limit == this.lastLimit && this.sameResultAsLast(this.session, params, this.lastParameters, this.lastEvaluated) && (lastResult0 = this.lastResult.createShallowCopy(this.session)) != null) {
            lastResult0.reset();
            return lastResult0;
        }
        this.lastParameters = params;
        this.closeLastResult();
        this.lastResult = r = this.queryWithoutCacheLazyCheck(limit, target);
        this.lastEvaluated = now;
        this.lastLimit = limit;
        return r;
    }

    public boolean ignoreCaching() {
        return this.noCache || !this.session.getDatabase().getOptimizeReuseResults() || this.session.isLazyQueryExecution() && !this.neverLazy;
    }

    public ResultInterface getLastResult() {
        return this.lastResult;
    }

    public void closeLastResult() {
        if (this.lastResult != null) {
            this.lastResult.close();
        }
    }

    static void initOrder(Session session, ArrayList<Expression> expressions, ArrayList<String> expressionSQL, List<SelectOrderBy> orderList, int visible, boolean mustBeInResult, ArrayList<TableFilter> filters) {
        for (SelectOrderBy o : orderList) {
            Expression e = o.expression;
            if (e == null) continue;
            int idx = Query.initExpression(session, expressions, expressionSQL, e, visible, mustBeInResult, filters);
            o.columnIndexExpr = ValueExpression.get(ValueInt.get(idx + 1));
            o.expression = expressions.get(idx).getNonAliasExpression();
        }
    }

    static int initExpression(Session session, ArrayList<Expression> expressions, ArrayList<String> expressionSQL, Expression e, int visible, boolean mustBeInResult, ArrayList<TableFilter> filters) {
        Database db = session.getDatabase();
        if (e instanceof ExpressionColumn) {
            ExpressionColumn exprCol = (ExpressionColumn)e;
            String tableAlias = exprCol.getOriginalTableAliasName();
            String col = exprCol.getOriginalColumnName();
            for (int j = 0; j < visible; ++j) {
                Expression ec = expressions.get(j);
                if (ec instanceof ExpressionColumn) {
                    ExpressionColumn c = (ExpressionColumn)ec;
                    if (!db.equalsIdentifiers(col, c.getColumnName())) continue;
                    if (tableAlias == null) {
                        return j;
                    }
                    String ca = c.getOriginalTableAliasName();
                    if (ca != null) {
                        if (!db.equalsIdentifiers(ca, tableAlias)) continue;
                        return j;
                    }
                    if (filters == null) continue;
                    for (TableFilter f : filters) {
                        if (!db.equalsIdentifiers(f.getTableAlias(), tableAlias)) continue;
                        return j;
                    }
                    continue;
                }
                if (!(ec instanceof Alias)) continue;
                if (tableAlias == null && db.equalsIdentifiers(col, ec.getAlias())) {
                    return j;
                }
                Expression ec2 = ec.getNonAliasExpression();
                if (!(ec2 instanceof ExpressionColumn)) continue;
                ExpressionColumn c2 = (ExpressionColumn)ec2;
                String ta = exprCol.getSQL(true);
                String tb = c2.getSQL(true);
                String s2 = c2.getColumnName();
                if (!db.equalsIdentifiers(col, s2) || !db.equalsIdentifiers(ta, tb)) continue;
                return j;
            }
        } else if (expressionSQL != null) {
            String s = e.getSQL(true);
            int size = expressionSQL.size();
            for (int j = 0; j < size; ++j) {
                if (!db.equalsIdentifiers(expressionSQL.get(j), s)) continue;
                return j;
            }
        }
        if (expressionSQL == null || mustBeInResult && session.getDatabase().getMode().getEnum() != Mode.ModeEnum.MySQL && !Query.checkOrderOther(session, e, expressionSQL)) {
            throw DbException.get(90068, e.getSQL(false));
        }
        int idx = expressions.size();
        expressions.add(e);
        expressionSQL.add(e.getSQL(true));
        return idx;
    }

    private static boolean checkOrderOther(Session session, Expression expr, ArrayList<String> expressionSQL) {
        if (expr.isConstant()) {
            return true;
        }
        String exprSQL = expr.getSQL(true);
        for (String sql : expressionSQL) {
            if (!session.getDatabase().equalsIdentifiers(exprSQL, sql)) continue;
            return true;
        }
        int count = expr.getSubexpressionCount();
        if (expr instanceof FunctionCall ? !((FunctionCall)((Object)expr)).isDeterministic() : count <= 0) {
            return false;
        }
        for (int i = 0; i < count; ++i) {
            if (Query.checkOrderOther(session, expr.getSubexpression(i), expressionSQL)) continue;
            return false;
        }
        return true;
    }

    public SortOrder prepareOrder(ArrayList<SelectOrderBy> orderList, int expressionCount) {
        int size = orderList.size();
        int[] index = new int[size];
        int[] sortType = new int[size];
        for (int i = 0; i < size; ++i) {
            int idx;
            SelectOrderBy o = orderList.get(i);
            boolean reverse = false;
            Value v = o.columnIndexExpr.getValue(null);
            if (v == ValueNull.INSTANCE) {
                idx = 0;
            } else {
                idx = v.getInt();
                if (idx < 0) {
                    reverse = true;
                    idx = -idx;
                }
                if (--idx < 0 || idx >= expressionCount) {
                    throw DbException.get(90068, Integer.toString(idx + 1));
                }
            }
            index[i] = idx;
            int type = o.sortType;
            if (reverse) {
                type ^= 1;
            }
            sortType[i] = type;
        }
        return new SortOrder(this.session.getDatabase(), index, sortType, orderList, this);
    }

    @Override
    public int getType() {
        return 66;
    }

    public void setOffset(Expression offset) {
        this.offsetExpr = offset;
    }

    public Expression getOffset() {
        return this.offsetExpr;
    }

    public void setLimit(Expression limit) {
        this.limitExpr = limit;
    }

    public Expression getLimit() {
        return this.limitExpr;
    }

    public void setFetchPercent(boolean fetchPercent) {
        this.fetchPercent = fetchPercent;
    }

    public boolean isFetchPercent() {
        return this.fetchPercent;
    }

    public void setWithTies(boolean withTies) {
        this.withTies = withTies;
    }

    public boolean isWithTies() {
        return this.withTies;
    }

    void addParameter(Parameter param) {
        if (this.parameters == null) {
            this.parameters = Utils.newSmallArrayList();
        }
        this.parameters.add(param);
    }

    public void setSampleSize(Expression sampleSize) {
        this.sampleSizeExpr = sampleSize;
    }

    int getSampleSizeValue(Session session) {
        if (this.sampleSizeExpr == null) {
            return 0;
        }
        Value v = this.sampleSizeExpr.optimize(session).getValue(session);
        if (v == ValueNull.INSTANCE) {
            return 0;
        }
        return v.getInt();
    }

    public final long getMaxDataModificationId() {
        ExpressionVisitor visitor = ExpressionVisitor.getMaxModificationIdVisitor();
        this.isEverything(visitor);
        return visitor.getMaxDataModificationId();
    }

    void appendLimitToSQL(StringBuilder builder, boolean alwaysQuote) {
        String count;
        if (this.offsetExpr != null) {
            count = StringUtils.unEnclose(this.offsetExpr.getSQL(alwaysQuote));
            builder.append("\nOFFSET ").append(count).append("1".equals(count) ? " ROW" : " ROWS");
        }
        if (this.limitExpr != null) {
            boolean withCount;
            builder.append("\nFETCH ").append(this.offsetExpr != null ? "NEXT" : "FIRST");
            count = StringUtils.unEnclose(this.limitExpr.getSQL(alwaysQuote));
            boolean bl = withCount = this.fetchPercent || !"1".equals(count);
            if (withCount) {
                builder.append(' ').append(count);
                if (this.fetchPercent) {
                    builder.append(" PERCENT");
                }
            }
            builder.append(!withCount ? " ROW" : " ROWS").append(this.withTies ? " WITH TIES" : " ONLY");
        }
    }
}

