/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.command.dml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import org.gridgain.internal.h2.command.Parser;
import org.gridgain.internal.h2.command.dml.Optimizer;
import org.gridgain.internal.h2.command.dml.Query;
import org.gridgain.internal.h2.command.dml.SelectGroups;
import org.gridgain.internal.h2.command.dml.SelectListColumnResolver;
import org.gridgain.internal.h2.command.dml.SelectOrderBy;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Alias;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.ExpressionColumn;
import org.gridgain.internal.h2.expression.ExpressionVisitor;
import org.gridgain.internal.h2.expression.Parameter;
import org.gridgain.internal.h2.expression.ValueExpression;
import org.gridgain.internal.h2.expression.Wildcard;
import org.gridgain.internal.h2.expression.analysis.Window;
import org.gridgain.internal.h2.expression.condition.Comparison;
import org.gridgain.internal.h2.expression.condition.ConditionAndOr;
import org.gridgain.internal.h2.index.Cursor;
import org.gridgain.internal.h2.index.HashJoinIndex;
import org.gridgain.internal.h2.index.Index;
import org.gridgain.internal.h2.index.IndexType;
import org.gridgain.internal.h2.index.ViewIndex;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.LazyResult;
import org.gridgain.internal.h2.result.LocalResult;
import org.gridgain.internal.h2.result.ResultInterface;
import org.gridgain.internal.h2.result.ResultTarget;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.SearchRow;
import org.gridgain.internal.h2.result.SortOrder;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.ColumnResolver;
import org.gridgain.internal.h2.table.IndexColumn;
import org.gridgain.internal.h2.table.JoinBatch;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.table.TableType;
import org.gridgain.internal.h2.table.TableView;
import org.gridgain.internal.h2.util.ColumnNamer;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.util.Utils;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueBoolean;
import org.gridgain.internal.h2.value.ValueNull;
import org.gridgain.internal.h2.value.ValueRow;

public class Select
extends Query {
    TableFilter topTableFilter;
    private final ArrayList<TableFilter> filters = Utils.newSmallArrayList();
    private final ArrayList<TableFilter> topFilters = Utils.newSmallArrayList();
    private Select parentSelect;
    private Expression condition;
    private Expression having;
    private Expression qualify;
    int visibleColumnCount;
    private Expression[] distinctExpressions;
    private int[] distinctIndexes;
    private int distinctColumnCount;
    private ArrayList<Expression> group;
    int[] groupIndex;
    boolean[] groupByExpression;
    SelectGroups groupData;
    private int havingIndex;
    private int qualifyIndex;
    private int[] groupByCopies;
    boolean isGroupQuery;
    private boolean isGroupSortedQuery;
    private boolean isWindowQuery;
    private boolean isForUpdate;
    private boolean isForUpdateMvcc;
    private double cost;
    private boolean isQuickAggregateQuery;
    private boolean isDistinctQuery;
    private boolean isPrepared;
    private boolean checkInit;
    private boolean sortUsingIndex;
    private boolean isGroupWindowStage2;
    private HashMap<String, Window> windows;

    public Select(Session session, Select parentSelect) {
        super(session);
        this.parentSelect = parentSelect;
    }

    @Override
    public boolean isUnion() {
        return false;
    }

    public void addTableFilter(TableFilter filter, boolean isTop) {
        this.filters.add(filter);
        if (isTop) {
            this.topFilters.add(filter);
        }
    }

    public ArrayList<TableFilter> getTopFilters() {
        return this.topFilters;
    }

    public void setExpressions(ArrayList<Expression> expressions) {
        this.expressions = expressions;
    }

    public void setWildcard() {
        this.expressions = new ArrayList(1);
        this.expressions.add(new Wildcard(null, null));
    }

    public void setGroupQuery() {
        this.isGroupQuery = true;
    }

    public void setWindowQuery() {
        this.isWindowQuery = true;
    }

    public void setGroupBy(ArrayList<Expression> group) {
        this.group = group;
    }

    public ArrayList<Expression> getGroupBy() {
        return this.group;
    }

    public SelectGroups getGroupDataIfCurrent(boolean window) {
        return this.groupData != null && (window || this.groupData.isCurrentGroup()) ? this.groupData : null;
    }

    @Override
    public void setDistinct() {
        if (this.distinctExpressions != null) {
            throw DbException.getUnsupportedException("DISTINCT ON together with DISTINCT");
        }
        this.distinct = true;
    }

    public void setDistinct(Expression[] distinctExpressions) {
        if (this.distinct) {
            throw DbException.getUnsupportedException("DISTINCT ON together with DISTINCT");
        }
        this.distinctExpressions = distinctExpressions;
    }

    @Override
    public void setDistinctIfPossible() {
        if (!this.isAnyDistinct() && this.offsetExpr == null && this.limitExpr == null) {
            this.distinct = true;
        }
    }

    @Override
    public boolean isAnyDistinct() {
        return this.distinct || this.distinctExpressions != null;
    }

    public boolean addWindow(String name, Window window) {
        if (this.windows == null) {
            this.windows = new HashMap();
        }
        return this.windows.put(name, window) == null;
    }

    public Window getWindow(String name) {
        return this.windows != null ? this.windows.get(name) : null;
    }

    public void addCondition(Expression cond) {
        this.condition = this.condition == null ? cond : new ConditionAndOr(0, cond, this.condition);
    }

    public Expression getCondition() {
        return this.condition;
    }

    private LazyResult queryGroupSorted(int columnCount, ResultTarget result, long offset, boolean quickOffset) {
        LazyResultGroupSorted lazyResult = new LazyResultGroupSorted(this.expressionArray, columnCount);
        Select.skipOffset(lazyResult, offset, quickOffset);
        if (result == null) {
            return lazyResult;
        }
        while (lazyResult.next()) {
            result.addRow(lazyResult.currentRow());
        }
        lazyResult.close();
        return null;
    }

    Value[] createGroupSortedRow(Value[] keyValues, int columnCount) {
        int j;
        Value[] row = new Value[columnCount];
        for (j = 0; this.groupIndex != null && j < this.groupIndex.length; ++j) {
            row[this.groupIndex[j]] = keyValues[j];
        }
        for (j = 0; j < columnCount; ++j) {
            if (this.groupByExpression != null && this.groupByExpression[j]) continue;
            Expression expr = (Expression)this.expressions.get(j);
            row[j] = expr.getValue(this.session);
        }
        if (this.isHavingNullOrFalse(row)) {
            return null;
        }
        row = this.keepOnlyDistinct(row, columnCount);
        return row;
    }

    private Value[] keepOnlyDistinct(Value[] row, int columnCount) {
        if (columnCount == this.distinctColumnCount) {
            return row;
        }
        return Arrays.copyOf(row, this.distinctColumnCount);
    }

    private boolean isHavingNullOrFalse(Value[] row) {
        return this.havingIndex >= 0 && !row[this.havingIndex].getBoolean();
    }

    private Index getGroupSortedIndex() {
        if (this.groupIndex == null || this.groupByExpression == null) {
            return null;
        }
        ArrayList<Index> indexes = this.topTableFilter.getTable().getIndexes();
        if (indexes != null) {
            for (Index index : indexes) {
                if (index.getIndexType().isScan() || index.getIndexType().isHash() || !this.isGroupSortedIndex(this.topTableFilter, index)) continue;
                return index;
            }
        }
        return null;
    }

    private boolean isGroupSortedIndex(TableFilter tableFilter, Index index) {
        int i;
        Column[] indexColumns = index.getColumns();
        boolean[] grouped = new boolean[indexColumns.length];
        int size = this.expressions.size();
        block0: for (i = 0; i < size; ++i) {
            if (!this.groupByExpression[i]) continue;
            Expression expr = ((Expression)this.expressions.get(i)).getNonAliasExpression();
            if (!(expr instanceof ExpressionColumn)) {
                return false;
            }
            ExpressionColumn exprCol = (ExpressionColumn)expr;
            for (int j = 0; j < indexColumns.length; ++j) {
                if (tableFilter != exprCol.getTableFilter() || !indexColumns[j].equals(exprCol.getColumn())) continue;
                grouped[j] = true;
                continue block0;
            }
            return false;
        }
        for (i = 1; i < grouped.length; ++i) {
            if (grouped[i - 1] || !grouped[i]) continue;
            return false;
        }
        return true;
    }

    private int getGroupByExpressionCount() {
        if (this.groupByExpression == null) {
            return 0;
        }
        int count = 0;
        for (boolean b : this.groupByExpression) {
            if (!b) continue;
            ++count;
        }
        return count;
    }

    boolean isConditionMetForUpdate() {
        if (this.isConditionMet()) {
            int count = this.filters.size();
            boolean notChanged = true;
            for (int i = 0; i < count; ++i) {
                TableFilter tableFilter = this.filters.get(i);
                if (tableFilter.isJoinOuter() || tableFilter.isJoinOuterIndirect()) continue;
                Row row = tableFilter.get();
                Table table = tableFilter.getTable();
                if (!table.isMVStore()) continue;
                Row lockedRow = table.lockRow(this.session, row);
                if (lockedRow == null) {
                    return false;
                }
                if (row.hasSharedData(lockedRow)) continue;
                tableFilter.set(lockedRow);
                notChanged = false;
            }
            return notChanged || this.isConditionMet();
        }
        return false;
    }

    boolean isConditionMet() {
        return this.condition == null || this.condition.getBooleanValue(this.session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryWindow(int columnCount, LocalResult result, long offset, boolean quickOffset) {
        this.initGroupData(columnCount);
        try {
            this.gatherGroup(columnCount, 2);
            this.processGroupResult(columnCount, result, offset, quickOffset, false);
        }
        finally {
            this.groupData.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryGroupWindow(int columnCount, LocalResult result, long offset, boolean quickOffset) {
        this.initGroupData(columnCount);
        try {
            this.gatherGroup(columnCount, 1);
            try {
                this.isGroupWindowStage2 = true;
                while (this.groupData.next() != null) {
                    if (this.havingIndex < 0 || ((Expression)this.expressions.get(this.havingIndex)).getBooleanValue(this.session)) {
                        this.updateAgg(columnCount, 2);
                        continue;
                    }
                    this.groupData.remove();
                }
                this.groupData.done();
                this.processGroupResult(columnCount, result, offset, quickOffset, false);
            }
            finally {
                this.isGroupWindowStage2 = false;
            }
        }
        finally {
            this.groupData.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryGroup(int columnCount, LocalResult result, long offset, boolean quickOffset) {
        this.initGroupData(columnCount);
        try {
            this.gatherGroup(columnCount, 1);
            this.processGroupResult(columnCount, result, offset, quickOffset, true);
        }
        finally {
            this.groupData.reset();
        }
    }

    private void initGroupData(int columnCount) {
        if (this.groupData == null) {
            this.setGroupData(SelectGroups.getInstance(this.session, this.expressions, this.isGroupQuery, this.groupIndex));
        } else {
            this.updateAgg(columnCount, 0);
        }
        this.groupData.reset();
    }

    void setGroupData(final SelectGroups groupData) {
        this.groupData = groupData;
        this.topTableFilter.visit(new TableFilter.TableFilterVisitor(){

            @Override
            public void accept(TableFilter f) {
                Select s = f.getSelect();
                if (s != null) {
                    s.groupData = groupData;
                }
            }
        });
    }

    private void gatherGroup(int columnCount, int stage) {
        long rowNumber = 0L;
        this.setCurrentRowNumber(0L);
        int sampleSize = this.getSampleSizeValue(this.session);
        while (this.topTableFilter.next()) {
            this.setCurrentRowNumber(rowNumber + 1L);
            if (!(this.isForUpdateMvcc ? this.isConditionMetForUpdate() : this.isConditionMet())) continue;
            this.groupData.nextSource();
            this.updateAgg(columnCount, stage);
            this.groupData.onRowProcessed();
            if (sampleSize <= 0 || ++rowNumber < (long)sampleSize) continue;
        }
        this.groupData.done();
    }

    void updateAgg(int columnCount, int stage) {
        for (int i = 0; i < columnCount; ++i) {
            if (this.groupByExpression != null && this.groupByExpression[i] || this.groupByCopies != null && this.groupByCopies[i] >= 0) continue;
            Expression expr = (Expression)this.expressions.get(i);
            expr.updateAggregate(this.session, stage);
        }
    }

    private void processGroupResult(int columnCount, LocalResult result, long offset, boolean quickOffset, boolean withHaving) {
        ValueRow currentGroupsKey;
        while ((currentGroupsKey = this.groupData.next()) != null) {
            int j;
            Value[] keyValues = currentGroupsKey.getList();
            Value[] row = new Value[columnCount];
            for (j = 0; this.groupIndex != null && j < this.groupIndex.length; ++j) {
                row[this.groupIndex[j]] = keyValues[j];
            }
            for (j = 0; j < columnCount; ++j) {
                int original;
                if (this.groupByExpression != null && this.groupByExpression[j]) continue;
                if (this.groupByCopies != null && (original = this.groupByCopies[j]) >= 0) {
                    row[j] = row[original];
                    continue;
                }
                Expression expr = (Expression)this.expressions.get(j);
                row[j] = expr.getValue(this.session);
            }
            if (withHaving && this.isHavingNullOrFalse(row) || this.qualifyIndex >= 0 && !row[this.qualifyIndex].getBoolean()) continue;
            if (quickOffset && offset > 0L) {
                --offset;
                continue;
            }
            row = this.keepOnlyDistinct(row, columnCount);
            result.addRow(row);
        }
    }

    private Index getSortIndex() {
        Index index;
        if (this.sort == null) {
            return null;
        }
        ArrayList<Column> sortColumns = Utils.newSmallArrayList();
        for (int idx : this.sort.getQueryColumnIndexes()) {
            if (idx < 0 || idx >= this.expressions.size()) {
                throw DbException.getInvalidValueException("ORDER BY", idx + 1);
            }
            Expression expr = (Expression)this.expressions.get(idx);
            if ((expr = expr.getNonAliasExpression()).isConstant()) continue;
            if (!(expr instanceof ExpressionColumn)) {
                return null;
            }
            ExpressionColumn exprCol = (ExpressionColumn)expr;
            if (exprCol.getTableFilter() != this.topTableFilter) {
                return null;
            }
            sortColumns.add(exprCol.getColumn());
        }
        Column[] sortCols = sortColumns.toArray(new Column[0]);
        if (sortCols.length == 0) {
            return this.topTableFilter.getTable().getScanIndex(this.session);
        }
        ArrayList<Index> list = this.topTableFilter.getTable().getIndexes();
        if (list != null) {
            int[] sortTypes = this.sort.getSortTypesWithNullPosition();
            for (Index index2 : list) {
                IndexColumn[] indexCols;
                if (index2.getCreateSQL() == null || index2.getIndexType().isHash() || (indexCols = index2.getIndexColumns()).length < sortCols.length) continue;
                boolean ok = true;
                for (int j = 0; j < sortCols.length; ++j) {
                    IndexColumn idxCol = indexCols[j];
                    Column sortCol = sortCols[j];
                    if (idxCol.column != sortCol) {
                        ok = false;
                        break;
                    }
                    if (SortOrder.addExplicitNullPosition(idxCol.sortType) == sortTypes[j]) continue;
                    ok = false;
                    break;
                }
                if (!ok) continue;
                return index2;
            }
        }
        if (sortCols.length == 1 && sortCols[0].getColumnId() == -1 && (index = this.topTableFilter.getTable().getScanIndex(this.session)).isRowIdIndex()) {
            return index;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void queryDistinct(ResultTarget result, long offset, long limitRows, boolean withTies, boolean quickOffset) {
        if (limitRows > 0L && offset > 0L && (limitRows += offset) < 0L) {
            limitRows = Long.MAX_VALUE;
        }
        long rowNumber = 0L;
        this.setCurrentRowNumber(0L);
        Index index = this.topTableFilter.getIndex();
        SearchRow first = null;
        int columnIndex = index.getColumns()[0].getColumnId();
        int sampleSize = this.getSampleSizeValue(this.session);
        if (!quickOffset) {
            offset = 0L;
        }
        while (true) {
            this.setCurrentRowNumber(++rowNumber);
            Cursor cursor = index.findNext(this.session, first, null);
            if (!cursor.next()) return;
            SearchRow found = cursor.getSearchRow();
            Value value = found.getValue(columnIndex);
            if (first == null) {
                first = this.topTableFilter.getTable().getTemplateSimpleRow(true);
            }
            first.setValue(columnIndex, value);
            if (offset > 0L) {
                --offset;
                continue;
            }
            Value[] row = new Value[]{value};
            result.addRow(row);
            if ((this.sort == null || this.sortUsingIndex) && limitRows > 0L && rowNumber >= limitRows && !withTies || sampleSize > 0 && rowNumber >= (long)sampleSize) return;
        }
    }

    private LazyResult queryFlat(int columnCount, ResultTarget result, long offset, long limitRows, boolean withTies, boolean quickOffset) {
        if (limitRows > 0L && offset > 0L && !quickOffset && (limitRows += offset) < 0L) {
            limitRows = Long.MAX_VALUE;
        }
        int sampleSize = this.getSampleSizeValue(this.session);
        LazyResultQueryFlat lazyResult = new LazyResultQueryFlat(this.expressionArray, columnCount, sampleSize, this.isForUpdateMvcc);
        Select.skipOffset(lazyResult, offset, quickOffset);
        if (result == null) {
            return lazyResult;
        }
        if (limitRows < 0L || this.sort != null && !this.sortUsingIndex || withTies && !quickOffset) {
            limitRows = Long.MAX_VALUE;
        }
        Value[] row = null;
        while ((long)result.getRowCount() < limitRows && lazyResult.next()) {
            row = lazyResult.currentRow();
            result.addRow(row);
        }
        if (limitRows != Long.MAX_VALUE && withTies && this.sort != null && row != null) {
            Value[] expected = row;
            while (lazyResult.next() && this.sort.compare(expected, row = lazyResult.currentRow()) == 0) {
                result.addRow(row);
            }
            result.limitsWereApplied();
        }
        lazyResult.close();
        return null;
    }

    private static void skipOffset(LazyResultSelect lazyResult, long offset, boolean quickOffset) {
        if (quickOffset) {
            while (offset > 0L && lazyResult.skip()) {
                --offset;
            }
        }
    }

    private void queryQuick(int columnCount, ResultTarget result, boolean skipResult) {
        Value[] row = new Value[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            Expression expr = (Expression)this.expressions.get(i);
            row[i] = expr.getValue(this.session);
        }
        if (!skipResult) {
            result.addRow(row);
        }
    }

    @Override
    public ResultInterface queryMeta() {
        LocalResult result = this.session.getDatabase().getResultFactory().create(this.session, this.expressionArray, this.visibleColumnCount, true);
        result.done();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ResultInterface queryWithoutCache(int maxRows, ResultTarget target) {
        long offset;
        boolean fetchPercent;
        int limitRows;
        this.disableLazyForJoinSubqueries(this.topTableFilter);
        int n = limitRows = maxRows == 0 ? -1 : maxRows;
        if (this.limitExpr != null) {
            int l;
            Value v = this.limitExpr.getValue(this.session);
            int n2 = l = v == ValueNull.INSTANCE ? -1 : v.getInt();
            if (limitRows < 0) {
                limitRows = l;
            } else if (l >= 0) {
                limitRows = Math.min(l, limitRows);
            }
        }
        if (fetchPercent = this.fetchPercent) {
            if (limitRows < 0 || limitRows > 100) {
                throw DbException.getInvalidValueException("FETCH PERCENT", limitRows);
            }
            if (limitRows == 0) {
                fetchPercent = false;
            }
        }
        if (this.offsetExpr != null) {
            offset = this.offsetExpr.getValue(this.session).getLong();
            if (offset < 0L) {
                offset = 0L;
            }
        } else {
            offset = 0L;
        }
        boolean lazy = this.session.isLazyQueryExecution() && target == null && !this.isForUpdate && !this.isQuickAggregateQuery && limitRows != 0 && !fetchPercent && !this.withTies && offset == 0L && this.isReadOnly();
        int columnCount = this.expressions.size();
        ResultInterface result = null;
        try {
            boolean quickOffset;
            if (!(lazy || target != null && this.session.getDatabase().getSettings().optimizeInsertFromSelect)) {
                result = this.createLocalResult((LocalResult)result);
            }
            boolean bl = quickOffset = !fetchPercent;
            if (this.sort != null && (!this.sortUsingIndex || this.isAnyDistinct())) {
                result = this.createLocalResult((LocalResult)result);
                result.setSortOrder(this.sort);
                if (!this.sortUsingIndex) {
                    quickOffset = false;
                }
            }
            if (this.distinct) {
                if (!this.isDistinctQuery) {
                    quickOffset = false;
                    result = this.createLocalResult((LocalResult)result);
                    result.setDistinct();
                }
            } else if (this.distinctExpressions != null) {
                quickOffset = false;
                result = this.createLocalResult((LocalResult)result);
                result.setDistinct(this.distinctIndexes);
            }
            if (this.isWindowQuery || this.isGroupQuery && !this.isGroupSortedQuery) {
                result = this.createLocalResult((LocalResult)result);
            }
            if (!(lazy || limitRows < 0 && offset <= 0L)) {
                result = this.createLocalResult((LocalResult)result);
            }
            this.topTableFilter.startQuery(this.session);
            this.topTableFilter.reset();
            boolean exclusive = this.isForUpdate && !this.isForUpdateMvcc;
            this.topTableFilter.lock(this.session, exclusive, exclusive);
            Object to = result != null ? result : target;
            lazy &= to == null;
            LazyResult lazyResult = null;
            if (limitRows != 0) {
                int limit = fetchPercent ? -1 : limitRows;
                try {
                    if (this.isQuickAggregateQuery) {
                        this.queryQuick(columnCount, (ResultTarget)to, quickOffset && offset > 0L);
                    } else if (this.isWindowQuery) {
                        if (this.isGroupQuery) {
                            this.queryGroupWindow(columnCount, (LocalResult)result, offset, quickOffset);
                        } else {
                            this.queryWindow(columnCount, (LocalResult)result, offset, quickOffset);
                        }
                    } else if (this.isGroupQuery) {
                        if (this.isGroupSortedQuery) {
                            lazyResult = this.queryGroupSorted(columnCount, (ResultTarget)to, offset, quickOffset);
                        } else {
                            this.queryGroup(columnCount, (LocalResult)result, offset, quickOffset);
                        }
                    } else if (this.isDistinctQuery) {
                        this.queryDistinct((ResultTarget)to, offset, limit, this.withTies, quickOffset);
                    } else {
                        lazyResult = this.queryFlat(columnCount, (ResultTarget)to, offset, limit, this.withTies, quickOffset);
                    }
                    if (quickOffset) {
                        offset = 0L;
                    }
                }
                finally {
                    if (!lazy) {
                        this.resetJoinBatchAfterQuery();
                    }
                }
            }
            assert (lazy == (lazyResult != null)) : lazy;
            if (lazyResult != null) {
                if (limitRows > 0) {
                    lazyResult.setLimit(limitRows);
                }
                if (this.randomAccessResult) {
                    return this.convertToDistinct(lazyResult);
                }
                return lazyResult;
            }
            if (offset != 0L) {
                if (offset > Integer.MAX_VALUE) {
                    throw DbException.getInvalidValueException("OFFSET", offset);
                }
                result.setOffset((int)offset);
            }
            if (limitRows >= 0) {
                result.setLimit(limitRows);
                result.setFetchPercent(fetchPercent);
                if (this.withTies) {
                    result.setWithTies(this.sort);
                }
            }
            if (result != null) {
                result.done();
                if (this.randomAccessResult && !this.distinct) {
                    result = this.convertToDistinct(result);
                }
                if (target != null) {
                    while (result.next()) {
                        target.addRow(result.currentRow());
                    }
                    result.close();
                    return null;
                }
                return result;
            }
            return null;
        }
        catch (Throwable e) {
            if (result != null) {
                try {
                    result.close();
                }
                catch (Throwable e0) {
                    e.addSuppressed(e0);
                }
            }
            throw e;
        }
    }

    private void disableLazyForJoinSubqueries(final TableFilter top) {
        if (this.session.isLazyQueryExecution()) {
            top.visit(new TableFilter.TableFilterVisitor(){

                @Override
                public void accept(TableFilter f) {
                    ViewIndex idx;
                    if (f != top && f.getTable().getTableType() == TableType.VIEW && f.getIndex() instanceof ViewIndex && (idx = (ViewIndex)f.getIndex()) != null && idx.getQuery() != null) {
                        idx.getQuery().setNeverLazy(true);
                    }
                }
            });
        }
    }

    void resetJoinBatchAfterQuery() {
        JoinBatch jb = this.getJoinBatch();
        if (jb != null) {
            jb.reset(false);
        }
    }

    private LocalResult createLocalResult(LocalResult old) {
        return old != null ? old : this.session.getDatabase().getResultFactory().create(this.session, this.expressionArray, this.visibleColumnCount, false);
    }

    private LocalResult convertToDistinct(ResultInterface result) {
        LocalResult distinctResult = this.session.getDatabase().getResultFactory().create(this.session, this.expressionArray, this.visibleColumnCount, false);
        distinctResult.setDistinct();
        result.reset();
        while (result.next()) {
            distinctResult.addRow(result.currentRow());
        }
        result.close();
        distinctResult.done();
        return distinctResult;
    }

    private void expandColumnList() {
        int i = 0;
        while (i < this.expressions.size()) {
            Expression expr = (Expression)this.expressions.get(i);
            if (!(expr instanceof Wildcard)) {
                ++i;
                continue;
            }
            this.expressions.remove(i);
            Wildcard w = (Wildcard)expr;
            String tableAlias = w.getTableAlias();
            boolean hasExceptColumns = w.getExceptColumns() != null;
            HashMap<Column, ExpressionColumn> exceptTableColumns = null;
            if (tableAlias == null) {
                if (hasExceptColumns) {
                    for (TableFilter filter : this.filters) {
                        w.mapColumns(filter, 1, 0);
                    }
                    exceptTableColumns = w.mapExceptColumns();
                }
                for (TableFilter filter : this.filters) {
                    i = this.expandColumnList(filter, i, exceptTableColumns);
                }
                continue;
            }
            Database db = this.session.getDatabase();
            String schemaName = w.getSchemaName();
            TableFilter filter = null;
            for (TableFilter f : this.filters) {
                if (!db.equalsIdentifiers(tableAlias, f.getTableAlias()) || schemaName != null && !db.equalsIdentifiers(schemaName, f.getSchemaName())) continue;
                if (hasExceptColumns) {
                    w.mapColumns(f, 1, 0);
                    exceptTableColumns = w.mapExceptColumns();
                }
                filter = f;
                break;
            }
            if (filter == null) {
                throw DbException.get(42102, tableAlias);
            }
            i = this.expandColumnList(filter, i, exceptTableColumns);
        }
    }

    private int expandColumnList(TableFilter filter, int index, HashMap<Column, ExpressionColumn> except) {
        String alias = filter.getTableAlias();
        for (Column c : filter.getTable().getColumns()) {
            if (except != null && except.remove(c) != null || !c.getVisible() || filter.isNaturalJoinColumn(c)) continue;
            String name = filter.getDerivedColumnName(c);
            ExpressionColumn ec = new ExpressionColumn(this.session.getDatabase(), null, alias, name != null ? name : c.getName(), false);
            this.expressions.add(index++, ec);
        }
        return index;
    }

    @Override
    public void init() {
        int i;
        ArrayList<String> expressionSQL;
        if (this.checkInit) {
            DbException.throwInternalError();
        }
        this.expandColumnList();
        this.visibleColumnCount = this.expressions.size();
        if (this.distinctExpressions != null || this.orderList != null || this.group != null) {
            expressionSQL = new ArrayList<String>(this.visibleColumnCount);
            for (int i2 = 0; i2 < this.visibleColumnCount; ++i2) {
                Object expr = (Expression)this.expressions.get(i2);
                expr = ((Expression)expr).getNonAliasExpression();
                String sql = ((Expression)expr).getSQL(true);
                expressionSQL.add(sql);
            }
        } else {
            expressionSQL = null;
        }
        if (this.distinctExpressions != null) {
            BitSet set = new BitSet();
            for (Expression e : this.distinctExpressions) {
                set.set(Select.initExpression(this.session, this.expressions, expressionSQL, e, this.visibleColumnCount, false, this.filters));
            }
            int idx = 0;
            int cnt = set.cardinality();
            this.distinctIndexes = new int[cnt];
            for (i = 0; i < cnt; ++i) {
                idx = set.nextSetBit(idx);
                this.distinctIndexes[i] = idx++;
            }
        }
        if (this.orderList != null) {
            Select.initOrder(this.session, this.expressions, expressionSQL, this.orderList, this.visibleColumnCount, this.isAnyDistinct(), this.filters);
        }
        this.distinctColumnCount = this.expressions.size();
        if (this.having != null) {
            this.expressions.add(this.having);
            this.havingIndex = this.expressions.size() - 1;
            this.having = null;
        } else {
            this.havingIndex = -1;
        }
        if (this.qualify != null) {
            this.expressions.add(this.qualify);
            this.qualifyIndex = this.expressions.size() - 1;
            this.qualify = null;
        } else {
            this.qualifyIndex = -1;
        }
        if (this.withTies && !this.hasOrder()) {
            throw DbException.get(90122);
        }
        Database db = this.session.getDatabase();
        if (this.group != null) {
            block25: {
                int size = this.group.size();
                int expSize = expressionSQL.size();
                this.groupIndex = new int[size];
                for (i = 0; i < size; ++i) {
                    int j;
                    Expression expr = this.group.get(i);
                    String sql = expr.getSQL(true);
                    int found = -1;
                    for (j = 0; j < expSize; ++j) {
                        String s2 = expressionSQL.get(j);
                        if (!db.equalsIdentifiers(s2, sql)) continue;
                        found = this.mergeGroupByExpressions(db, j, expressionSQL, false);
                        break;
                    }
                    if (found < 0) {
                        for (j = 0; j < expSize; ++j) {
                            Expression e = (Expression)this.expressions.get(j);
                            if (db.equalsIdentifiers(sql, e.getAlias())) {
                                found = this.mergeGroupByExpressions(db, j, expressionSQL, true);
                                break;
                            }
                            sql = expr.getAlias();
                            if (!db.equalsIdentifiers(sql, e.getAlias())) continue;
                            found = this.mergeGroupByExpressions(db, j, expressionSQL, true);
                            break;
                        }
                    }
                    if (found < 0) {
                        int index;
                        this.groupIndex[i] = index = this.expressions.size();
                        this.expressions.add(expr);
                        continue;
                    }
                    this.groupIndex[i] = found;
                }
                if (this.groupByCopies != null) {
                    for (int i3 : this.groupByCopies) {
                        if (i3 < 0) {
                            continue;
                        }
                        break block25;
                    }
                    this.groupByCopies = null;
                }
            }
            this.groupByExpression = new boolean[this.expressions.size()];
            for (int gi : this.groupIndex) {
                this.groupByExpression[gi] = true;
            }
            this.group = null;
        }
        for (TableFilter f : this.filters) {
            this.mapColumns(f, 0);
        }
        this.mapCondition(this.havingIndex);
        this.mapCondition(this.qualifyIndex);
        this.checkInit = true;
    }

    private void mapCondition(int index) {
        if (index >= 0) {
            Expression expr = (Expression)this.expressions.get(index);
            SelectListColumnResolver res = new SelectListColumnResolver(this);
            expr.mapColumns(res, 0, 0);
        }
    }

    private int mergeGroupByExpressions(Database db, int index, ArrayList<String> expressionSQL, boolean scanPrevious) {
        if (this.groupByCopies != null) {
            int c = this.groupByCopies[index];
            if (c >= 0) {
                return c;
            }
            if (c == -2) {
                return index;
            }
        } else {
            this.groupByCopies = new int[expressionSQL.size()];
            Arrays.fill(this.groupByCopies, -1);
        }
        String sql = expressionSQL.get(index);
        if (scanPrevious) {
            for (int i = 0; i < index; ++i) {
                if (!db.equalsIdentifiers(sql, expressionSQL.get(i))) continue;
                index = i;
                break;
            }
        }
        int l = expressionSQL.size();
        for (int i = index + 1; i < l; ++i) {
            if (!db.equalsIdentifiers(sql, expressionSQL.get(i))) continue;
            this.groupByCopies[i] = index;
        }
        this.groupByCopies[index] = -2;
        return index;
    }

    @Override
    public void prepare() {
        if (this.isPrepared) {
            return;
        }
        if (!this.checkInit) {
            DbException.throwInternalError("not initialized");
        }
        if (this.orderList != null) {
            this.sort = this.prepareOrder(this.orderList, this.expressions.size());
            this.orderList = null;
        }
        ColumnNamer columnNamer = new ColumnNamer(this.session);
        for (int i = 0; i < this.expressions.size(); ++i) {
            String proposedColumnName;
            Expression e = (Expression)this.expressions.get(i);
            String columnName = columnNamer.getColumnName(e, i, proposedColumnName = e.getAlias());
            if (!columnName.equals(proposedColumnName)) {
                e = new Alias(e, columnName, true);
            }
            this.expressions.set(i, e.optimize(this.session));
        }
        if (this.condition != null) {
            this.condition = this.condition.optimize(this.session);
            for (TableFilter f : this.filters) {
                if (f.isJoinOuter() || f.isJoinOuterIndirect()) continue;
                this.condition.createIndexConditions(this.session, f);
            }
        }
        if (this.isGroupQuery && this.groupIndex == null && this.havingIndex < 0 && this.qualifyIndex < 0 && this.condition == null && this.filters.size() == 1) {
            this.isQuickAggregateQuery = this.isEverything(ExpressionVisitor.getOptimizableVisitor(this.filters.get(0).getTable()));
        }
        this.cost = this.preparePlan(this.session.isParsingCreateView());
        if (this.distinct && this.session.getDatabase().getSettings().optimizeDistinct && !this.isGroupQuery && this.filters.size() == 1 && this.expressions.size() == 1 && this.condition == null) {
            Expression expr = (Expression)this.expressions.get(0);
            if ((expr = expr.getNonAliasExpression()) instanceof ExpressionColumn) {
                Column column = ((ExpressionColumn)expr).getColumn();
                int selectivity = column.getSelectivity();
                Index columnIndex = this.topTableFilter.getTable().getIndexForColumn(column, false, true);
                if (columnIndex != null && selectivity != 50 && selectivity < 20) {
                    IndexType type;
                    boolean ascending = columnIndex.getIndexColumns()[0].sortType == 0;
                    Index current = this.topTableFilter.getIndex();
                    if (!(!columnIndex.canFindNext() || !ascending || current != null && !current.getIndexType().isScan() && columnIndex != current || (type = columnIndex.getIndexType()).isHash() || type.isUnique() && columnIndex.getColumns().length <= 1)) {
                        this.topTableFilter.setIndex(columnIndex);
                        this.isDistinctQuery = true;
                    }
                }
            }
        }
        if (this.sort != null && !this.isQuickAggregateQuery && !this.isGroupQuery) {
            Index index = this.getSortIndex();
            Index current = this.topTableFilter.getIndex();
            if (index != null && current != null) {
                if (current.getIndexType().isScan() || current == index) {
                    this.topTableFilter.setIndex(index);
                    if (!this.topTableFilter.hasInComparisons()) {
                        this.sortUsingIndex = true;
                    }
                } else if (index.getIndexColumns() != null && index.getIndexColumns().length >= current.getIndexColumns().length) {
                    IndexColumn[] sortColumns = index.getIndexColumns();
                    IndexColumn[] currentColumns = current.getIndexColumns();
                    boolean swapIndex = false;
                    for (int i = 0; i < currentColumns.length; ++i) {
                        if (sortColumns[i].column != currentColumns[i].column) {
                            swapIndex = false;
                            break;
                        }
                        if (sortColumns[i].sortType == currentColumns[i].sortType) continue;
                        swapIndex = true;
                    }
                    if (swapIndex) {
                        this.topTableFilter.setIndex(index);
                        this.sortUsingIndex = true;
                    }
                }
            }
            if (this.sortUsingIndex && this.isForUpdateMvcc && !this.topTableFilter.getIndex().isRowIdIndex()) {
                this.sortUsingIndex = false;
            }
        }
        if (!this.isQuickAggregateQuery && this.isGroupQuery && this.getGroupByExpressionCount() > 0) {
            Index current = this.topTableFilter.getIndex();
            if (current != null && !current.getIndexType().isScan() && this.isGroupSortedIndex(this.topTableFilter, current)) {
                this.isGroupSortedQuery = true;
            } else {
                Index groupIndex = this.getGroupSortedIndex();
                if (groupIndex != null) {
                    this.topTableFilter.setIndex(groupIndex);
                    this.isGroupSortedQuery = true;
                }
            }
        }
        this.expressionArray = this.expressions.toArray(new Expression[0]);
        this.isPrepared = true;
    }

    @Override
    public void prepareJoinBatch() {
        ArrayList<TableFilter> list = new ArrayList<TableFilter>();
        TableFilter f = this.getTopTableFilter();
        do {
            if (f.getNestedJoin() != null) {
                return;
            }
            list.add(f);
        } while ((f = f.getJoin()) != null);
        TableFilter[] fs = list.toArray(new TableFilter[0]);
        JoinBatch jb = null;
        for (int i = fs.length - 1; i >= 0; --i) {
            jb = fs[i].prepareJoinBatch(jb, fs, i);
        }
    }

    public JoinBatch getJoinBatch() {
        return this.getTopTableFilter().getJoinBatch();
    }

    @Override
    public double getCost() {
        return this.cost;
    }

    @Override
    public HashSet<Table> getTables() {
        HashSet<Table> set = new HashSet<Table>();
        for (TableFilter filter : this.filters) {
            set.add(filter.getTable());
        }
        return set;
    }

    @Override
    public void fireBeforeSelectTriggers() {
        for (TableFilter filter : this.filters) {
            filter.getTable().fire(this.session, 8, true);
        }
    }

    private double preparePlan(boolean parse) {
        TableFilter[] topArray;
        for (TableFilter t : topArray = this.topFilters.toArray(new TableFilter[0])) {
            t.createIndexConditions();
            t.setFullCondition(this.condition);
        }
        Optimizer optimizer = new Optimizer(topArray, this.condition, this.session);
        optimizer.optimize(parse);
        this.topTableFilter = optimizer.getTopFilter();
        double planCost = optimizer.getCost();
        this.setEvaluatableRecursive(this.topTableFilter);
        if (!parse) {
            this.topTableFilter.prepare();
        }
        return planCost;
    }

    private void setEvaluatableRecursive(TableFilter f) {
        while (f != null) {
            Expression on;
            TableFilter n;
            f.setEvaluatable(f, true);
            if (this.condition != null) {
                this.condition.setEvaluatable(f, true);
            }
            if ((n = f.getNestedJoin()) != null) {
                this.setEvaluatableRecursive(n);
            }
            if ((on = f.getJoinCondition()) != null && !on.isEverything(ExpressionVisitor.EVALUATABLE_VISITOR)) {
                on = on.optimize(this.session);
                if (!f.isJoinOuter() && !f.isJoinOuterIndirect()) {
                    f.removeJoinCondition();
                    this.addCondition(on);
                }
            }
            if ((on = f.getFilterCondition()) != null && !on.isEverything(ExpressionVisitor.EVALUATABLE_VISITOR)) {
                f.removeFilterCondition();
                this.addCondition(on);
            }
            for (Expression e : this.expressions) {
                e.setEvaluatable(f, true);
            }
            f = f.getJoin();
        }
    }

    @Override
    public String getPlanSQL(boolean alwaysQuote) {
        int i;
        Expression[] exprList = this.expressions.toArray(new Expression[0]);
        StringBuilder builder = new StringBuilder();
        for (TableFilter f : this.topFilters) {
            Table t = f.getTable();
            TableView tableView = t.isView() ? (TableView)t : null;
            if (tableView == null || !tableView.isRecursive() || !tableView.isTableExpression() || !tableView.isTemporary()) continue;
            builder.append("WITH RECURSIVE ");
            t.getSchema().getSQL(builder, alwaysQuote).append('.');
            Parser.quoteIdentifier(builder, t.getName(), alwaysQuote).append('(');
            Column.writeColumns(builder, t.getColumns(), alwaysQuote);
            builder.append(") AS ");
            t.getSQL(builder, alwaysQuote).append('\n');
        }
        builder.append("SELECT");
        if (this.isAnyDistinct()) {
            builder.append(" DISTINCT");
            if (this.distinctExpressions != null) {
                builder.append(" ON(");
                Expression.writeExpressions(builder, this.distinctExpressions, alwaysQuote);
                builder.append(')');
            }
        }
        for (int i2 = 0; i2 < this.visibleColumnCount; ++i2) {
            if (i2 > 0) {
                builder.append(',');
            }
            builder.append('\n');
            StringUtils.indent(builder, exprList[i2].getSQL(alwaysQuote), 4, false);
        }
        builder.append("\nFROM ");
        TableFilter filter = this.topTableFilter;
        if (filter != null) {
            i = 0;
            do {
                if (i > 0) {
                    builder.append('\n');
                }
                filter.getPlanSQL(builder, i++ > 0, alwaysQuote);
            } while ((filter = filter.getJoin()) != null);
        } else {
            i = 0;
            for (TableFilter f : this.topFilters) {
                do {
                    if (i > 0) {
                        builder.append('\n');
                    }
                    f.getPlanSQL(builder, i++ > 0, alwaysQuote);
                } while ((f = f.getJoin()) != null);
            }
        }
        if (!(this.condition == null || this.condition.isConstant() && this.condition instanceof ValueExpression && ValueBoolean.TRUE.equals(((ValueExpression)this.condition).getValue(null)))) {
            builder.append("\nWHERE ");
            this.condition.getUnenclosedSQL(builder, alwaysQuote);
        }
        if (this.groupIndex != null) {
            builder.append("\nGROUP BY ");
            int l = this.groupIndex.length;
            for (i = 0; i < l; ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                exprList[this.groupIndex[i]].getNonAliasExpression().getUnenclosedSQL(builder, alwaysQuote);
            }
        } else if (this.group != null) {
            builder.append("\nGROUP BY ");
            int l = this.group.size();
            for (i = 0; i < l; ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                this.group.get(i).getUnenclosedSQL(builder, alwaysQuote);
            }
        }
        Select.getFilterSQL(builder, "\nHAVING ", exprList, this.having, this.havingIndex);
        Select.getFilterSQL(builder, "\nQUALIFY ", exprList, this.qualify, this.qualifyIndex);
        if (this.sort != null) {
            builder.append("\nORDER BY ").append(this.sort.getSQL(exprList, this.visibleColumnCount, alwaysQuote));
        }
        if (this.orderList != null) {
            builder.append("\nORDER BY ");
            int l = this.orderList.size();
            for (i = 0; i < l; ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                ((SelectOrderBy)this.orderList.get(i)).getSQL(builder, alwaysQuote);
            }
        }
        this.appendLimitToSQL(builder, alwaysQuote);
        if (this.sampleSizeExpr != null) {
            builder.append("\nSAMPLE_SIZE ");
            this.sampleSizeExpr.getUnenclosedSQL(builder, alwaysQuote);
        }
        if (this.isForUpdate) {
            builder.append("\nFOR UPDATE");
        }
        if (this.isQuickAggregateQuery) {
            builder.append("\n/* direct lookup */");
        }
        if (this.isDistinctQuery) {
            builder.append("\n/* distinct */");
        }
        if (this.sortUsingIndex) {
            builder.append("\n/* index sorted */");
        }
        if (this.isGroupQuery && this.isGroupSortedQuery) {
            builder.append("\n/* group sorted */");
        }
        return builder.toString();
    }

    private static void getFilterSQL(StringBuilder builder, String sql, Expression[] exprList, Expression condition, int conditionIndex) {
        if (condition != null) {
            builder.append(sql);
            condition.getUnenclosedSQL(builder, true);
        } else if (conditionIndex >= 0) {
            builder.append(sql);
            exprList[conditionIndex].getUnenclosedSQL(builder, true);
        }
    }

    public void setHaving(Expression having) {
        this.having = having;
    }

    public Expression getHaving() {
        return this.having;
    }

    public void setQualify(Expression qualify) {
        this.qualify = qualify;
    }

    public Expression getQualify() {
        return this.qualify;
    }

    @Override
    public int getColumnCount() {
        return this.visibleColumnCount;
    }

    public TableFilter getTopTableFilter() {
        return this.topTableFilter;
    }

    @Override
    public void setForUpdate(boolean b) {
        if (b && (this.isAnyDistinct() || this.isGroupQuery)) {
            throw DbException.get(90145);
        }
        this.isForUpdate = b;
        if (this.session.getDatabase().isMVStore()) {
            this.isForUpdateMvcc = b;
        }
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level) {
        for (Expression e : this.expressions) {
            e.mapColumns(resolver, level, 0);
        }
        if (this.condition != null) {
            this.condition.mapColumns(resolver, level, 0);
        }
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        for (Expression e : this.expressions) {
            e.setEvaluatable(tableFilter, b);
        }
        if (this.condition != null) {
            this.condition.setEvaluatable(tableFilter, b);
        }
    }

    public boolean isQuickAggregateQuery() {
        return this.isQuickAggregateQuery;
    }

    public boolean isGroupQuery() {
        return this.isGroupQuery;
    }

    public boolean isWindowQuery() {
        return this.isWindowQuery;
    }

    public boolean isGroupWindowStage2() {
        return this.isGroupWindowStage2;
    }

    @Override
    public void addGlobalCondition(Parameter param, int columnId, int comparisonType) {
        this.addParameter(param);
        Expression col = (Expression)this.expressions.get(columnId);
        col = col.getNonAliasExpression();
        Expression comp = col.isEverything(ExpressionVisitor.QUERY_COMPARABLE_VISITOR) ? new Comparison(this.session, comparisonType, col, param) : new Comparison(this.session, 16, param, param);
        comp = ((Expression)comp).optimize(this.session);
        boolean addToCondition = true;
        if (this.isWindowQuery) {
            this.qualify = this.qualify == null ? comp : new ConditionAndOr(0, comp, this.qualify);
            return;
        }
        if (this.isGroupQuery) {
            addToCondition = false;
            for (int i = 0; this.groupIndex != null && i < this.groupIndex.length; ++i) {
                if (this.groupIndex[i] != columnId) continue;
                addToCondition = true;
                break;
            }
            if (!addToCondition) {
                if (this.havingIndex >= 0) {
                    this.having = (Expression)this.expressions.get(this.havingIndex);
                }
                this.having = this.having == null ? comp : new ConditionAndOr(0, this.having, comp);
            }
        }
        if (addToCondition) {
            this.condition = this.condition == null ? comp : new ConditionAndOr(0, this.condition, comp);
        }
    }

    @Override
    public void updateAggregate(Session s, int stage) {
        for (Expression e : this.expressions) {
            e.updateAggregate(s, stage);
        }
        if (this.condition != null) {
            this.condition.updateAggregate(s, stage);
        }
        if (this.having != null) {
            this.having.updateAggregate(s, stage);
        }
        if (this.qualify != null) {
            this.qualify.updateAggregate(s, stage);
        }
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        switch (visitor.getType()) {
            case 2: {
                if (this.isForUpdate) {
                    return false;
                }
                for (TableFilter f : this.filters) {
                    if (f.getTable().isDeterministic()) continue;
                    return false;
                }
                break;
            }
            case 4: {
                for (TableFilter f : this.filters) {
                    long m = f.getTable().getMaxDataModificationId();
                    visitor.addDataModificationId(m);
                }
                break;
            }
            case 3: {
                if (this.session.getDatabase().getSettings().optimizeEvaluatableSubqueries) break;
                return false;
            }
            case 7: {
                for (TableFilter f : this.filters) {
                    Table table = f.getTable();
                    visitor.addDependency(table);
                    table.addDependencies(visitor.getDependencies());
                }
                break;
            }
            case 11: {
                this.closeLastResult();
                break;
            }
        }
        ExpressionVisitor v2 = visitor.incrementQueryLevel(1);
        for (Expression e : this.expressions) {
            if (e.isEverything(v2)) continue;
            return false;
        }
        if (this.condition != null && !this.condition.isEverything(v2)) {
            return false;
        }
        if (this.having != null && !this.having.isEverything(v2)) {
            return false;
        }
        return this.qualify == null || this.qualify.isEverything(v2);
    }

    @Override
    public boolean isReadOnly() {
        return this.isEverything(ExpressionVisitor.READONLY_VISITOR);
    }

    @Override
    public boolean isCacheable() {
        return !this.isForUpdate;
    }

    @Override
    public boolean allowGlobalConditions() {
        return this.offsetExpr == null && (this.limitExpr == null && this.distinctExpressions == null || this.sort == null);
    }

    public SortOrder getSortOrder() {
        return this.sort;
    }

    public Select getParentSelect() {
        return this.parentSelect;
    }

    void clearHashJoinIndexAfterQuery() {
        this.topTableFilter.visit(new TableFilter.TableFilterVisitor(){

            @Override
            public void accept(TableFilter f) {
                if (f != null && f.getIndex() != null && f.getIndex().getClass() == HashJoinIndex.class) {
                    ((HashJoinIndex)f.getIndex()).clearHashTable(Select.this.session);
                }
            }
        });
    }

    private void cleanupResources() {
        for (TableFilter f : this.filters) {
            f.cleanup();
        }
    }

    private final class LazyResultGroupSorted
    extends LazyResultSelect {
        private Value[] previousKeyValues;

        LazyResultGroupSorted(Expression[] expressions, int columnCount) {
            super(expressions, columnCount);
            if (Select.this.groupData == null) {
                Select.this.setGroupData(SelectGroups.getInstance(Select.this.getSession(), Select.this.expressions, Select.this.isGroupQuery, Select.this.groupIndex));
            } else {
                Select.this.updateAgg(columnCount, 0);
                Select.this.groupData.resetLazy();
            }
        }

        @Override
        public void reset() {
            super.reset();
            Select.this.groupData.resetLazy();
            this.previousKeyValues = null;
        }

        @Override
        protected Value[] fetchNextRow() {
            while (Select.this.topTableFilter.next()) {
                Select.this.setCurrentRowNumber(this.rowNumber + 1L);
                if (!Select.this.isConditionMet()) continue;
                ++this.rowNumber;
                Object[] keyValues = new Value[Select.this.groupIndex.length];
                for (int i = 0; i < Select.this.groupIndex.length; ++i) {
                    int idx = Select.this.groupIndex[i];
                    Expression expr = (Expression)Select.this.expressions.get(idx);
                    keyValues[i] = expr.getValue(Select.this.getSession());
                }
                Value[] row = null;
                if (this.previousKeyValues == null) {
                    this.previousKeyValues = keyValues;
                    Select.this.groupData.nextLazyGroup();
                } else if (!Arrays.equals(this.previousKeyValues, keyValues)) {
                    row = Select.this.createGroupSortedRow(this.previousKeyValues, this.columnCount);
                    this.previousKeyValues = keyValues;
                    Select.this.groupData.nextLazyGroup();
                }
                Select.this.groupData.nextLazyRow();
                Select.this.updateAgg(this.columnCount, 1);
                if (row == null) continue;
                return row;
            }
            Value[] row = null;
            if (this.previousKeyValues != null) {
                row = Select.this.createGroupSortedRow(this.previousKeyValues, this.columnCount);
                this.previousKeyValues = null;
            }
            return row;
        }
    }

    private final class LazyResultQueryFlat
    extends LazyResultSelect {
        private int sampleSize;
        private boolean forUpdate;

        LazyResultQueryFlat(Expression[] expressions, int columnCount, int sampleSize, boolean forUpdate) {
            super(expressions, columnCount);
            this.sampleSize = sampleSize;
            this.forUpdate = forUpdate;
        }

        @Override
        protected Value[] fetchNextRow() {
            while ((this.sampleSize <= 0 || this.rowNumber < (long)this.sampleSize) && Select.this.topTableFilter.next()) {
                Select.this.setCurrentRowNumber(this.rowNumber + 1L);
                if (!(this.forUpdate ? Select.this.isConditionMetForUpdate() : Select.this.isConditionMet())) continue;
                ++this.rowNumber;
                Value[] row = new Value[this.columnCount];
                for (int i = 0; i < this.columnCount; ++i) {
                    Expression expr = (Expression)Select.this.expressions.get(i);
                    row[i] = expr.getValue(Select.this.getSession());
                }
                return row;
            }
            return null;
        }

        @Override
        protected boolean skipNextRow() {
            while ((this.sampleSize <= 0 || this.rowNumber < (long)this.sampleSize) && Select.this.topTableFilter.next()) {
                Select.this.setCurrentRowNumber(this.rowNumber + 1L);
                if (!Select.this.isConditionMet()) continue;
                ++this.rowNumber;
                return true;
            }
            return false;
        }
    }

    private abstract class LazyResultSelect
    extends LazyResult {
        long rowNumber;
        int columnCount;

        LazyResultSelect(Expression[] expressions, int columnCount) {
            super(expressions);
            this.columnCount = columnCount;
            Select.this.setCurrentRowNumber(0L);
        }

        @Override
        public final int getVisibleColumnCount() {
            return Select.this.visibleColumnCount;
        }

        @Override
        public void close() {
            if (!this.isClosed()) {
                super.close();
                Select.this.resetJoinBatchAfterQuery();
                Select.this.clearHashJoinIndexAfterQuery();
                Select.this.isEverything(ExpressionVisitor.getCleanupVisitor());
                Select.this.cleanupResources();
            }
        }

        @Override
        public void reset() {
            super.reset();
            Select.this.resetJoinBatchAfterQuery();
            Select.this.topTableFilter.reset();
            Select.this.setCurrentRowNumber(0L);
            this.rowNumber = 0L;
        }
    }
}

