/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.command.dml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.TreeMap;
import org.gridgain.internal.h2.command.dml.GroupByData;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.aggregate.AggregateData;
import org.gridgain.internal.h2.expression.analysis.DataAnalysisOperation;
import org.gridgain.internal.h2.expression.analysis.PartitionData;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueRow;

public abstract class SelectGroups {
    final Session session;
    final ArrayList<Expression> expressions;
    Object[] currentGroupByExprData;
    private final HashMap<Expression, Integer> exprToIndexInGroupByData = new HashMap();
    private final HashMap<DataAnalysisOperation, PartitionData> windowData = new HashMap();
    private final HashMap<DataAnalysisOperation, TreeMap<Value, PartitionData>> windowPartitionData = new HashMap();
    int currentGroupRowId;

    public static SelectGroups getInstance(Session session, ArrayList<Expression> expressions, boolean isGroupQuery, int[] groupIndex) {
        return isGroupQuery ? new Grouped(session, expressions, groupIndex) : new Plain(session, expressions);
    }

    SelectGroups(Session session, ArrayList<Expression> expressions) {
        this.session = session;
        this.expressions = expressions;
    }

    public abstract ValueRow currGroupKey();

    public boolean isCurrentGroup() {
        return this.currentGroupByExprData != null;
    }

    public final Object getCurrentGroupExprData(Expression expr) {
        Integer index = this.exprToIndexInGroupByData.get(expr);
        if (index == null) {
            return null;
        }
        return this.currentGroupByExprData[index];
    }

    public final void setCurrentGroupExprData(Expression expr, Object obj) {
        Integer index = this.exprToIndexInGroupByData.get(expr);
        if (index != null) {
            assert (this.currentGroupByExprData[index] == null);
            this.currentGroupByExprData[index.intValue()] = obj;
            return;
        }
        index = this.exprToIndexInGroupByData.size();
        this.exprToIndexInGroupByData.put(expr, index);
        if (index >= this.currentGroupByExprData.length) {
            this.currentGroupByExprData = Arrays.copyOf(this.currentGroupByExprData, this.currentGroupByExprData.length * 2);
            this.updateCurrentGroupExprData();
        }
        this.currentGroupByExprData[index.intValue()] = obj;
    }

    final int width() {
        return Math.max(this.exprToIndexInGroupByData.size(), this.expressions.size());
    }

    public final PartitionData getWindowExprData(DataAnalysisOperation expr, Value partitionKey) {
        if (partitionKey == null) {
            return this.windowData.get(expr);
        }
        TreeMap<Value, PartitionData> map = this.windowPartitionData.get(expr);
        return map != null ? map.get(partitionKey) : null;
    }

    public final void setWindowExprData(DataAnalysisOperation expr, Value partitionKey, PartitionData obj) {
        if (partitionKey == null) {
            PartitionData old = this.windowData.put(expr, obj);
            assert (old == null);
        } else {
            TreeMap<Value, PartitionData> map = this.windowPartitionData.get(expr);
            if (map == null) {
                map = new TreeMap(this.session.getDatabase().getCompareMode());
                this.windowPartitionData.put(expr, map);
            }
            map.put(partitionKey, obj);
        }
    }

    abstract void updateCurrentGroupExprData();

    public int getCurrentGroupRowId() {
        return this.currentGroupRowId;
    }

    public void reset() {
        this.currentGroupByExprData = null;
        this.exprToIndexInGroupByData.clear();
        this.windowData.clear();
        this.windowPartitionData.clear();
        this.currentGroupRowId = 0;
    }

    public abstract void nextSource();

    public void done() {
        this.currentGroupRowId = 0;
    }

    public abstract ValueRow next();

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void resetLazy() {
        this.currentGroupByExprData = null;
        this.currentGroupRowId = 0;
    }

    public static void cleanupAggregates(Object[] aggrs, Session session) {
        if (aggrs == null || session.memoryTracker() == null) {
            return;
        }
        for (Object agg : aggrs) {
            if (!(agg instanceof AggregateData)) continue;
            ((AggregateData)agg).cleanup(session);
        }
    }

    public void nextLazyGroup() {
        SelectGroups.cleanupAggregates(this.currentGroupByExprData, this.session);
        this.currentGroupByExprData = new Object[Math.max(this.exprToIndexInGroupByData.size(), this.expressions.size())];
    }

    public void nextLazyRow() {
        ++this.currentGroupRowId;
    }

    public ArrayList<Expression> expressions() {
        return this.expressions;
    }

    abstract void onRowProcessed();

    private static final class Plain
    extends SelectGroups {
        private GroupByData rows;

        Plain(Session session, ArrayList<Expression> expressions) {
            super(session, expressions);
        }

        @Override
        public ValueRow currGroupKey() {
            return null;
        }

        @Override
        public void reset() {
            super.reset();
            if (this.rows != null) {
                this.rows.reset();
            }
            this.rows = this.session.newGroupByDataInstance(this.expressions, false, null);
        }

        @Override
        public void nextSource() {
            this.currentGroupByExprData = this.rows.nextSource(null, this.width());
            ++this.currentGroupRowId;
        }

        @Override
        void updateCurrentGroupExprData() {
            this.rows.updateCurrent(this.currentGroupByExprData);
        }

        @Override
        public void done() {
            super.done();
            this.rows.done(this.width());
        }

        @Override
        public ValueRow next() {
            if (this.rows.next()) {
                this.currentGroupByExprData = this.rows.groupByExprData();
                ++this.currentGroupRowId;
                return ValueRow.getEmpty();
            }
            return null;
        }

        @Override
        void onRowProcessed() {
            this.rows.onRowProcessed();
        }
    }

    private static final class Grouped
    extends SelectGroups {
        private final int[] groupIndex;
        private GroupByData groupByData;
        private ValueRow currentGroupsKey;

        Grouped(Session session, ArrayList<Expression> expressions, int[] groupIndex) {
            super(session, expressions);
            this.groupIndex = groupIndex;
        }

        @Override
        public void reset() {
            super.reset();
            if (this.groupByData != null) {
                this.groupByData.reset();
            }
            this.groupByData = this.session.newGroupByDataInstance(this.expressions, true, this.groupIndex);
            this.currentGroupsKey = null;
        }

        @Override
        public void nextSource() {
            if (this.groupIndex == null) {
                this.currentGroupsKey = ValueRow.getEmpty();
            } else {
                Value[] keyValues = new Value[this.groupIndex.length];
                for (int i = 0; i < this.groupIndex.length; ++i) {
                    int idx = this.groupIndex[i];
                    Expression expr = (Expression)this.expressions.get(idx);
                    keyValues[i] = expr.getValue(this.session);
                }
                this.currentGroupsKey = ValueRow.get(keyValues);
            }
            this.currentGroupByExprData = this.groupByData.nextSource(this.currentGroupsKey, this.width());
            ++this.currentGroupRowId;
        }

        @Override
        public ValueRow currGroupKey() {
            return this.currentGroupsKey;
        }

        @Override
        void updateCurrentGroupExprData() {
            if (this.currentGroupsKey != null) {
                this.groupByData.updateCurrent(this.currentGroupByExprData);
            }
        }

        @Override
        public void done() {
            super.done();
            this.groupByData.done(this.width());
        }

        @Override
        public ValueRow next() {
            if (this.groupByData.next()) {
                this.currentGroupByExprData = this.groupByData.groupByExprData();
                ++this.currentGroupRowId;
                return this.groupByData.groupKey();
            }
            return null;
        }

        @Override
        public void remove() {
            this.groupByData.remove();
            Grouped.cleanupAggregates(this.currentGroupByExprData, this.session);
            this.currentGroupByExprData = null;
            --this.currentGroupRowId;
        }

        @Override
        public void resetLazy() {
            super.resetLazy();
            this.currentGroupsKey = null;
        }

        @Override
        void onRowProcessed() {
            this.groupByData.onRowProcessed();
        }
    }
}

