/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.engine;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.value.DataType;

public class Mode {
    private static final HashMap<String, Mode> MODES = new HashMap();
    public boolean aliasColumnName;
    public boolean convertInsertNullToZero;
    public boolean convertOnlyToSmallerScale;
    public boolean indexDefinitionInCreateTable;
    public boolean lowerCaseIdentifiers;
    public boolean nullConcatIsNull;
    public boolean squareBracketQuotedNames;
    public boolean systemColumns;
    public UniqueIndexNullsHandling uniqueIndexNullsHandling = UniqueIndexNullsHandling.ALLOW_DUPLICATES_WITH_ANY_NULL;
    public boolean treatEmptyStringsAsNull;
    public boolean sysDummy1;
    public boolean allowPlusForStringConcat;
    public boolean logIsLogBase10;
    public boolean regexpReplaceBackslashReferences;
    public boolean serialColumnIsNotPK;
    public boolean swapConvertFunctionParameters;
    public boolean isolationLevelInSelectOrInsertStatement;
    public boolean onDuplicateKeyUpdate;
    public Pattern supportedClientInfoPropertiesRegEx;
    public boolean supportPoundSymbolForColumnNames;
    public boolean prohibitEmptyInPredicate;
    public boolean allowAffinityKey;
    public boolean padFixedLengthStrings;
    public boolean allowDB2TimestampFormat;
    public boolean discardWithTableHints;
    public boolean useIdentityAsAutoIncrement;
    public boolean charToBinaryInUtf8;
    public boolean dateTimeValueWithinTransaction;
    public Set<String> disallowedTypes = Collections.emptySet();
    public HashMap<String, DataType> typeByNameMap = new HashMap();
    private final String name;
    private final ModeEnum modeEnum;

    private Mode(ModeEnum modeEnum) {
        this.name = modeEnum.name();
        this.modeEnum = modeEnum;
    }

    private static void add(Mode mode) {
        MODES.put(StringUtils.toUpperEnglish(mode.name), mode);
    }

    public static Mode getInstance(String name) {
        return MODES.get(StringUtils.toUpperEnglish(name));
    }

    public static Mode getRegular() {
        return Mode.getInstance(ModeEnum.REGULAR.name());
    }

    public String getName() {
        return this.name;
    }

    public ModeEnum getEnum() {
        return this.modeEnum;
    }

    public String toString() {
        return this.name;
    }

    static {
        Mode mode = new Mode(ModeEnum.REGULAR);
        mode.nullConcatIsNull = true;
        mode.dateTimeValueWithinTransaction = true;
        Mode.add(mode);
        mode = new Mode(ModeEnum.DB2);
        mode.aliasColumnName = true;
        mode.sysDummy1 = true;
        mode.isolationLevelInSelectOrInsertStatement = true;
        mode.supportedClientInfoPropertiesRegEx = Pattern.compile("ApplicationName|ClientAccountingInformation|ClientUser|ClientCorrelationToken");
        mode.prohibitEmptyInPredicate = true;
        mode.allowDB2TimestampFormat = true;
        Mode.add(mode);
        mode = new Mode(ModeEnum.Derby);
        mode.aliasColumnName = true;
        mode.uniqueIndexNullsHandling = UniqueIndexNullsHandling.FORBID_ANY_DUPLICATES;
        mode.sysDummy1 = true;
        mode.isolationLevelInSelectOrInsertStatement = true;
        mode.supportedClientInfoPropertiesRegEx = null;
        Mode.add(mode);
        mode = new Mode(ModeEnum.HSQLDB);
        mode.aliasColumnName = true;
        mode.convertOnlyToSmallerScale = true;
        mode.nullConcatIsNull = true;
        mode.uniqueIndexNullsHandling = UniqueIndexNullsHandling.FORBID_ANY_DUPLICATES;
        mode.allowPlusForStringConcat = true;
        mode.supportedClientInfoPropertiesRegEx = null;
        Mode.add(mode);
        mode = new Mode(ModeEnum.MSSQLServer);
        mode.aliasColumnName = true;
        mode.squareBracketQuotedNames = true;
        mode.uniqueIndexNullsHandling = UniqueIndexNullsHandling.FORBID_ANY_DUPLICATES;
        mode.allowPlusForStringConcat = true;
        mode.swapConvertFunctionParameters = true;
        mode.supportPoundSymbolForColumnNames = true;
        mode.discardWithTableHints = true;
        mode.useIdentityAsAutoIncrement = true;
        mode.supportedClientInfoPropertiesRegEx = null;
        DataType dt = DataType.createNumeric(19, 4, false);
        dt.type = 6;
        dt.sqlType = 2;
        dt.name = "MONEY";
        mode.typeByNameMap.put("MONEY", dt);
        dt = DataType.createNumeric(10, 4, false);
        dt.type = 6;
        dt.sqlType = 2;
        dt.name = "SMALLMONEY";
        mode.typeByNameMap.put("SMALLMONEY", dt);
        Mode.add(mode);
        mode = new Mode(ModeEnum.MySQL);
        mode.convertInsertNullToZero = true;
        mode.indexDefinitionInCreateTable = true;
        mode.lowerCaseIdentifiers = true;
        mode.regexpReplaceBackslashReferences = true;
        mode.onDuplicateKeyUpdate = true;
        mode.supportedClientInfoPropertiesRegEx = Pattern.compile(".*");
        mode.prohibitEmptyInPredicate = true;
        mode.charToBinaryInUtf8 = true;
        Mode.add(mode);
        mode = new Mode(ModeEnum.Oracle);
        mode.aliasColumnName = true;
        mode.convertOnlyToSmallerScale = true;
        mode.uniqueIndexNullsHandling = UniqueIndexNullsHandling.ALLOW_DUPLICATES_WITH_ALL_NULLS;
        mode.treatEmptyStringsAsNull = true;
        mode.regexpReplaceBackslashReferences = true;
        mode.supportPoundSymbolForColumnNames = true;
        mode.supportedClientInfoPropertiesRegEx = Pattern.compile(".*\\..*");
        mode.prohibitEmptyInPredicate = true;
        dt = DataType.createDate(19, 19, "DATE", false, 0, 0);
        dt.type = 11;
        dt.sqlType = 93;
        dt.name = "DATE";
        mode.typeByNameMap.put("DATE", dt);
        Mode.add(mode);
        mode = new Mode(ModeEnum.PostgreSQL);
        mode.aliasColumnName = true;
        mode.nullConcatIsNull = true;
        mode.systemColumns = true;
        mode.logIsLogBase10 = true;
        mode.regexpReplaceBackslashReferences = true;
        mode.serialColumnIsNotPK = true;
        mode.supportedClientInfoPropertiesRegEx = Pattern.compile("ApplicationName");
        mode.prohibitEmptyInPredicate = true;
        mode.padFixedLengthStrings = true;
        HashSet<String> disallowedTypes = new HashSet<String>();
        disallowedTypes.add("NUMBER");
        disallowedTypes.add("IDENTITY");
        disallowedTypes.add("TINYINT");
        disallowedTypes.add("BLOB");
        mode.disallowedTypes = disallowedTypes;
        dt = DataType.createNumeric(19, 2, false);
        dt.type = 6;
        dt.sqlType = 2;
        dt.name = "MONEY";
        mode.typeByNameMap.put("MONEY", dt);
        mode.dateTimeValueWithinTransaction = true;
        Mode.add(mode);
        mode = new Mode(ModeEnum.Ignite);
        mode.nullConcatIsNull = true;
        mode.allowAffinityKey = true;
        mode.indexDefinitionInCreateTable = true;
        mode.dateTimeValueWithinTransaction = true;
        Mode.add(mode);
    }

    public static enum UniqueIndexNullsHandling {
        ALLOW_DUPLICATES_WITH_ANY_NULL,
        ALLOW_DUPLICATES_WITH_ALL_NULLS,
        FORBID_ANY_DUPLICATES;

    }

    public static enum ModeEnum {
        REGULAR,
        DB2,
        Derby,
        MSSQLServer,
        HSQLDB,
        MySQL,
        Oracle,
        PostgreSQL,
        Ignite;

    }
}

