/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.engine;

import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.DbObject;
import org.gridgain.internal.h2.engine.DbObjectBase;
import org.gridgain.internal.h2.engine.RightOwner;
import org.gridgain.internal.h2.engine.Role;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.schema.Schema;
import org.gridgain.internal.h2.table.Table;

public class Right
extends DbObjectBase {
    public static final int SELECT = 1;
    public static final int DELETE = 2;
    public static final int INSERT = 4;
    public static final int UPDATE = 8;
    public static final int ALTER_ANY_SCHEMA = 16;
    public static final int ALL = 15;
    private RightOwner grantee;
    private Role grantedRole;
    private int grantedRight;
    private DbObject grantedObject;

    public Right(Database db, int id, RightOwner grantee, Role grantedRole) {
        super(db, id, "RIGHT_" + id, 13);
        this.grantee = grantee;
        this.grantedRole = grantedRole;
    }

    public Right(Database db, int id, RightOwner grantee, int grantedRight, DbObject grantedObject) {
        super(db, id, Integer.toString(id), 13);
        this.grantee = grantee;
        this.grantedRight = grantedRight;
        this.grantedObject = grantedObject;
    }

    private static boolean appendRight(StringBuilder buff, int right, int mask, String name, boolean comma) {
        if ((right & mask) != 0) {
            if (comma) {
                buff.append(", ");
            }
            buff.append(name);
            return true;
        }
        return comma;
    }

    public String getRights() {
        StringBuilder buff = new StringBuilder();
        if (this.grantedRight == 15) {
            buff.append("ALL");
        } else {
            boolean comma = false;
            comma = Right.appendRight(buff, this.grantedRight, 1, "SELECT", comma);
            comma = Right.appendRight(buff, this.grantedRight, 2, "DELETE", comma);
            comma = Right.appendRight(buff, this.grantedRight, 4, "INSERT", comma);
            comma = Right.appendRight(buff, this.grantedRight, 16, "ALTER ANY SCHEMA", comma);
            Right.appendRight(buff, this.grantedRight, 8, "UPDATE", comma);
        }
        return buff.toString();
    }

    public Role getGrantedRole() {
        return this.grantedRole;
    }

    public DbObject getGrantedObject() {
        return this.grantedObject;
    }

    public DbObject getGrantee() {
        return this.grantee;
    }

    @Override
    public String getDropSQL() {
        return null;
    }

    @Override
    public String getCreateSQLForCopy(Table table, String quotedName) {
        return this.getCreateSQLForCopy(table);
    }

    private String getCreateSQLForCopy(DbObject object) {
        StringBuilder buff = new StringBuilder();
        buff.append("GRANT ");
        if (this.grantedRole != null) {
            this.grantedRole.getSQL(buff, true);
        } else {
            buff.append(this.getRights());
            if (object != null) {
                if (object instanceof Schema) {
                    buff.append(" ON SCHEMA ");
                    object.getSQL(buff, true);
                } else if (object instanceof Table) {
                    buff.append(" ON ");
                    object.getSQL(buff, true);
                }
            }
        }
        buff.append(" TO ");
        this.grantee.getSQL(buff, true);
        return buff.toString();
    }

    @Override
    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.grantedObject);
    }

    @Override
    public int getType() {
        return 8;
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        if (this.grantedRole != null) {
            this.grantee.revokeRole(this.grantedRole);
        } else {
            this.grantee.revokeRight(this.grantedObject);
        }
        this.database.removeMeta(session, this.getId());
        this.grantedRole = null;
        this.grantedObject = null;
        this.grantee = null;
        this.invalidate();
    }

    @Override
    public void checkRename() {
        DbException.throwInternalError();
    }

    public void setRightMask(int rightMask) {
        this.grantedRight = rightMask;
    }

    public int getRightMask() {
        return this.grantedRight;
    }
}

