/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.expression;

import org.gridgain.internal.h2.command.Parser;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.ExpressionColumn;
import org.gridgain.internal.h2.expression.ExpressionVisitor;
import org.gridgain.internal.h2.table.ColumnResolver;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;

public class Alias
extends Expression {
    private final String alias;
    private Expression expr;
    private final boolean aliasColumnName;

    public Alias(Expression expression, String alias, boolean aliasColumnName) {
        this.expr = expression;
        this.alias = alias;
        this.aliasColumnName = aliasColumnName;
    }

    @Override
    public Expression getNonAliasExpression() {
        return this.expr;
    }

    @Override
    public Value getValue(Session session) {
        return this.expr.getValue(session);
    }

    @Override
    public TypeInfo getType() {
        return this.expr.getType();
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        this.expr.mapColumns(resolver, level, state);
    }

    @Override
    public Expression optimize(Session session) {
        this.expr = this.expr.optimize(session);
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.expr.setEvaluatable(tableFilter, b);
    }

    @Override
    public boolean isAutoIncrement() {
        return this.expr.isAutoIncrement();
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, boolean alwaysQuote) {
        this.expr.getSQL(builder, alwaysQuote).append(" AS ");
        return Parser.quoteIdentifier(builder, this.alias, alwaysQuote);
    }

    @Override
    public void updateAggregate(Session session, int stage) {
        this.expr.updateAggregate(session, stage);
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public int getNullable() {
        return this.expr.getNullable();
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        return this.expr.isEverything(visitor);
    }

    @Override
    public int getCost() {
        return this.expr.getCost();
    }

    @Override
    public String getTableName() {
        if (this.aliasColumnName) {
            return null;
        }
        return this.expr.getTableName();
    }

    @Override
    public String getColumnName() {
        if (!(this.expr instanceof ExpressionColumn) || this.aliasColumnName) {
            return this.alias;
        }
        return this.expr.getColumnName();
    }
}

