/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.expression;

import org.gridgain.internal.h2.command.Parser;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.ExpressionVisitor;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.table.ColumnResolver;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;

public class Variable
extends Expression {
    private final String name;
    private Value lastValue;

    public Variable(Session session, String name) {
        this.name = name;
        this.lastValue = session.getVariable(name);
    }

    @Override
    public int getCost() {
        return 0;
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, boolean alwaysQuote) {
        builder.append('@');
        return Parser.quoteIdentifier(builder, this.name, alwaysQuote);
    }

    @Override
    public TypeInfo getType() {
        return this.lastValue.getType();
    }

    @Override
    public Value getValue(Session session) {
        this.lastValue = session.getVariable(this.name);
        return this.lastValue;
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        switch (visitor.getType()) {
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw DbException.throwInternalError("type=" + visitor.getType());
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
    }

    @Override
    public Expression optimize(Session session) {
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean value) {
    }

    @Override
    public void updateAggregate(Session session, int stage) {
    }

    public String getName() {
        return this.name;
    }
}

