/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.expression;

import java.util.ArrayList;
import java.util.HashMap;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.ExpressionColumn;
import org.gridgain.internal.h2.expression.ExpressionVisitor;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.ColumnResolver;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;

public class Wildcard
extends Expression {
    private final String schema;
    private final String table;
    private ArrayList<ExpressionColumn> exceptColumns;

    public Wildcard(String schema, String table) {
        this.schema = schema;
        this.table = table;
    }

    public ArrayList<ExpressionColumn> getExceptColumns() {
        return this.exceptColumns;
    }

    public void setExceptColumns(ArrayList<ExpressionColumn> exceptColumns) {
        this.exceptColumns = exceptColumns;
    }

    public HashMap<Column, ExpressionColumn> mapExceptColumns() {
        HashMap<Column, ExpressionColumn> exceptTableColumns = new HashMap<Column, ExpressionColumn>();
        for (ExpressionColumn ec : this.exceptColumns) {
            Column column = ec.getColumn();
            if (column == null) {
                throw ec.getColumnException(42122);
            }
            if (exceptTableColumns.put(column, ec) == null) continue;
            throw ec.getColumnException(42121);
        }
        return exceptTableColumns;
    }

    @Override
    public Value getValue(Session session) {
        throw DbException.throwInternalError(this.toString());
    }

    @Override
    public TypeInfo getType() {
        throw DbException.throwInternalError(this.toString());
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        if (this.exceptColumns != null) {
            for (ExpressionColumn column : this.exceptColumns) {
                column.mapColumns(resolver, level, state);
            }
        }
    }

    @Override
    public Expression optimize(Session session) {
        throw DbException.get(42000, this.table);
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        DbException.throwInternalError(this.toString());
    }

    @Override
    public String getTableAlias() {
        return this.table;
    }

    @Override
    public String getSchemaName() {
        return this.schema;
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, boolean alwaysQuote) {
        if (this.table != null) {
            StringUtils.quoteIdentifier(builder, this.table).append('.');
        }
        builder.append('*');
        if (this.exceptColumns != null) {
            builder.append(" EXCEPT (");
            Wildcard.writeExpressions(builder, this.exceptColumns, alwaysQuote);
            builder.append(')');
        }
        return builder;
    }

    @Override
    public void updateAggregate(Session session, int stage) {
        DbException.throwInternalError(this.toString());
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        if (visitor.getType() == 8) {
            return true;
        }
        throw DbException.throwInternalError(Integer.toString(visitor.getType()));
    }

    @Override
    public int getCost() {
        throw DbException.throwInternalError(this.toString());
    }
}

