/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.expression.condition;

import java.util.ArrayList;
import java.util.TreeSet;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.Mode;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.ExpressionColumn;
import org.gridgain.internal.h2.expression.ExpressionVisitor;
import org.gridgain.internal.h2.expression.condition.Comparison;
import org.gridgain.internal.h2.expression.condition.Condition;
import org.gridgain.internal.h2.index.IndexCondition;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.table.ColumnResolver;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueBoolean;
import org.gridgain.internal.h2.value.ValueNull;

public class ConditionInConstantSet
extends Condition {
    private Expression left;
    private final ArrayList<Expression> valueList;
    private final TreeSet<Value> valueSet;
    private boolean hasNull;
    private final TypeInfo type;

    public ConditionInConstantSet(Session session, Expression left, ArrayList<Expression> valueList) {
        this.left = left;
        this.valueList = valueList;
        Database database = session.getDatabase();
        this.valueSet = new TreeSet<Value>(database.getCompareMode());
        this.type = left.getType();
        Mode mode = database.getMode();
        for (Expression expression : valueList) {
            this.add(expression.getValue(session).convertTo(this.type, mode, null));
        }
    }

    private void add(Value v) {
        if (v.containsNull()) {
            this.hasNull = true;
        } else {
            this.valueSet.add(v);
        }
    }

    @Override
    public Value getValue(Session session) {
        Value x = this.left.getValue(session);
        if (x.containsNull()) {
            return x;
        }
        boolean result = this.valueSet.contains(x);
        if (!result && this.hasNull) {
            return ValueNull.INSTANCE;
        }
        return ValueBoolean.get(result);
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        this.left.mapColumns(resolver, level, state);
    }

    @Override
    public Expression optimize(Session session) {
        this.left = this.left.optimize(session);
        return this;
    }

    @Override
    public void createIndexConditions(Session session, TableFilter filter) {
        if (!(this.left instanceof ExpressionColumn)) {
            return;
        }
        ExpressionColumn l = (ExpressionColumn)this.left;
        if (filter != l.getTableFilter()) {
            return;
        }
        if (session.getDatabase().getSettings().optimizeInList) {
            filter.addIndexCondition(IndexCondition.getInList(l, this.valueList));
        }
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.left.setEvaluatable(tableFilter, b);
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, boolean alwaysQuote) {
        builder.append('(');
        this.left.getSQL(builder, alwaysQuote).append(" IN(");
        ConditionInConstantSet.writeExpressions(builder, this.valueList, alwaysQuote);
        return builder.append("))");
    }

    @Override
    public void updateAggregate(Session session, int stage) {
        this.left.updateAggregate(session, stage);
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        if (!this.left.isEverything(visitor)) {
            return false;
        }
        switch (visitor.getType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        throw DbException.throwInternalError("type=" + visitor.getType());
    }

    @Override
    public int getCost() {
        return this.left.getCost();
    }

    Expression getAdditional(Session session, Comparison other) {
        Expression add = other.getIfEquals(this.left);
        if (add != null && add.isConstant()) {
            this.valueList.add(add);
            this.add(add.getValue(session).convertTo(this.type, session.getDatabase().getMode(), null));
            return this;
        }
        return null;
    }

    @Override
    public int getSubexpressionCount() {
        return 1 + this.valueList.size();
    }

    @Override
    public Expression getSubexpression(int index) {
        if (index == 0) {
            return this.left;
        }
        if (index > 0 && index <= this.valueList.size()) {
            return this.valueList.get(index - 1);
        }
        throw new IndexOutOfBoundsException();
    }
}

