/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.expression.condition;

import java.util.AbstractList;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.ExpressionColumn;
import org.gridgain.internal.h2.expression.ExpressionVisitor;
import org.gridgain.internal.h2.expression.Parameter;
import org.gridgain.internal.h2.expression.ValueExpression;
import org.gridgain.internal.h2.expression.condition.Comparison;
import org.gridgain.internal.h2.expression.condition.Condition;
import org.gridgain.internal.h2.index.IndexCondition;
import org.gridgain.internal.h2.result.ResultInterface;
import org.gridgain.internal.h2.table.ColumnResolver;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueArray;
import org.gridgain.internal.h2.value.ValueBoolean;
import org.gridgain.internal.h2.value.ValueNull;

public class ConditionInParameter
extends Condition {
    private final Database database;
    private Expression left;
    private final Parameter parameter;

    static Value getValue(Database database, Value l, Value value) {
        boolean hasNull = false;
        if (value.containsNull()) {
            hasNull = true;
        } else if (value.getValueType() == 18) {
            ResultInterface ri = value.getResult();
            while (ri.next()) {
                Value r = ri.currentRow()[0];
                Value cmp = Comparison.compare(database, l, r, 0);
                if (cmp == ValueNull.INSTANCE) {
                    hasNull = true;
                    continue;
                }
                if (cmp != ValueBoolean.TRUE) continue;
                return cmp;
            }
        } else {
            for (Value r : ((ValueArray)value.convertTo(17)).getList()) {
                Value cmp = Comparison.compare(database, l, r, 0);
                if (cmp == ValueNull.INSTANCE) {
                    hasNull = true;
                    continue;
                }
                if (cmp != ValueBoolean.TRUE) continue;
                return cmp;
            }
        }
        if (hasNull) {
            return ValueNull.INSTANCE;
        }
        return ValueBoolean.FALSE;
    }

    public ConditionInParameter(Database database, Expression left, Parameter parameter) {
        this.database = database;
        this.left = left;
        this.parameter = parameter;
    }

    @Override
    public Value getValue(Session session) {
        Value l = this.left.getValue(session);
        if (l == ValueNull.INSTANCE) {
            return l;
        }
        return ConditionInParameter.getValue(this.database, l, this.parameter.getValue(session));
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        this.left.mapColumns(resolver, level, state);
    }

    @Override
    public Expression optimize(Session session) {
        this.left = this.left.optimize(session);
        if (this.left == ValueExpression.getNull()) {
            return this.left;
        }
        return this;
    }

    @Override
    public void createIndexConditions(Session session, TableFilter filter) {
        if (!(this.left instanceof ExpressionColumn)) {
            return;
        }
        ExpressionColumn l = (ExpressionColumn)this.left;
        if (filter != l.getTableFilter()) {
            return;
        }
        filter.addIndexCondition(IndexCondition.getInList(l, new ParameterList(this.parameter)));
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.left.setEvaluatable(tableFilter, b);
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, boolean alwaysQuote) {
        builder.append('(');
        this.left.getSQL(builder, alwaysQuote).append(" = ANY(");
        return this.parameter.getSQL(builder, alwaysQuote).append("))");
    }

    @Override
    public void updateAggregate(Session session, int stage) {
        this.left.updateAggregate(session, stage);
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        return this.left.isEverything(visitor) && this.parameter.isEverything(visitor);
    }

    @Override
    public int getCost() {
        return this.left.getCost();
    }

    private static final class ParameterList
    extends AbstractList<Expression> {
        private final Parameter parameter;

        ParameterList(Parameter parameter) {
            this.parameter = parameter;
        }

        @Override
        public Expression get(int index) {
            Value value = this.parameter.getParamValue();
            if (value instanceof ValueArray) {
                return ValueExpression.get(((ValueArray)value).getList()[index]);
            }
            if (index != 0) {
                throw new IndexOutOfBoundsException();
            }
            return ValueExpression.get(value);
        }

        @Override
        public int size() {
            if (!this.parameter.isValueSet()) {
                return 0;
            }
            Value value = this.parameter.getParamValue();
            if (value instanceof ValueArray) {
                return ((ValueArray)value).getList().length;
            }
            return 1;
        }
    }
}

