/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.expression.condition;

import java.util.Arrays;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.ExpressionVisitor;
import org.gridgain.internal.h2.expression.ValueExpression;
import org.gridgain.internal.h2.expression.condition.Condition;
import org.gridgain.internal.h2.table.ColumnResolver;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueBoolean;
import org.gridgain.internal.h2.value.ValueNull;

public class TypePredicate
extends Condition {
    private Expression left;
    private final boolean not;
    private final TypeInfo[] typeList;
    private int[] valueTypes;

    public TypePredicate(Expression left, boolean not, TypeInfo[] typeList) {
        this.left = left;
        this.not = not;
        this.typeList = typeList;
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, boolean alwaysQuote) {
        builder.append('(');
        this.left.getSQL(builder, alwaysQuote).append(" IS");
        if (this.not) {
            builder.append(" NOT");
        }
        builder.append(" OF (");
        for (int i = 0; i < this.typeList.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            this.typeList[i].getSQL(builder);
        }
        return builder.append(')');
    }

    @Override
    public Expression optimize(Session session) {
        this.left = this.left.optimize(session);
        int count = this.typeList.length;
        this.valueTypes = new int[count];
        for (int i = 0; i < count; ++i) {
            this.valueTypes[i] = this.typeList[i].getValueType();
        }
        Arrays.sort(this.valueTypes);
        if (this.left.isConstant()) {
            return ValueExpression.get(this.getValue(session));
        }
        return this;
    }

    @Override
    public Value getValue(Session session) {
        Value l = this.left.getValue(session);
        if (l == ValueNull.INSTANCE) {
            return ValueNull.INSTANCE;
        }
        return ValueBoolean.get(Arrays.binarySearch(this.valueTypes, l.getValueType()) >= 0 ^ this.not);
    }

    @Override
    public Expression getNotIfPossible(Session session) {
        return new TypePredicate(this.left, !this.not, this.typeList);
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.left.setEvaluatable(tableFilter, b);
    }

    @Override
    public void updateAggregate(Session session, int stage) {
        this.left.updateAggregate(session, stage);
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        this.left.mapColumns(resolver, level, state);
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        return this.left.isEverything(visitor);
    }

    @Override
    public int getCost() {
        return this.left.getCost() + 1;
    }

    @Override
    public int getSubexpressionCount() {
        return 1;
    }

    @Override
    public Expression getSubexpression(int index) {
        if (index == 0) {
            return this.left;
        }
        throw new IndexOutOfBoundsException();
    }
}

