/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.expression.function;

import java.util.List;
import java.util.TimeZone;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.function.ToDateTokenizer;
import org.gridgain.internal.h2.util.DateTimeUtils;
import org.gridgain.internal.h2.value.ValueTimestamp;
import org.gridgain.internal.h2.value.ValueTimestampTimeZone;

public class ToDateParser {
    private final Session session;
    private final String unmodifiedInputStr;
    private final String unmodifiedFormatStr;
    private final ConfigParam functionName;
    private String inputStr;
    private String formatStr;
    private boolean doyValid = false;
    private boolean absoluteDayValid = false;
    private boolean hour12Valid = false;
    private boolean timeZoneHMValid = false;
    private boolean bc;
    private long absoluteDay;
    private int year;
    private int month;
    private int day = 1;
    private int dayOfYear;
    private int hour;
    private int minute;
    private int second;
    private int nanos;
    private int hour12;
    private boolean isAM = true;
    private TimeZone timeZone;
    private int timeZoneHour;
    private int timeZoneMinute;
    private int currentYear;
    private int currentMonth;

    private ToDateParser(Session session, ConfigParam functionName, String input, String format) {
        this.session = session;
        this.functionName = functionName;
        this.unmodifiedInputStr = this.inputStr = input.trim();
        this.formatStr = format == null || format.isEmpty() ? functionName.getDefaultFormatStr() : format.trim();
        this.unmodifiedFormatStr = this.formatStr;
    }

    private static ToDateParser getTimestampParser(Session session, ConfigParam param, String input, String format) {
        ToDateParser result = new ToDateParser(session, param, input, format);
        ToDateParser.parse(result);
        return result;
    }

    private ValueTimestamp getResultingValue() {
        int hour;
        long dateValue;
        if (this.absoluteDayValid) {
            dateValue = DateTimeUtils.dateValueFromAbsoluteDay(this.absoluteDay);
        } else {
            int year = this.year;
            if (year == 0) {
                year = this.getCurrentYear();
            }
            if (this.bc) {
                year = 1 - year;
            }
            if (this.doyValid) {
                dateValue = DateTimeUtils.dateValueFromAbsoluteDay(DateTimeUtils.absoluteDayFromYear(year) + (long)this.dayOfYear - 1L);
            } else {
                int month = this.month;
                if (month == 0) {
                    month = this.getCurrentMonth();
                }
                dateValue = DateTimeUtils.dateValue(year, month, this.day);
            }
        }
        if (this.hour12Valid) {
            hour = this.hour12 % 12;
            if (!this.isAM) {
                hour += 12;
            }
        } else {
            hour = this.hour;
        }
        long timeNanos = (long)((hour * 60 + this.minute) * 60 + this.second) * 1000000000L + (long)this.nanos;
        return ValueTimestamp.fromDateValueAndNanos(dateValue, timeNanos);
    }

    private ValueTimestampTimeZone getResultingValueWithTimeZone() {
        short offset;
        ValueTimestamp ts = this.getResultingValue();
        long dateValue = ts.getDateValue();
        if (this.timeZoneHMValid) {
            offset = (short)(this.timeZoneHour * 60 + (this.timeZoneHour >= 0 ? this.timeZoneMinute : -this.timeZoneMinute));
        } else {
            TimeZone timeZone = this.timeZone;
            if (timeZone == null) {
                timeZone = TimeZone.getDefault();
            }
            long millis = DateTimeUtils.convertDateTimeValueToMillis(timeZone, dateValue, this.nanos / 1000000);
            offset = (short)(timeZone.getOffset(millis) / 60000);
        }
        return ValueTimestampTimeZone.fromDateValueAndNanos(dateValue, ts.getTimeNanos(), offset);
    }

    String getInputStr() {
        return this.inputStr;
    }

    String getFormatStr() {
        return this.formatStr;
    }

    String getFunctionName() {
        return this.functionName.name();
    }

    private void queryCurrentYearAndMonth() {
        long dateValue = (this.session.getDatabase().getMode().dateTimeValueWithinTransaction ? this.session.getTransactionStart() : this.session.getCurrentCommandStart()).getDateValue();
        this.currentYear = DateTimeUtils.yearFromDateValue(dateValue);
        this.currentMonth = DateTimeUtils.monthFromDateValue(dateValue);
    }

    int getCurrentYear() {
        if (this.currentYear == 0) {
            this.queryCurrentYearAndMonth();
        }
        return this.currentYear;
    }

    int getCurrentMonth() {
        if (this.currentMonth == 0) {
            this.queryCurrentYearAndMonth();
        }
        return this.currentMonth;
    }

    void setAbsoluteDay(int absoluteDay) {
        this.doyValid = false;
        this.absoluteDayValid = true;
        this.absoluteDay = absoluteDay;
    }

    void setBC(boolean bc) {
        this.doyValid = false;
        this.absoluteDayValid = false;
        this.bc = bc;
    }

    void setYear(int year) {
        this.doyValid = false;
        this.absoluteDayValid = false;
        this.year = year;
    }

    void setMonth(int month) {
        this.doyValid = false;
        this.absoluteDayValid = false;
        this.month = month;
        if (this.year == 0) {
            this.year = 1970;
        }
    }

    void setDay(int day) {
        this.doyValid = false;
        this.absoluteDayValid = false;
        this.day = day;
        if (this.year == 0) {
            this.year = 1970;
        }
    }

    void setDayOfYear(int dayOfYear) {
        this.doyValid = true;
        this.absoluteDayValid = false;
        this.dayOfYear = dayOfYear;
    }

    void setHour(int hour) {
        this.hour12Valid = false;
        this.hour = hour;
    }

    void setMinute(int minute) {
        this.minute = minute;
    }

    void setSecond(int second) {
        this.second = second;
    }

    void setNanos(int nanos) {
        this.nanos = nanos;
    }

    void setAmPm(boolean isAM) {
        this.hour12Valid = true;
        this.isAM = isAM;
    }

    void setHour12(int hour12) {
        this.hour12Valid = true;
        this.hour12 = hour12;
    }

    void setTimeZone(TimeZone timeZone) {
        this.timeZoneHMValid = false;
        this.timeZone = timeZone;
    }

    void setTimeZoneHour(int timeZoneHour) {
        this.timeZoneHMValid = true;
        this.timeZoneHour = timeZoneHour;
    }

    void setTimeZoneMinute(int timeZoneMinute) {
        this.timeZoneHMValid = true;
        this.timeZoneMinute = timeZoneMinute;
    }

    private boolean hasToParseData() {
        return !this.formatStr.isEmpty();
    }

    private void removeFirstChar() {
        if (!this.formatStr.isEmpty()) {
            this.formatStr = this.formatStr.substring(1);
        }
        if (!this.inputStr.isEmpty()) {
            this.inputStr = this.inputStr.substring(1);
        }
    }

    private static ToDateParser parse(ToDateParser p) {
        while (p.hasToParseData()) {
            List<ToDateTokenizer.FormatTokenEnum> tokenList = ToDateTokenizer.FormatTokenEnum.getTokensInQuestion(p.getFormatStr());
            if (tokenList == null) {
                p.removeFirstChar();
                continue;
            }
            boolean foundAnToken = false;
            for (ToDateTokenizer.FormatTokenEnum token : tokenList) {
                if (!token.parseFormatStrWithToken(p)) continue;
                foundAnToken = true;
                break;
            }
            if (foundAnToken) continue;
            p.removeFirstChar();
        }
        return p;
    }

    void remove(String inputFragmentStr, String formatFragment) {
        if (inputFragmentStr != null && this.inputStr.length() >= inputFragmentStr.length()) {
            this.inputStr = this.inputStr.substring(inputFragmentStr.length());
        }
        if (formatFragment != null && this.formatStr.length() >= formatFragment.length()) {
            this.formatStr = this.formatStr.substring(formatFragment.length());
        }
    }

    public String toString() {
        int inputStrLen = this.inputStr.length();
        int orgInputLen = this.unmodifiedInputStr.length();
        int currentInputPos = orgInputLen - inputStrLen;
        int restInputLen = inputStrLen <= 0 ? inputStrLen : inputStrLen - 1;
        int orgFormatLen = this.unmodifiedFormatStr.length();
        int currentFormatPos = orgFormatLen - this.formatStr.length();
        return String.format("\n    %s('%s', '%s')", new Object[]{this.functionName, this.unmodifiedInputStr, this.unmodifiedFormatStr}) + String.format("\n      %s^%s ,  %s^ <-- Parsing failed at this point", String.format("%" + (this.functionName.name().length() + currentInputPos) + "s", ""), restInputLen <= 0 ? "" : String.format("%" + restInputLen + "s", ""), currentFormatPos <= 0 ? "" : String.format("%" + currentFormatPos + "s", ""));
    }

    public static ValueTimestamp toTimestamp(Session session, String input, String format) {
        ToDateParser parser = ToDateParser.getTimestampParser(session, ConfigParam.TO_TIMESTAMP, input, format);
        return parser.getResultingValue();
    }

    public static ValueTimestampTimeZone toTimestampTz(Session session, String input, String format) {
        ToDateParser parser = ToDateParser.getTimestampParser(session, ConfigParam.TO_TIMESTAMP_TZ, input, format);
        return parser.getResultingValueWithTimeZone();
    }

    public static ValueTimestamp toDate(Session session, String input, String format) {
        ToDateParser parser = ToDateParser.getTimestampParser(session, ConfigParam.TO_DATE, input, format);
        return parser.getResultingValue();
    }

    private static enum ConfigParam {
        TO_DATE("DD MON YYYY"),
        TO_TIMESTAMP("DD MON YYYY HH:MI:SS"),
        TO_TIMESTAMP_TZ("DD MON YYYY HH:MI:SS TZR");

        private final String defaultFormatStr;

        private ConfigParam(String defaultFormatStr) {
            this.defaultFormatStr = defaultFormatStr;
        }

        String getDefaultFormatStr() {
            return this.defaultFormatStr;
        }
    }
}

