/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.index;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.gridgain.internal.h2.command.dml.AllColumnsForPlan;
import org.gridgain.internal.h2.engine.Mode;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.index.BaseIndex;
import org.gridgain.internal.h2.index.Cursor;
import org.gridgain.internal.h2.index.IndexType;
import org.gridgain.internal.h2.index.NonUniqueHashCursor;
import org.gridgain.internal.h2.index.SingleRowCursor;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.SearchRow;
import org.gridgain.internal.h2.result.SortOrder;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.IndexColumn;
import org.gridgain.internal.h2.table.PageStoreTable;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.value.DataType;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueNull;

public class HashIndex
extends BaseIndex {
    private final int indexColumn;
    private final boolean totalOrdering;
    private final PageStoreTable tableData;
    private Map<Value, Long> rows;
    private final ArrayList<Long> nullRows = new ArrayList();

    public HashIndex(PageStoreTable table, int id, String indexName, IndexColumn[] columns, IndexType indexType) {
        super(table, id, indexName, columns, indexType);
        Column column = columns[0].column;
        this.indexColumn = column.getColumnId();
        this.totalOrdering = DataType.hasTotalOrdering(column.getType().getValueType());
        this.tableData = table;
        this.reset();
    }

    private void reset() {
        this.rows = this.totalOrdering ? new HashMap() : new TreeMap(this.database.getCompareMode());
    }

    @Override
    public void truncate(Session session) {
        this.reset();
    }

    @Override
    public void add(Session session, Row row) {
        Value key = row.getValue(this.indexColumn);
        if (key != ValueNull.INSTANCE || this.database.getMode().uniqueIndexNullsHandling == Mode.UniqueIndexNullsHandling.FORBID_ANY_DUPLICATES) {
            Long old = this.rows.get(key);
            if (old != null) {
                throw this.getDuplicateKeyException(key.toString());
            }
            this.rows.put(key, row.getKey());
        } else {
            this.nullRows.add(row.getKey());
        }
    }

    @Override
    public void remove(Session session, Row row) {
        Value key = row.getValue(this.indexColumn);
        if (key != ValueNull.INSTANCE || this.database.getMode().uniqueIndexNullsHandling == Mode.UniqueIndexNullsHandling.FORBID_ANY_DUPLICATES) {
            this.rows.remove(key);
        } else {
            this.nullRows.remove(row.getKey());
        }
    }

    @Override
    public Cursor find(Session session, SearchRow first, SearchRow last) {
        if (first == null || last == null) {
            throw DbException.throwInternalError(first + " " + last);
        }
        Value v = first.getValue(this.indexColumn);
        if (v == ValueNull.INSTANCE && this.database.getMode().uniqueIndexNullsHandling != Mode.UniqueIndexNullsHandling.FORBID_ANY_DUPLICATES) {
            return new NonUniqueHashCursor(session, this.tableData, this.nullRows);
        }
        Long pos = this.rows.get(v = v.convertTo(this.tableData.getColumn(this.indexColumn).getType(), this.database.getMode(), null));
        Row result = pos == null ? null : this.tableData.getRow(session, pos.intValue());
        return new SingleRowCursor(result);
    }

    @Override
    public long getRowCount(Session session) {
        return this.getRowCountApproximation(session);
    }

    @Override
    public long getRowCountApproximation(Session ses) {
        return this.rows.size() + this.nullRows.size();
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void remove(Session session) {
    }

    @Override
    public double getCost(Session session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan allColumnsSet) {
        for (Column column : this.columns) {
            int index = column.getColumnId();
            int mask = masks[index];
            if ((mask & 1) == 1) continue;
            return 9.223372036854776E18;
        }
        return 2.0;
    }

    @Override
    public void checkRename() {
    }

    @Override
    public boolean needRebuild() {
        return true;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return false;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean first) {
        throw DbException.getUnsupportedException("HASH");
    }

    @Override
    public boolean canScan() {
        return false;
    }
}

