/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.index;

import java.util.Arrays;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.index.PageBtree;
import org.gridgain.internal.h2.index.PageBtreeCursor;
import org.gridgain.internal.h2.index.PageBtreeIndex;
import org.gridgain.internal.h2.index.PageBtreeNode;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.SearchRow;
import org.gridgain.internal.h2.store.Data;
import org.gridgain.internal.h2.store.Page;
import org.gridgain.internal.h2.store.PageStore;

public class PageBtreeLeaf
extends PageBtree {
    private static final int OFFSET_LENGTH = 2;
    private final boolean optimizeUpdate;
    private boolean writtenData;

    private PageBtreeLeaf(PageBtreeIndex index, int pageId, Data data) {
        super(index, pageId, data);
        this.optimizeUpdate = index.getDatabase().getSettings().optimizeUpdate;
    }

    public static Page read(PageBtreeIndex index, Data data, int pageId) {
        PageBtreeLeaf p = new PageBtreeLeaf(index, pageId, data);
        p.read();
        return p;
    }

    static PageBtreeLeaf create(PageBtreeIndex index, int pageId, int parentPageId) {
        PageBtreeLeaf p = new PageBtreeLeaf(index, pageId, index.getPageStore().createData());
        index.getPageStore().logUndo(p, null);
        p.rows = SearchRow.EMPTY_ARRAY;
        p.parentPageId = parentPageId;
        p.writeHead();
        p.start = p.data.length();
        return p;
    }

    private void read() {
        this.data.reset();
        byte type = this.data.readByte();
        this.data.readShortInt();
        this.parentPageId = this.data.readInt();
        this.onlyPosition = (type & 0x10) == 0;
        int indexId = this.data.readVarInt();
        if (indexId != this.index.getId()) {
            throw DbException.get(90030, "page:" + this.getPos() + " expected index:" + this.index.getId() + "got:" + indexId);
        }
        this.entryCount = this.data.readShortInt();
        this.offsets = new int[this.entryCount];
        this.rows = new SearchRow[this.entryCount];
        for (int i = 0; i < this.entryCount; ++i) {
            this.offsets[i] = this.data.readShortInt();
        }
        this.start = this.data.length();
        this.written = true;
        this.writtenData = true;
    }

    @Override
    int addRowTry(SearchRow row) {
        int x = this.addRow(row, true);
        this.memoryChange();
        return x;
    }

    private int addRow(SearchRow row, boolean tryOnly) {
        int last;
        int rowLength = this.index.getRowSize(this.data, row, this.onlyPosition);
        int pageSize = this.index.getPageStore().getPageSize();
        int n = last = this.entryCount == 0 ? pageSize : this.offsets[this.entryCount - 1];
        if (last - rowLength < this.start + 2) {
            if (tryOnly && this.entryCount > 1) {
                int x = this.find(row, false, true, true);
                if (this.entryCount < 5) {
                    return this.entryCount / 2;
                }
                int third = this.entryCount / 3;
                return x < third ? third : (x >= 2 * third ? 2 * third : x);
            }
            this.readAllRows();
            this.writtenData = false;
            this.onlyPosition = true;
            int o = pageSize;
            for (int i = 0; i < this.entryCount; ++i) {
                this.offsets[i] = o -= this.index.getRowSize(this.data, this.getRow(i), true);
            }
            last = this.entryCount == 0 ? pageSize : this.offsets[this.entryCount - 1];
            if (last - (rowLength = this.index.getRowSize(this.data, row, true)) < this.start + 2) {
                throw DbException.throwInternalError();
            }
        }
        this.index.getPageStore().logUndo(this, this.data);
        if (!this.optimizeUpdate) {
            this.readAllRows();
        }
        this.changeCount = this.index.getPageStore().getChangeCount();
        this.written = false;
        int x = this.entryCount == 0 ? 0 : this.find(row, false, true, true);
        this.start += 2;
        int offset = (x == 0 ? pageSize : this.offsets[x - 1]) - rowLength;
        if (this.optimizeUpdate && this.writtenData) {
            if (this.entryCount > 0) {
                byte[] d = this.data.getBytes();
                int dataStart = this.offsets[this.entryCount - 1];
                System.arraycopy(d, dataStart, d, dataStart - rowLength, offset - dataStart + rowLength);
            }
            this.index.writeRow(this.data, offset, row, this.onlyPosition);
        }
        this.offsets = Page.insert(this.offsets, this.entryCount, x, offset);
        Page.add(this.offsets, x + 1, this.entryCount + 1, -rowLength);
        this.rows = Page.insert(this.rows, this.entryCount, x, row);
        ++this.entryCount;
        this.index.getPageStore().update(this);
        return -1;
    }

    private void removeRow(int at) {
        if (!this.optimizeUpdate) {
            this.readAllRows();
        }
        this.index.getPageStore().logUndo(this, this.data);
        --this.entryCount;
        this.written = false;
        this.changeCount = this.index.getPageStore().getChangeCount();
        if (this.entryCount <= 0) {
            DbException.throwInternalError(Integer.toString(this.entryCount));
        }
        int startNext = at > 0 ? this.offsets[at - 1] : this.index.getPageStore().getPageSize();
        int rowLength = startNext - this.offsets[at];
        this.start -= 2;
        if (this.optimizeUpdate && this.writtenData) {
            byte[] d = this.data.getBytes();
            int dataStart = this.offsets[this.entryCount];
            System.arraycopy(d, dataStart, d, dataStart + rowLength, this.offsets[at] - dataStart);
            Arrays.fill(d, dataStart, dataStart + rowLength, (byte)0);
        }
        this.offsets = Page.remove(this.offsets, this.entryCount + 1, at);
        Page.add(this.offsets, at, this.entryCount, rowLength);
        this.rows = Page.remove(this.rows, this.entryCount + 1, at);
    }

    int getEntryCount() {
        return this.entryCount;
    }

    @Override
    PageBtree split(int splitPoint) {
        int newPageId = this.index.getPageStore().allocatePage();
        PageBtreeLeaf p2 = PageBtreeLeaf.create(this.index, newPageId, this.parentPageId);
        while (splitPoint < this.entryCount) {
            p2.addRow(this.getRow(splitPoint), false);
            this.removeRow(splitPoint);
        }
        this.memoryChange();
        p2.memoryChange();
        return p2;
    }

    @Override
    PageBtreeLeaf getFirstLeaf() {
        return this;
    }

    @Override
    PageBtreeLeaf getLastLeaf() {
        return this;
    }

    @Override
    SearchRow remove(SearchRow row) {
        int at = this.find(row, false, false, true);
        SearchRow delete = this.getRow(at);
        if (this.index.compareRows(row, delete) != 0 || delete.getKey() != row.getKey()) {
            throw DbException.get(90112, this.index.getSQL(new StringBuilder(), false).append(": ").append(row).toString());
        }
        this.index.getPageStore().logUndo(this, this.data);
        if (this.entryCount == 1) {
            return row;
        }
        this.removeRow(at);
        this.memoryChange();
        this.index.getPageStore().update(this);
        if (at == this.entryCount) {
            return this.getRow(at - 1);
        }
        return null;
    }

    @Override
    void freeRecursive() {
        this.index.getPageStore().logUndo(this, this.data);
        this.index.getPageStore().free(this.getPos());
    }

    @Override
    int getRowCount() {
        return this.entryCount;
    }

    @Override
    void setRowCountStored(int rowCount) {
    }

    @Override
    public void write() {
        this.writeData();
        this.index.getPageStore().writePage(this.getPos(), this.data);
    }

    private void writeHead() {
        this.data.reset();
        this.data.writeByte((byte)(4 | (this.onlyPosition ? 0 : 16)));
        this.data.writeShortInt(0);
        this.data.writeInt(this.parentPageId);
        this.data.writeVarInt(this.index.getId());
        this.data.writeShortInt(this.entryCount);
    }

    private void writeData() {
        int i;
        if (this.written) {
            return;
        }
        if (!this.optimizeUpdate) {
            this.readAllRows();
        }
        this.writeHead();
        for (i = 0; i < this.entryCount; ++i) {
            this.data.writeShortInt(this.offsets[i]);
        }
        if (!this.writtenData || !this.optimizeUpdate) {
            for (i = 0; i < this.entryCount; ++i) {
                this.index.writeRow(this.data, this.offsets[i], this.rows[i], this.onlyPosition);
            }
            this.writtenData = true;
        }
        this.written = true;
        this.memoryChange();
    }

    @Override
    void find(PageBtreeCursor cursor, SearchRow first, boolean bigger) {
        int i = this.find(first, bigger, false, false);
        if (i > this.entryCount) {
            if (this.parentPageId == 0) {
                return;
            }
            PageBtreeNode next = (PageBtreeNode)this.index.getPage(this.parentPageId);
            next.find(cursor, first, bigger);
            return;
        }
        cursor.setCurrent(this, i);
    }

    @Override
    void last(PageBtreeCursor cursor) {
        cursor.setCurrent(this, this.entryCount - 1);
    }

    @Override
    void remapChildren() {
    }

    void nextPage(PageBtreeCursor cursor) {
        if (this.parentPageId == 0) {
            cursor.setCurrent(null, 0);
            return;
        }
        PageBtreeNode next = (PageBtreeNode)this.index.getPage(this.parentPageId);
        next.nextPage(cursor, this.getPos());
    }

    void previousPage(PageBtreeCursor cursor) {
        if (this.parentPageId == 0) {
            cursor.setCurrent(null, 0);
            return;
        }
        PageBtreeNode next = (PageBtreeNode)this.index.getPage(this.parentPageId);
        next.previousPage(cursor, this.getPos());
    }

    public String toString() {
        return "page[" + this.getPos() + "] b-tree leaf table:" + this.index.getId() + " entries:" + this.entryCount;
    }

    @Override
    public void moveTo(Session session, int newPos) {
        PageStore store = this.index.getPageStore();
        this.readAllRows();
        PageBtreeLeaf p2 = PageBtreeLeaf.create(this.index, newPos, this.parentPageId);
        store.logUndo(this, this.data);
        store.logUndo(p2, null);
        p2.rows = this.rows;
        p2.entryCount = this.entryCount;
        p2.offsets = this.offsets;
        p2.onlyPosition = this.onlyPosition;
        p2.parentPageId = this.parentPageId;
        p2.start = this.start;
        store.update(p2);
        if (this.parentPageId == 0) {
            this.index.setRootPageId(session, newPos);
        } else {
            PageBtreeNode p = (PageBtreeNode)store.getPage(this.parentPageId);
            p.moveChild(this.getPos(), newPos);
        }
        store.free(this.getPos());
    }

    @Override
    protected void memoryChange() {
        if (!PageBtreeIndex.isMemoryChangeRequired()) {
            return;
        }
        int memory = 184 + this.index.getPageStore().getPageSize();
        if (this.rows != null) {
            memory += this.getEntryCount() * 12;
            for (int i = 0; i < this.entryCount; ++i) {
                SearchRow r = this.rows[i];
                if (r == null) continue;
                memory += r.getMemory();
            }
        }
        this.index.memoryChange(memory >> 2);
    }
}

