/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.jdbc;

import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.gridgain.internal.h2.jdbc.JdbcConnection;
import org.gridgain.internal.h2.jdbc.JdbcResultSet;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.message.TraceObject;
import org.gridgain.internal.h2.result.SimpleResult;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueArray;
import org.gridgain.internal.h2.value.ValueLong;
import org.gridgain.internal.h2.value.ValueNull;

public class JdbcArray
extends TraceObject
implements Array {
    private Value value;
    private final JdbcConnection conn;

    public JdbcArray(JdbcConnection conn, Value value, int id) {
        this.setTrace(conn.getSession().getTrace(), 16, id);
        this.conn = conn;
        this.value = value.convertTo(17);
    }

    @Override
    public Object getArray() throws SQLException {
        try {
            this.debugCodeCall("getArray");
            this.checkClosed();
            return this.get();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getArray(" + JdbcArray.quoteMap(map) + ");");
            }
            JdbcConnection.checkMap(map);
            this.checkClosed();
            return this.get();
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getArray(" + index + ", " + count + ");");
            }
            this.checkClosed();
            return this.get(index, count);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getArray(" + index + ", " + count + ", " + JdbcArray.quoteMap(map) + ");");
            }
            this.checkClosed();
            JdbcConnection.checkMap(map);
            return this.get(index, count);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public int getBaseType() throws SQLException {
        try {
            this.debugCodeCall("getBaseType");
            this.checkClosed();
            return 0;
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        try {
            this.debugCodeCall("getBaseTypeName");
            this.checkClosed();
            return "NULL";
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        try {
            this.debugCodeCall("getResultSet");
            this.checkClosed();
            return this.getResultSetImpl(1L, Integer.MAX_VALUE);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getResultSet(" + JdbcArray.quoteMap(map) + ");");
            }
            this.checkClosed();
            JdbcConnection.checkMap(map);
            return this.getResultSetImpl(1L, Integer.MAX_VALUE);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getResultSet(" + index + ", " + count + ");");
            }
            this.checkClosed();
            return this.getResultSetImpl(index, count);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("getResultSet(" + index + ", " + count + ", " + JdbcArray.quoteMap(map) + ");");
            }
            this.checkClosed();
            JdbcConnection.checkMap(map);
            return this.getResultSetImpl(index, count);
        }
        catch (Exception e) {
            throw this.logAndConvert(e);
        }
    }

    @Override
    public void free() {
        this.debugCodeCall("free");
        this.value = null;
    }

    private ResultSet getResultSetImpl(long index, int count) {
        int id = JdbcArray.getNextId(4);
        SimpleResult rs = new SimpleResult();
        rs.addColumn("INDEX", "INDEX", TypeInfo.TYPE_LONG);
        rs.addColumn("VALUE", "VALUE", TypeInfo.TYPE_NULL);
        if (this.value != ValueNull.INSTANCE) {
            Value[] values = ((ValueArray)this.value).getList();
            count = JdbcArray.checkRange(index, count, values.length);
            int i = (int)index;
            while ((long)i < index + (long)count) {
                rs.addRow(ValueLong.get(i), values[i - 1]);
                ++i;
            }
        }
        return new JdbcResultSet(this.conn, null, null, rs, id, false, true, false);
    }

    private void checkClosed() {
        this.conn.checkClosed();
        if (this.value == null) {
            throw DbException.get(90007);
        }
    }

    private Object[] get() {
        return (Object[])this.value.getObject();
    }

    private Object[] get(long index, int count) {
        if (this.value == ValueNull.INSTANCE) {
            return null;
        }
        Value[] values = ((ValueArray)this.value).getList();
        count = JdbcArray.checkRange(index, count, values.length);
        Object[] a = new Object[count];
        int i = 0;
        int j = (int)index - 1;
        while (i < count) {
            a[i] = values[j].getObject();
            ++i;
            ++j;
        }
        return a;
    }

    private static int checkRange(long index, int count, int len) {
        if (index < 1L || index > (long)len) {
            throw DbException.getInvalidValueException("index (1.." + len + ')', index);
        }
        int rem = len - (int)index + 1;
        if (count < 0) {
            throw DbException.getInvalidValueException("count (0.." + rem + ')', count);
        }
        return Math.min(rem, count);
    }

    public String toString() {
        return this.value == null ? "null" : this.getTraceObjectName() + ": " + this.value.getTraceSQL();
    }
}

