/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.mvstore;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.concurrent.atomic.AtomicLong;
import org.gridgain.internal.h2.mvstore.DataUtils;
import org.gridgain.internal.h2.mvstore.FreeSpaceBitSet;
import org.gridgain.internal.h2.mvstore.cache.FilePathCache;
import org.gridgain.internal.h2.store.fs.FilePath;
import org.gridgain.internal.h2.store.fs.FilePathDisk;
import org.gridgain.internal.h2.store.fs.FilePathEncrypt;
import org.gridgain.internal.h2.store.fs.FilePathNio;

public class FileStore {
    protected final AtomicLong readCount = new AtomicLong();
    protected final AtomicLong readBytes = new AtomicLong();
    protected final AtomicLong writeCount = new AtomicLong();
    protected final AtomicLong writeBytes = new AtomicLong();
    protected final FreeSpaceBitSet freeSpace = new FreeSpaceBitSet(2, 4096);
    private String fileName;
    private boolean readOnly;
    protected long fileSize;
    private FileChannel file;
    private FileChannel encryptedFile;
    private FileLock fileLock;

    public String toString() {
        return this.fileName;
    }

    public ByteBuffer readFully(long pos, int len) {
        ByteBuffer dst = ByteBuffer.allocate(len);
        DataUtils.readFully(this.file, pos, dst);
        this.readCount.incrementAndGet();
        this.readBytes.addAndGet(len);
        return dst;
    }

    public void writeFully(long pos, ByteBuffer src) {
        int len = src.remaining();
        this.fileSize = Math.max(this.fileSize, pos + (long)len);
        DataUtils.writeFully(this.file, pos, src);
        this.writeCount.incrementAndGet();
        this.writeBytes.addAndGet(len);
    }

    public void open(String fileName, boolean readOnly, char[] encryptionKey) {
        if (this.file != null) {
            return;
        }
        FilePathCache.INSTANCE.getScheme();
        FilePath p = FilePath.get(fileName);
        if (p instanceof FilePathDisk && !fileName.startsWith(p.getScheme() + ":")) {
            FilePathNio.class.getName();
            fileName = "nio:" + fileName;
        }
        this.fileName = fileName;
        FilePath f = FilePath.get(fileName);
        FilePath parent = f.getParent();
        if (parent != null && !parent.exists()) {
            throw DataUtils.newIllegalArgumentException("Directory does not exist: {0}", parent);
        }
        if (f.exists() && !f.canWrite()) {
            readOnly = true;
        }
        this.readOnly = readOnly;
        try {
            this.file = f.open(readOnly ? "r" : "rw");
            if (encryptionKey != null) {
                byte[] key = FilePathEncrypt.getPasswordBytes(encryptionKey);
                this.encryptedFile = this.file;
                this.file = new FilePathEncrypt.FileEncrypt(fileName, key, this.file);
            }
            try {
                this.fileLock = readOnly ? this.file.tryLock(0L, Long.MAX_VALUE, true) : this.file.tryLock();
            }
            catch (OverlappingFileLockException e) {
                throw DataUtils.newIllegalStateException(7, "The file is locked: {0}", fileName, e);
            }
            if (this.fileLock == null) {
                try {
                    this.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw DataUtils.newIllegalStateException(7, "The file is locked: {0}", fileName);
            }
            this.fileSize = this.file.size();
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw DataUtils.newIllegalStateException(1, "Could not open file {0}", fileName, e);
        }
    }

    public void close() {
        try {
            if (this.file != null && this.file.isOpen()) {
                if (this.fileLock != null) {
                    this.fileLock.release();
                }
                this.file.close();
            }
        }
        catch (Exception e) {
            throw DataUtils.newIllegalStateException(2, "Closing failed for file {0}", this.fileName, e);
        }
        finally {
            this.fileLock = null;
            this.file = null;
        }
    }

    public void sync() {
        if (this.file != null) {
            try {
                this.file.force(true);
            }
            catch (IOException e) {
                throw DataUtils.newIllegalStateException(2, "Could not sync file {0}", this.fileName, e);
            }
        }
    }

    public long size() {
        return this.fileSize;
    }

    public void truncate(long size) {
        int attemptCount = 0;
        while (true) {
            try {
                this.writeCount.incrementAndGet();
                this.file.truncate(size);
                this.fileSize = Math.min(this.fileSize, size);
                return;
            }
            catch (IOException e) {
                if (++attemptCount == 10) {
                    throw DataUtils.newIllegalStateException(2, "Could not truncate file {0} to size {1}", this.fileName, size, e);
                }
                System.gc();
                Thread.yield();
                continue;
            }
            break;
        }
    }

    public FileChannel getFile() {
        return this.file;
    }

    public FileChannel getEncryptedFile() {
        return this.encryptedFile;
    }

    public long getWriteCount() {
        return this.writeCount.get();
    }

    public long getWriteBytes() {
        return this.writeBytes.get();
    }

    public long getReadCount() {
        return this.readCount.get();
    }

    public long getReadBytes() {
        return this.readBytes.get();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public int getDefaultRetentionTime() {
        return 45000;
    }

    public void markUsed(long pos, int length) {
        this.freeSpace.markUsed(pos, length);
    }

    public long allocate(int length) {
        return this.freeSpace.allocate(length);
    }

    public long predictAllocation(int length) {
        return this.freeSpace.predictAllocation(length);
    }

    public void free(long pos, int length) {
        this.freeSpace.free(pos, length);
    }

    public int getFillRate() {
        return this.freeSpace.getFillRate();
    }

    long getFirstFree() {
        return this.freeSpace.getFirstFree();
    }

    long getFileLengthInUse() {
        return this.freeSpace.getLastFree();
    }

    public void clear() {
        this.freeSpace.clear();
    }

    public String getFileName() {
        return this.fileName;
    }
}

