/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.mvstore;

import org.gridgain.internal.h2.mvstore.Page;

public final class RootReference {
    public final Page root;
    public final long version;
    final boolean lockedForUpdate;
    public volatile RootReference previous;
    final long updateCounter;
    final long updateAttemptCounter;
    final byte appendCounter;

    RootReference(Page root, long version) {
        this.root = root;
        this.version = version;
        this.previous = null;
        this.updateCounter = 1L;
        this.updateAttemptCounter = 1L;
        this.lockedForUpdate = false;
        this.appendCounter = 0;
    }

    RootReference(RootReference r, Page root, long updateAttemptCounter) {
        this.root = root;
        this.version = r.version;
        this.previous = r.previous;
        this.updateCounter = r.updateCounter + 1L;
        this.updateAttemptCounter = r.updateAttemptCounter + updateAttemptCounter;
        this.lockedForUpdate = false;
        this.appendCounter = r.appendCounter;
    }

    RootReference(RootReference r, int attempt) {
        this.root = r.root;
        this.version = r.version;
        this.previous = r.previous;
        this.updateCounter = r.updateCounter + 1L;
        this.updateAttemptCounter = r.updateAttemptCounter + (long)attempt;
        this.lockedForUpdate = true;
        this.appendCounter = r.appendCounter;
    }

    RootReference(RootReference r, Page root, int appendCounter, boolean lockedForUpdate) {
        this.root = root;
        this.version = r.version;
        this.previous = r.previous;
        this.updateCounter = r.updateCounter;
        this.updateAttemptCounter = r.updateAttemptCounter;
        this.lockedForUpdate = lockedForUpdate;
        this.appendCounter = (byte)appendCounter;
    }

    RootReference(RootReference r, long version, int attempt) {
        RootReference tmp;
        RootReference previous = r;
        while ((tmp = previous.previous) != null && tmp.root == r.root) {
            previous = tmp;
        }
        this.root = r.root;
        this.version = version;
        this.previous = previous;
        this.updateCounter = r.updateCounter + 1L;
        this.updateAttemptCounter = r.updateAttemptCounter + (long)attempt;
        this.lockedForUpdate = r.lockedForUpdate;
        this.appendCounter = r.appendCounter;
    }

    int getAppendCounter() {
        return this.appendCounter & 0xFF;
    }

    public long getTotalCount() {
        return this.root.getTotalCount() + (long)this.getAppendCounter();
    }

    public String toString() {
        return "RootReference(" + System.identityHashCode(this.root) + "," + this.version + "," + this.lockedForUpdate + ")";
    }
}

