/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.mvstore.db;

import java.util.Iterator;
import java.util.List;
import org.gridgain.internal.h2.command.dml.AllColumnsForPlan;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.index.BaseIndex;
import org.gridgain.internal.h2.index.Cursor;
import org.gridgain.internal.h2.index.IndexType;
import org.gridgain.internal.h2.index.SpatialIndex;
import org.gridgain.internal.h2.index.SpatialTreeIndex;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.mvstore.MVMap;
import org.gridgain.internal.h2.mvstore.Page;
import org.gridgain.internal.h2.mvstore.db.MVIndex;
import org.gridgain.internal.h2.mvstore.db.MVTable;
import org.gridgain.internal.h2.mvstore.db.ValueDataType;
import org.gridgain.internal.h2.mvstore.rtree.MVRTreeMap;
import org.gridgain.internal.h2.mvstore.rtree.SpatialKey;
import org.gridgain.internal.h2.mvstore.tx.Transaction;
import org.gridgain.internal.h2.mvstore.tx.TransactionMap;
import org.gridgain.internal.h2.mvstore.tx.VersionedValueType;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.SearchRow;
import org.gridgain.internal.h2.result.SortOrder;
import org.gridgain.internal.h2.table.IndexColumn;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueGeometry;
import org.gridgain.internal.h2.value.ValueLong;
import org.gridgain.internal.h2.value.ValueNull;
import org.gridgain.internal.h2.value.VersionedValue;

public class MVSpatialIndex
extends BaseIndex
implements SpatialIndex,
MVIndex {
    final MVTable mvTable;
    private final TransactionMap<SpatialKey, Value> dataMap;
    private final MVRTreeMap<VersionedValue> spatialMap;

    public MVSpatialIndex(Database db, MVTable table, int id, String indexName, IndexColumn[] columns, IndexType indexType) {
        super(table, id, indexName, columns, indexType);
        if (columns.length != 1) {
            throw DbException.getUnsupportedException("Can only index one column");
        }
        IndexColumn col = columns[0];
        if ((col.sortType & 1) != 0) {
            throw DbException.getUnsupportedException("Cannot index in descending order");
        }
        if ((col.sortType & 2) != 0) {
            throw DbException.getUnsupportedException("Nulls first is not supported");
        }
        if ((col.sortType & 4) != 0) {
            throw DbException.getUnsupportedException("Nulls last is not supported");
        }
        if (col.column.getType().getValueType() != 22) {
            throw DbException.getUnsupportedException("Spatial index on non-geometry column, " + col.column.getCreateSQL());
        }
        this.mvTable = table;
        if (!this.database.isStarting()) {
            MVSpatialIndex.checkIndexColumnTypes(columns);
        }
        String mapName = "index." + this.getId();
        ValueDataType vt = new ValueDataType(db, null);
        VersionedValueType valueType = new VersionedValueType(vt);
        MVMap.BasicBuilder mapBuilder = new MVRTreeMap.Builder().valueType(valueType);
        this.spatialMap = (MVRTreeMap)db.getStore().getMvStore().openMap(mapName, mapBuilder);
        Transaction t = this.mvTable.getTransactionBegin();
        this.dataMap = t.openMap(this.spatialMap);
        this.dataMap.map.setVolatile(!table.isPersistData() || !indexType.isPersistent());
        t.commit();
    }

    @Override
    public void addRowsToBuffer(List<Row> rows, String bufferName) {
        throw DbException.throwInternalError();
    }

    @Override
    public void addBufferedRows(List<String> bufferNames) {
        throw DbException.throwInternalError();
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void add(Session session, Row row) {
        SpatialKey k;
        Iterator<SpatialKey> it;
        MVRTreeMap.RTreeCursor cursor;
        TransactionMap<SpatialKey, Value> map = this.getMap(session);
        SpatialKey key = this.getKey(row);
        if (key.isNull()) {
            return;
        }
        if (this.indexType.isUnique()) {
            cursor = this.spatialMap.findContainedKeys(key);
            it = map.wrapIterator(cursor, false);
            while (it.hasNext()) {
                k = it.next();
                if (!k.equalsIgnoringId(key)) continue;
                throw this.getDuplicateKeyException(key.toString());
            }
        }
        try {
            map.put(key, ValueLong.get(0L));
        }
        catch (IllegalStateException e) {
            throw this.mvTable.convertException(e);
        }
        if (this.indexType.isUnique()) {
            cursor = this.spatialMap.findContainedKeys(key);
            it = map.wrapIterator(cursor, true);
            while (it.hasNext()) {
                k = it.next();
                if (!k.equalsIgnoringId(key) || map.isSameTransaction(k)) continue;
                map.remove(key);
                if (map.get(k) != null) {
                    throw this.getDuplicateKeyException(k.toString());
                }
                throw DbException.get(90131, this.table.getName());
            }
        }
    }

    @Override
    public void remove(Session session, Row row) {
        SpatialKey key = this.getKey(row);
        if (key.isNull()) {
            return;
        }
        TransactionMap<SpatialKey, Value> map = this.getMap(session);
        try {
            Value old = map.remove(key);
            if (old == null) {
                StringBuilder builder = new StringBuilder();
                this.getSQL(builder, false).append(": ").append(row.getKey());
                throw DbException.get(90112, builder.toString());
            }
        }
        catch (IllegalStateException e) {
            throw this.mvTable.convertException(e);
        }
    }

    @Override
    public Cursor find(TableFilter filter, SearchRow first, SearchRow last) {
        return this.find(filter.getSession());
    }

    @Override
    public Cursor find(Session session, SearchRow first, SearchRow last) {
        return this.find(session);
    }

    private Cursor find(Session session) {
        Iterator<Object> cursor = this.spatialMap.keyIterator(null);
        TransactionMap<SpatialKey, Value> map = this.getMap(session);
        Iterator<Object> it = map.wrapIterator(cursor, false);
        return new MVStoreCursor(session, it, this.mvTable);
    }

    @Override
    public Cursor findByGeometry(TableFilter filter, SearchRow first, SearchRow last, SearchRow intersection) {
        Session session = filter.getSession();
        if (intersection == null) {
            return this.find(session, first, last);
        }
        MVRTreeMap.RTreeCursor cursor = this.spatialMap.findIntersectingKeys(this.getKey(intersection));
        TransactionMap<SpatialKey, Value> map = this.getMap(session);
        Iterator<SpatialKey> it = map.wrapIterator(cursor, false);
        return new MVStoreCursor(session, it, this.mvTable);
    }

    public Value getBounds(Session session) {
        FindBoundsCursor cursor = new FindBoundsCursor(this.spatialMap.getRootPage(), new SpatialKey(0L, new float[0]), session, this.getMap(session), this.columnIds[0]);
        while (cursor.hasNext()) {
            cursor.next();
        }
        return cursor.getBounds();
    }

    public Value getEstimatedBounds(Session session) {
        Page p = this.spatialMap.getRootPage();
        int count = p.getKeyCount();
        if (count > 0) {
            SpatialKey key = (SpatialKey)p.getKey(0);
            float bminxf = key.min(0);
            float bmaxxf = key.max(0);
            float bminyf = key.min(1);
            float bmaxyf = key.max(1);
            for (int i = 1; i < count; ++i) {
                key = (SpatialKey)p.getKey(i);
                float minxf = key.min(0);
                float maxxf = key.max(0);
                float minyf = key.min(1);
                float maxyf = key.max(1);
                if (minxf < bminxf) {
                    bminxf = minxf;
                }
                if (maxxf > bmaxxf) {
                    bmaxxf = maxxf;
                }
                if (minyf < bminyf) {
                    bminyf = minyf;
                }
                if (!(maxyf > bmaxyf)) continue;
                bmaxyf = maxyf;
            }
            return ValueGeometry.fromEnvelope(new double[]{bminxf, bmaxxf, bminyf, bmaxyf});
        }
        return ValueNull.INSTANCE;
    }

    private SpatialKey getKey(SearchRow row) {
        double[] env;
        Value v = row.getValue(this.columnIds[0]);
        if (v == ValueNull.INSTANCE || (env = ((ValueGeometry)v.convertTo(22)).getEnvelopeNoCopy()) == null) {
            return new SpatialKey(row.getKey(), new float[0]);
        }
        return new SpatialKey(row.getKey(), (float)env[0], (float)env[1], (float)env[2], (float)env[3]);
    }

    @Override
    public MVTable getTable() {
        return this.mvTable;
    }

    @Override
    public double getCost(Session session, int[] masks, TableFilter[] filters, int filter, SortOrder sortOrder, AllColumnsForPlan allColumnsSet) {
        return SpatialTreeIndex.getCostRangeIndex(masks, this.columns);
    }

    @Override
    public void remove(Session session) {
        TransactionMap<SpatialKey, Value> map = this.getMap(session);
        if (!map.isClosed()) {
            Transaction t = session.getTransaction();
            t.removeMap(map);
        }
    }

    @Override
    public void truncate(Session session) {
        TransactionMap<SpatialKey, Value> map = this.getMap(session);
        map.clear();
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean first) {
        if (!first) {
            throw DbException.throwInternalError("Spatial Index can only be fetch in ascending order");
        }
        return this.find(session);
    }

    @Override
    public boolean needRebuild() {
        try {
            return this.dataMap.sizeAsLongMax() == 0L;
        }
        catch (IllegalStateException e) {
            throw DbException.get(90007, e, new String[0]);
        }
    }

    @Override
    public long getRowCount(Session session) {
        TransactionMap<SpatialKey, Value> map = this.getMap(session);
        return map.sizeAsLong();
    }

    @Override
    public long getRowCountApproximation(Session ses) {
        try {
            return this.dataMap.sizeAsLongMax();
        }
        catch (IllegalStateException e) {
            throw DbException.get(90007, e, new String[0]);
        }
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public void checkRename() {
    }

    private TransactionMap<SpatialKey, Value> getMap(Session session) {
        if (session == null) {
            return this.dataMap;
        }
        Transaction t = session.getTransaction();
        return this.dataMap.getInstance(t);
    }

    private final class FindBoundsCursor
    extends MVRTreeMap.RTreeCursor {
        private final Session session;
        private final TransactionMap<SpatialKey, Value> map;
        private final int columnId;
        private boolean hasBounds;
        private float bminxf;
        private float bmaxxf;
        private float bminyf;
        private float bmaxyf;
        private double bminxd;
        private double bmaxxd;
        private double bminyd;
        private double bmaxyd;

        FindBoundsCursor(Page root, SpatialKey filter, Session session, TransactionMap<SpatialKey, Value> map, int columnId) {
            super(root, filter);
            this.session = session;
            this.map = map;
            this.columnId = columnId;
        }

        @Override
        protected boolean check(boolean leaf, SpatialKey key, SpatialKey test) {
            float minxf = key.min(0);
            float maxxf = key.max(0);
            float minyf = key.min(1);
            float maxyf = key.max(1);
            if (leaf) {
                if (this.hasBounds) {
                    if ((minxf <= this.bminxf || maxxf >= this.bmaxxf || minyf <= this.bminyf || maxyf >= this.bmaxyf) && this.map.containsKey(key)) {
                        double[] env = ((ValueGeometry)MVSpatialIndex.this.mvTable.getRow(this.session, key.getId()).getValue(this.columnId)).getEnvelopeNoCopy();
                        double minxd = env[0];
                        double maxxd = env[1];
                        double minyd = env[2];
                        double maxyd = env[3];
                        if (minxd < this.bminxd) {
                            this.bminxf = minxf;
                            this.bminxd = minxd;
                        }
                        if (maxxd > this.bmaxxd) {
                            this.bmaxxf = maxxf;
                            this.bmaxxd = maxxd;
                        }
                        if (minyd < this.bminyd) {
                            this.bminyf = minyf;
                            this.bminyd = minyd;
                        }
                        if (maxyd > this.bmaxyd) {
                            this.bmaxyf = maxyf;
                            this.bmaxyd = maxyd;
                        }
                    }
                } else if (this.map.containsKey(key)) {
                    this.hasBounds = true;
                    double[] env = ((ValueGeometry)MVSpatialIndex.this.mvTable.getRow(this.session, key.getId()).getValue(this.columnId)).getEnvelopeNoCopy();
                    this.bminxf = minxf;
                    this.bminxd = env[0];
                    this.bmaxxf = maxxf;
                    this.bmaxxd = env[1];
                    this.bminyf = minyf;
                    this.bminyd = env[2];
                    this.bmaxyf = maxyf;
                    this.bmaxyd = env[3];
                }
            } else if (this.hasBounds) {
                if (minxf <= this.bminxf || maxxf >= this.bmaxxf || minyf <= this.bminyf || maxyf >= this.bmaxyf) {
                    return true;
                }
            } else {
                return true;
            }
            return false;
        }

        Value getBounds() {
            return this.hasBounds ? ValueGeometry.fromEnvelope(new double[]{this.bminxd, this.bmaxxd, this.bminyd, this.bmaxyd}) : ValueNull.INSTANCE;
        }
    }

    public static class MVStoreCursor
    implements Cursor {
        private final Session session;
        private final Iterator<SpatialKey> it;
        private final MVTable mvTable;
        private SpatialKey current;
        private SearchRow searchRow;
        private Row row;

        public MVStoreCursor(Session session, Iterator<SpatialKey> it, MVTable mvTable) {
            this.session = session;
            this.it = it;
            this.mvTable = mvTable;
        }

        @Override
        public Row get() {
            SearchRow r;
            if (this.row == null && (r = this.getSearchRow()) != null) {
                this.row = this.mvTable.getRow(this.session, r.getKey());
            }
            return this.row;
        }

        @Override
        public SearchRow getSearchRow() {
            if (this.searchRow == null && this.current != null) {
                this.searchRow = this.mvTable.getTemplateRow();
                this.searchRow.setKey(this.current.getId());
            }
            return this.searchRow;
        }

        public SpatialKey getKey() {
            return this.current;
        }

        @Override
        public boolean next() {
            this.current = this.it.hasNext() ? this.it.next() : null;
            this.searchRow = null;
            this.row = null;
            return this.current != null;
        }

        @Override
        public boolean previous() {
            throw DbException.getUnsupportedException("previous");
        }
    }
}

