/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.mvstore.db;

import java.io.IOException;
import java.lang.ref.Reference;
import java.util.Collection;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.mvstore.MVStore;
import org.gridgain.internal.h2.mvstore.db.MVPlainTempResult;
import org.gridgain.internal.h2.mvstore.db.MVSortedTempResult;
import org.gridgain.internal.h2.mvstore.db.MVTableEngine;
import org.gridgain.internal.h2.result.ResultExternal;
import org.gridgain.internal.h2.result.SortOrder;
import org.gridgain.internal.h2.store.fs.FileUtils;
import org.gridgain.internal.h2.util.TempFileDeleter;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;

public abstract class MVTempResult
implements ResultExternal {
    final MVStore store;
    final Expression[] expressions;
    final int visibleColumnCount;
    final boolean hasEnum;
    int rowCount;
    final MVTempResult parent;
    int childCount;
    boolean closed;
    private final TempFileDeleter tempFileDeleter;
    private final CloseImpl closeable;
    private final Reference<?> fileRef;

    public static ResultExternal of(Database database, Expression[] expressions, boolean distinct, int[] distinctIndexes, int visibleColumnCount, SortOrder sort) {
        return distinct || distinctIndexes != null || sort != null ? new MVSortedTempResult(database, expressions, distinct, distinctIndexes, visibleColumnCount, sort) : new MVPlainTempResult(database, expressions, visibleColumnCount);
    }

    MVTempResult(MVTempResult parent) {
        this.parent = parent;
        this.store = parent.store;
        this.expressions = parent.expressions;
        this.visibleColumnCount = parent.visibleColumnCount;
        this.hasEnum = parent.hasEnum;
        this.tempFileDeleter = null;
        this.closeable = null;
        this.fileRef = null;
    }

    MVTempResult(Database database, Expression[] expressions, int visibleColumnCount) {
        try {
            String fileName = FileUtils.createTempFile("h2tmp", ".temp.db", true);
            MVStore.Builder builder = new MVStore.Builder().fileName(fileName).cacheSize(0).autoCommitDisabled();
            byte[] key = database.getFileEncryptionKey();
            if (key != null) {
                builder.encryptionKey(MVTableEngine.decodePassword(key));
            }
            this.store = builder.open();
            this.expressions = expressions;
            this.visibleColumnCount = visibleColumnCount;
            boolean hasEnum = false;
            for (Expression e : expressions) {
                if (e.getType().getValueType() != 25) continue;
                hasEnum = true;
                break;
            }
            this.hasEnum = hasEnum;
            this.tempFileDeleter = database.getTempFileDeleter();
            this.closeable = new CloseImpl(this.store, fileName);
            this.fileRef = this.tempFileDeleter.addFile(this.closeable, this);
        }
        catch (IOException e) {
            throw DbException.convert(e);
        }
        this.parent = null;
    }

    @Override
    public int addRows(Collection<Value[]> rows) {
        for (Value[] row : rows) {
            this.addRow(row);
        }
        return this.rowCount;
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.parent != null) {
            this.parent.closeChild();
        } else if (this.childCount == 0) {
            this.delete();
        }
    }

    private synchronized void closeChild() {
        if (--this.childCount == 0 && this.closed) {
            this.delete();
        }
    }

    private void delete() {
        this.tempFileDeleter.deleteFile(this.fileRef, this.closeable);
    }

    final void fixEnum(Value[] row) {
        int l = this.expressions.length;
        for (int i = 0; i < l; ++i) {
            TypeInfo type = this.expressions[i].getType();
            if (type.getValueType() != 25) continue;
            row[i] = type.getExtTypeInfo().cast(row[i]);
        }
    }

    private static final class CloseImpl
    implements AutoCloseable {
        private final MVStore store;
        private final String fileName;

        CloseImpl(MVStore store, String fileName) {
            this.store = store;
            this.fileName = fileName;
        }

        @Override
        public void close() throws Exception {
            this.store.closeImmediately();
            FileUtils.tryDelete(this.fileName);
        }
    }
}

