/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.mvstore.tx;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.gridgain.internal.h2.mvstore.Cursor;
import org.gridgain.internal.h2.mvstore.DataUtils;
import org.gridgain.internal.h2.mvstore.MVMap;
import org.gridgain.internal.h2.mvstore.Page;
import org.gridgain.internal.h2.mvstore.RootReference;
import org.gridgain.internal.h2.mvstore.tx.Transaction;
import org.gridgain.internal.h2.mvstore.tx.TransactionStore;
import org.gridgain.internal.h2.mvstore.tx.TxDecisionMaker;
import org.gridgain.internal.h2.mvstore.tx.VersionedValueCommitted;
import org.gridgain.internal.h2.mvstore.tx.VersionedValueUncommitted;
import org.gridgain.internal.h2.mvstore.type.DataType;
import org.gridgain.internal.h2.value.VersionedValue;

public class TransactionMap<K, V>
extends AbstractMap<K, V> {
    public final MVMap<K, VersionedValue> map;
    private final Transaction transaction;

    TransactionMap(Transaction transaction, MVMap<K, VersionedValue> map) {
        this.transaction = transaction;
        this.map = map;
    }

    public TransactionMap<K, V> getInstance(Transaction transaction) {
        return new TransactionMap<K, V>(transaction, this.map);
    }

    @Override
    public final int size() {
        long size = this.sizeAsLong();
        return size > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)size;
    }

    public long sizeAsLongMax() {
        return this.map.sizeAsLong();
    }

    public long sizeAsLong() {
        long undoLogSize;
        RootReference[] undoLogRootReferences;
        RootReference mapRootReference;
        BitSet committingTransactions;
        TransactionStore store = this.transaction.store;
        do {
            committingTransactions = store.committingTransactions.get();
            mapRootReference = this.map.flushAndGetRoot();
            BitSet opentransactions = store.openTransactions.get();
            undoLogRootReferences = new RootReference[opentransactions.length()];
            undoLogSize = 0L;
            int i = opentransactions.nextSetBit(0);
            while (i >= 0) {
                MVMap<Long, Object[]> undoLog = store.undoLogs[i];
                if (undoLog != null) {
                    RootReference rootReference;
                    undoLogRootReferences[i] = rootReference = undoLog.flushAndGetRoot();
                    undoLogSize += rootReference.getTotalCount();
                }
                i = opentransactions.nextSetBit(i + 1);
            }
        } while (committingTransactions != store.committingTransactions.get() || mapRootReference != this.map.getRoot());
        Page mapRootPage = mapRootReference.root;
        long size = mapRootReference.getTotalCount();
        if (undoLogSize == 0L) {
            return size;
        }
        if (2L * undoLogSize > size) {
            Cursor cursor = new Cursor(mapRootPage, null);
            while (cursor.hasNext()) {
                int txId;
                boolean isVisible;
                Object v;
                cursor.next();
                VersionedValue currentValue = (VersionedValue)cursor.getValue();
                assert (currentValue != null);
                long operationId = currentValue.getOperationId();
                if (operationId == 0L || (v = (isVisible = (txId = TransactionStore.getTransactionId(operationId)) == this.transaction.transactionId || committingTransactions.get(txId)) ? currentValue.getCurrentValue() : currentValue.getCommittedValue()) != null) continue;
                --size;
            }
        } else {
            for (RootReference undoLogRootReference : undoLogRootReferences) {
                if (undoLogRootReference == null) continue;
                Cursor cursor = new Cursor(undoLogRootReference.root, null);
                while (cursor.hasNext()) {
                    int txId;
                    boolean isVisible;
                    Object v;
                    VersionedValue currentValue;
                    cursor.next();
                    Object[] op = (Object[])cursor.getValue();
                    if (((Integer)op[0]).intValue() != this.map.getId() || (currentValue = this.map.get(mapRootPage, op[1])) == null) continue;
                    long operationId = cursor.getKey();
                    if (currentValue.getOperationId() != operationId || (v = (isVisible = (txId = TransactionStore.getTransactionId(operationId)) == this.transaction.transactionId || committingTransactions.get(txId)) ? currentValue.getCurrentValue() : currentValue.getCommittedValue()) != null) continue;
                    --size;
                }
            }
        }
        return size;
    }

    @Override
    public V remove(Object key) {
        return this.set(key, (V)null);
    }

    @Override
    public V put(K key, V value) {
        DataUtils.checkArgument(value != null, "The value may not be null", new Object[0]);
        return this.set(key, value);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        DataUtils.checkArgument(value != null, "The value may not be null", new Object[0]);
        TxDecisionMaker.PutIfAbsentDecisionMaker decisionMaker = new TxDecisionMaker.PutIfAbsentDecisionMaker(this.map.getId(), key, value, this.transaction);
        return this.set((Object)key, decisionMaker);
    }

    public void append(K key, V value) {
        this.map.append(key, VersionedValueUncommitted.getInstance(this.transaction.log(this.map.getId(), key, null), value, null));
    }

    public V lock(K key) {
        TxDecisionMaker.LockDecisionMaker decisionMaker = new TxDecisionMaker.LockDecisionMaker(this.map.getId(), key, this.transaction);
        return this.set((Object)key, decisionMaker);
    }

    public V putCommitted(K key, V value) {
        DataUtils.checkArgument(value != null, "The value may not be null", new Object[0]);
        VersionedValue newValue = VersionedValueCommitted.getInstance(value);
        VersionedValue oldValue = this.map.put(key, newValue);
        Object result = oldValue == null ? null : oldValue.getCurrentValue();
        return (V)result;
    }

    private V set(Object key, V value) {
        TxDecisionMaker.PutDecisionMaker decisionMaker = new TxDecisionMaker.PutDecisionMaker(this.map.getId(), key, value, this.transaction);
        return this.set(key, decisionMaker);
    }

    private V set(Object key, TxDecisionMaker decisionMaker) {
        VersionedValue result;
        long sequenceNumWhenStarted;
        Transaction blockingTransaction;
        TransactionStore store = this.transaction.store;
        do {
            sequenceNumWhenStarted = store.openTransactions.get().getVersion();
            assert (this.transaction.getBlockerId() == 0);
            Object k = key;
            result = this.map.operate(k, VersionedValue.DUMMY, decisionMaker);
            MVMap.Decision decision = decisionMaker.getDecision();
            assert (decision != null);
            assert (decision != MVMap.Decision.REPEAT);
            blockingTransaction = decisionMaker.getBlockingTransaction();
            if (decision != MVMap.Decision.ABORT || blockingTransaction == null) {
                Object res = result == null ? null : result.getCurrentValue();
                return (V)res;
            }
            decisionMaker.reset();
        } while (blockingTransaction.sequenceNum > sequenceNumWhenStarted || this.transaction.waitFor(blockingTransaction, this.map, key));
        throw DataUtils.newIllegalStateException(101, "Map entry <{0}> with key <{1}> and value {2} is locked by tx {3} and can not be updated by tx {4} within allocated time interval {5} ms.", this.map.getName(), key, result, blockingTransaction.transactionId, this.transaction.transactionId, this.transaction.timeoutMillis);
    }

    public boolean tryRemove(K key) {
        return this.trySet(key, null);
    }

    public boolean tryPut(K key, V value) {
        DataUtils.checkArgument(value != null, "The value may not be null", new Object[0]);
        return this.trySet(key, value);
    }

    public boolean trySet(K key, V value) {
        try {
            this.set(key, value);
            return true;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    @Override
    public V get(Object key) {
        VersionedValue data = this.map.get(key);
        if (data == null) {
            return null;
        }
        long id = data.getOperationId();
        if (id == 0L) {
            return (V)data.getCurrentValue();
        }
        int tx = TransactionStore.getTransactionId(id);
        if (tx == this.transaction.transactionId || this.transaction.store.committingTransactions.get().get(tx)) {
            return (V)data.getCurrentValue();
        }
        return (V)data.getCommittedValue();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    public boolean isSameTransaction(K key) {
        VersionedValue data = this.map.get(key);
        if (data == null) {
            return false;
        }
        int tx = TransactionStore.getTransactionId(data.getOperationId());
        return tx == this.transaction.transactionId;
    }

    public boolean isClosed() {
        return this.map.isClosed();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return TransactionMap.this.entryIterator(null, null);
            }

            @Override
            public int size() {
                return TransactionMap.this.size();
            }

            @Override
            public boolean contains(Object o) {
                return TransactionMap.this.containsKey(o);
            }
        };
    }

    public K firstKey() {
        Iterator<Object> it = this.keyIterator(null);
        return (K)(it.hasNext() ? it.next() : null);
    }

    public K lastKey() {
        K k = this.map.lastKey();
        while (k != null && this.get(k) == null) {
            k = this.map.lowerKey(k);
        }
        return k;
    }

    public K higherKey(K key) {
        while ((key = this.map.higherKey(key)) != null && this.get(key) == null) {
        }
        return key;
    }

    public K ceilingKey(K key) {
        Iterator<K> it = this.keyIterator(key);
        return it.hasNext() ? (K)it.next() : null;
    }

    public K floorKey(K key) {
        key = this.map.floorKey(key);
        while (key != null && this.get(key) == null) {
            key = this.map.lowerKey(key);
        }
        return key;
    }

    public K lowerKey(K key) {
        while ((key = this.map.lowerKey(key)) != null && this.get(key) == null) {
        }
        return key;
    }

    public Iterator<K> keyIterator(K from) {
        return this.keyIterator(from, null, false);
    }

    public Iterator<K> keyIterator(K from, K to, boolean includeUncommitted) {
        return new KeyIterator<K>(this, from, to, includeUncommitted);
    }

    public Iterator<Map.Entry<K, V>> entryIterator(K from, K to) {
        return new EntryIterator(this, from, to);
    }

    public Iterator<K> wrapIterator(final Iterator<K> iterator, final boolean includeUncommitted) {
        return new Iterator<K>(){
            private K current;
            {
                this.fetchNext();
            }

            private void fetchNext() {
                while (iterator.hasNext()) {
                    this.current = iterator.next();
                    if (includeUncommitted) {
                        return;
                    }
                    if (!TransactionMap.this.containsKey(this.current)) continue;
                    return;
                }
                this.current = null;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public K next() {
                Object result = this.current;
                this.fetchNext();
                return result;
            }

            @Override
            public void remove() {
                throw DataUtils.newUnsupportedOperationException("Removal is not supported");
            }
        };
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public DataType getKeyType() {
        return this.map.getKeyType();
    }

    private static abstract class TMIterator<K, X>
    implements Iterator<X> {
        private final int transactionId;
        private final BitSet committingTransactions;
        private final Cursor<K, VersionedValue> cursor;
        private final boolean includeAllUncommitted;
        private X current;

        TMIterator(TransactionMap<K, ?> transactionMap, K from, K to, boolean includeAllUncommitted) {
            RootReference mapRootReference;
            BitSet committingTransactions;
            Transaction transaction = transactionMap.getTransaction();
            this.transactionId = transaction.transactionId;
            TransactionStore store = transaction.store;
            MVMap map = transactionMap.map;
            do {
                committingTransactions = store.committingTransactions.get();
                mapRootReference = map.flushAndGetRoot();
            } while (committingTransactions != store.committingTransactions.get());
            this.cursor = new Cursor(mapRootReference.root, from, to);
            this.committingTransactions = committingTransactions;
            this.includeAllUncommitted = includeAllUncommitted;
            this.fetchNext();
        }

        protected abstract X registerCurrent(K var1, VersionedValue var2);

        private void fetchNext() {
            while (this.cursor.hasNext()) {
                int tx;
                long id;
                K key = this.cursor.next();
                VersionedValue data = this.cursor.getValue();
                if (!this.includeAllUncommitted && data != null && (id = data.getOperationId()) != 0L && (tx = TransactionStore.getTransactionId(id)) != this.transactionId && !this.committingTransactions.get(tx)) {
                    Object committedValue = data.getCommittedValue();
                    VersionedValue versionedValue = data = committedValue == null ? null : VersionedValueCommitted.getInstance(committedValue);
                }
                if (data == null || data.getCurrentValue() == null && (!this.includeAllUncommitted || this.transactionId == TransactionStore.getTransactionId(data.getOperationId()))) continue;
                this.current = this.registerCurrent(key, data);
                return;
            }
            this.current = null;
        }

        @Override
        public final boolean hasNext() {
            return this.current != null;
        }

        @Override
        public final X next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            X result = this.current;
            this.fetchNext();
            return result;
        }

        @Override
        public final void remove() {
            throw DataUtils.newUnsupportedOperationException("Removal is not supported");
        }
    }

    private static final class EntryIterator<K, V>
    extends TMIterator<K, Map.Entry<K, V>> {
        public EntryIterator(TransactionMap<K, ?> transactionMap, K from, K to) {
            super(transactionMap, from, to, false);
        }

        @Override
        protected Map.Entry<K, V> registerCurrent(K key, VersionedValue data) {
            return new AbstractMap.SimpleImmutableEntry<K, Object>(key, data.getCurrentValue());
        }
    }

    private static final class KeyIterator<K>
    extends TMIterator<K, K> {
        public KeyIterator(TransactionMap<K, ?> transactionMap, K from, K to, boolean includeUncommitted) {
            super(transactionMap, from, to, includeUncommitted);
        }

        @Override
        protected K registerCurrent(K key, VersionedValue data) {
            return key;
        }
    }
}

