/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.mvstore.tx;

import java.nio.ByteBuffer;
import org.gridgain.internal.h2.mvstore.DataUtils;
import org.gridgain.internal.h2.mvstore.WriteBuffer;
import org.gridgain.internal.h2.mvstore.tx.VersionedValueCommitted;
import org.gridgain.internal.h2.mvstore.tx.VersionedValueUncommitted;
import org.gridgain.internal.h2.mvstore.type.DataType;
import org.gridgain.internal.h2.value.VersionedValue;

public class VersionedValueType
implements DataType {
    private final DataType valueType;

    public VersionedValueType(DataType valueType) {
        this.valueType = valueType;
    }

    @Override
    public int getMemory(Object obj) {
        if (obj == null) {
            return 0;
        }
        VersionedValue v = (VersionedValue)obj;
        int res = 48 + this.getValMemory(v.getCurrentValue());
        if (v.getOperationId() != 0L) {
            res += this.getValMemory(v.getCommittedValue());
        }
        return res;
    }

    private int getValMemory(Object obj) {
        return obj == null ? 0 : this.valueType.getMemory(obj);
    }

    @Override
    public int compare(Object aObj, Object bObj) {
        if (aObj == bObj) {
            return 0;
        }
        if (aObj == null) {
            return -1;
        }
        if (bObj == null) {
            return 1;
        }
        VersionedValue a = (VersionedValue)aObj;
        VersionedValue b = (VersionedValue)bObj;
        long comp = a.getOperationId() - b.getOperationId();
        if (comp == 0L) {
            return this.valueType.compare(a.getCurrentValue(), b.getCurrentValue());
        }
        return Long.signum(comp);
    }

    @Override
    public void read(ByteBuffer buff, Object[] obj, int len, boolean key) {
        if (buff.get() == 0) {
            for (int i = 0; i < len; ++i) {
                obj[i] = VersionedValueCommitted.getInstance(this.valueType.read(buff));
            }
        } else {
            for (int i = 0; i < len; ++i) {
                obj[i] = this.read(buff);
            }
        }
    }

    @Override
    public Object read(ByteBuffer buff) {
        long operationId = DataUtils.readVarLong(buff);
        if (operationId == 0L) {
            return VersionedValueCommitted.getInstance(this.valueType.read(buff));
        }
        byte flags = buff.get();
        Object value = (flags & 1) != 0 ? this.valueType.read(buff) : null;
        Object committedValue = (flags & 2) != 0 ? this.valueType.read(buff) : null;
        return VersionedValueUncommitted.getInstance(operationId, value, committedValue);
    }

    @Override
    public void write(WriteBuffer buff, Object[] obj, int len, boolean key) {
        VersionedValue v;
        int i;
        boolean fastPath = true;
        for (i = 0; i < len; ++i) {
            v = (VersionedValue)obj[i];
            if (v.getOperationId() == 0L && v.getCurrentValue() != null) continue;
            fastPath = false;
        }
        if (fastPath) {
            buff.put((byte)0);
            for (i = 0; i < len; ++i) {
                v = (VersionedValue)obj[i];
                this.valueType.write(buff, v.getCurrentValue());
            }
        } else {
            buff.put((byte)1);
            for (i = 0; i < len; ++i) {
                this.write(buff, obj[i]);
            }
        }
    }

    @Override
    public void write(WriteBuffer buff, Object obj) {
        VersionedValue v = (VersionedValue)obj;
        long operationId = v.getOperationId();
        buff.putVarLong(operationId);
        if (operationId == 0L) {
            this.valueType.write(buff, v.getCurrentValue());
        } else {
            Object committedValue = v.getCommittedValue();
            int flags = (v.getCurrentValue() == null ? 0 : 1) | (committedValue == null ? 0 : 2);
            buff.put((byte)flags);
            if (v.getCurrentValue() != null) {
                this.valueType.write(buff, v.getCurrentValue());
            }
            if (committedValue != null) {
                this.valueType.write(buff, committedValue);
            }
        }
    }
}

