/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.result;

import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.SearchRow;
import org.gridgain.internal.h2.store.Data;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueLong;

public class RowImpl
implements Row {
    private long key;
    private final Value[] data;
    private int memory;
    private boolean deleted;

    public RowImpl(Value[] data, int memory) {
        this.data = data;
        this.memory = memory;
    }

    @Override
    public void setKey(SearchRow row) {
        this.setKey(row.getKey());
    }

    @Override
    public long getKey() {
        return this.key;
    }

    @Override
    public void setKey(long key) {
        this.key = key;
    }

    @Override
    public Value getValue(int i) {
        return i == -1 ? ValueLong.get(this.key) : this.data[i];
    }

    @Override
    public int getByteCount(Data dummy) {
        int size = 0;
        for (Value v : this.data) {
            size += dummy.getValueLen(v);
        }
        return size;
    }

    @Override
    public void setValue(int i, Value v) {
        if (i == -1) {
            this.key = v.getLong();
        } else {
            this.data[i] = v;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.data == null;
    }

    @Override
    public int getColumnCount() {
        return this.data.length;
    }

    @Override
    public int getMemory() {
        if (this.memory != -1) {
            return this.memory;
        }
        int m = 40;
        if (this.data != null) {
            int len = this.data.length;
            m += 24 + len * 8;
            for (Value v : this.data) {
                if (v == null) continue;
                m += v.getMemory();
            }
        }
        this.memory = m;
        return m;
    }

    public String toString() {
        return RowImpl.toString(this.key, this.deleted, this.data);
    }

    static String toString(long key, boolean isDeleted, Value[] data) {
        StringBuilder builder = new StringBuilder("( /* key:").append(key);
        if (isDeleted) {
            builder.append(" deleted");
        }
        builder.append(" */ ");
        if (data != null) {
            int length = data.length;
            for (int i = 0; i < length; ++i) {
                Value v;
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append((v = data[i]) == null ? "null" : v.getTraceSQL());
            }
        }
        return builder.append(')').toString();
    }

    @Override
    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public Value[] getValueList() {
        return this.data;
    }

    @Override
    public boolean hasSharedData(Row other) {
        if (other.getClass() == RowImpl.class) {
            RowImpl o = (RowImpl)other;
            return this.data == o.data;
        }
        return false;
    }
}

