/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.result;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.gridgain.internal.h2.command.dml.Query;
import org.gridgain.internal.h2.command.dml.SelectOrderBy;
import org.gridgain.internal.h2.engine.Database;
import org.gridgain.internal.h2.engine.SysProperties;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.expression.ExpressionColumn;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.util.Utils;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueNull;
import org.gridgain.internal.h2.value.ValueRow;

public class SortOrder
implements Comparator<Value[]> {
    public static final int ASCENDING = 0;
    public static final int DESCENDING = 1;
    public static final int NULLS_FIRST = 2;
    public static final int NULLS_LAST = 4;
    private static final int DEFAULT_NULL_SORT;
    private static final int DEFAULT_ASC_NULLS;
    private static final int DEFAULT_DESC_NULLS;
    private final Database database;
    private final int[] queryColumnIndexes;
    private final int[] sortTypes;
    private final ArrayList<SelectOrderBy> orderList;
    private final Query qry;

    public SortOrder(Database database, int[] queryColumnIndexes, int[] sortType, ArrayList<SelectOrderBy> orderList, Query qry) {
        this.database = database;
        this.queryColumnIndexes = queryColumnIndexes;
        this.sortTypes = sortType;
        this.orderList = orderList;
        this.qry = qry;
    }

    public String getSQL(Expression[] list, int visible, boolean alwaysQuote) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        for (int idx : this.queryColumnIndexes) {
            if (i > 0) {
                builder.append(", ");
            }
            if (idx < visible) {
                builder.append(idx + 1);
            } else {
                builder.append('=');
                list[idx].getUnenclosedSQL(builder, alwaysQuote);
            }
            SortOrder.typeToString(builder, this.sortTypes[i++]);
        }
        return builder.toString();
    }

    public static void typeToString(StringBuilder builder, int type) {
        if ((type & 1) != 0) {
            builder.append(" DESC");
        }
        if ((type & 2) != 0) {
            builder.append(" NULLS FIRST");
        } else if ((type & 4) != 0) {
            builder.append(" NULLS LAST");
        }
    }

    public static int compareNull(boolean aNull, int sortType) {
        if ((sortType & 2) != 0) {
            return aNull ? -1 : 1;
        }
        if ((sortType & 4) != 0) {
            return aNull ? 1 : -1;
        }
        int comp = aNull ? DEFAULT_NULL_SORT : -DEFAULT_NULL_SORT;
        return (sortType & 1) == 0 ? comp : -comp;
    }

    @Override
    public int compare(Value[] a, Value[] b) {
        int len = this.queryColumnIndexes.length;
        for (int i = 0; i < len; ++i) {
            boolean bNull;
            int idx = this.queryColumnIndexes[i];
            int type = this.sortTypes[i];
            Value ao = a[idx];
            Value bo = b[idx];
            boolean aNull = ao == ValueNull.INSTANCE;
            boolean bl = bNull = bo == ValueNull.INSTANCE;
            if (aNull || bNull) {
                if (aNull == bNull) continue;
                return SortOrder.compareNull(aNull, type);
            }
            int comp = this.database.compare(ao, bo);
            if (comp == 0) continue;
            return (type & 1) == 0 ? comp : -comp;
        }
        return 0;
    }

    public void sort(ArrayList<Value[]> rows) {
        Collections.sort(rows, this);
    }

    public void sort(ArrayList<Value[]> rows, int offset, int limit) {
        int rowsSize = rows.size();
        if (rows.isEmpty() || offset >= rowsSize || limit == 0) {
            return;
        }
        if (offset < 0) {
            offset = 0;
        }
        if (offset + limit > rowsSize) {
            limit = rowsSize - offset;
        }
        if (limit == 1 && offset == 0) {
            rows.set(0, Collections.min(rows, this));
            return;
        }
        Value[][] arr = (Value[][])rows.toArray((T[])new Value[0][]);
        Utils.sortTopN(arr, offset, limit, this);
        int end = Math.min(offset + limit, rowsSize);
        for (int i = 0; i < end; ++i) {
            rows.set(i, arr[i]);
        }
    }

    public int[] getQueryColumnIndexes() {
        return this.queryColumnIndexes;
    }

    public Column getColumn(int index, TableFilter filter) {
        if (this.orderList == null) {
            return null;
        }
        SelectOrderBy order = this.orderList.get(index);
        Expression expr = order.expression;
        if (expr == null) {
            if (order.columnIndexExpr.isConstant()) {
                int expIdx = order.columnIndexExpr.getValue(null).getInt();
                expr = this.qry.getExpressions().get(expIdx - 1);
            } else {
                return null;
            }
        }
        if ((expr = expr.getNonAliasExpression()).isConstant()) {
            return null;
        }
        if (!(expr instanceof ExpressionColumn)) {
            return null;
        }
        ExpressionColumn exprCol = (ExpressionColumn)expr;
        if (exprCol.getTableFilter() != filter) {
            return null;
        }
        return exprCol.getColumn();
    }

    public int[] getSortTypes() {
        return this.sortTypes;
    }

    public int[] getSortTypesWithNullPosition() {
        int[] sortTypes = (int[])this.sortTypes.clone();
        int length = sortTypes.length;
        for (int i = 0; i < length; ++i) {
            sortTypes[i] = SortOrder.addExplicitNullPosition(sortTypes[i]);
        }
        return sortTypes;
    }

    public Comparator<Value> getRowValueComparator() {
        return new Comparator<Value>(){

            @Override
            public int compare(Value o1, Value o2) {
                return SortOrder.this.compare(((ValueRow)o1).getList(), ((ValueRow)o2).getList());
            }
        };
    }

    public static int addExplicitNullPosition(int sortType) {
        if ((sortType & 6) == 0) {
            return sortType | ((sortType & 1) == 0 ? DEFAULT_ASC_NULLS : DEFAULT_DESC_NULLS);
        }
        return sortType;
    }

    static {
        if (SysProperties.SORT_NULLS_HIGH) {
            DEFAULT_NULL_SORT = 1;
            DEFAULT_ASC_NULLS = 4;
            DEFAULT_DESC_NULLS = 2;
        } else {
            DEFAULT_NULL_SORT = -1;
            DEFAULT_ASC_NULLS = 2;
            DEFAULT_DESC_NULLS = 4;
        }
    }
}

