/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.security.auth.impl;

import java.util.regex.Pattern;
import org.gridgain.internal.h2.api.CredentialsValidator;
import org.gridgain.internal.h2.security.SHA256;
import org.gridgain.internal.h2.security.auth.AuthenticationException;
import org.gridgain.internal.h2.security.auth.AuthenticationInfo;
import org.gridgain.internal.h2.security.auth.ConfigProperties;
import org.gridgain.internal.h2.util.MathUtils;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.util.Utils;

public class StaticUserCredentialsValidator
implements CredentialsValidator {
    private Pattern userNamePattern;
    private String password;
    private byte[] salt;
    private byte[] hashWithSalt;

    public StaticUserCredentialsValidator() {
    }

    public StaticUserCredentialsValidator(String userNamePattern, String password) {
        if (userNamePattern != null) {
            this.userNamePattern = Pattern.compile(userNamePattern.toUpperCase());
        }
        this.salt = MathUtils.secureRandomBytes(256);
        this.hashWithSalt = SHA256.getHashWithSalt(password.getBytes(), this.salt);
    }

    @Override
    public boolean validateCredentials(AuthenticationInfo authenticationInfo) throws AuthenticationException {
        if (this.userNamePattern != null && !this.userNamePattern.matcher(authenticationInfo.getUserName()).matches()) {
            return false;
        }
        if (this.password != null) {
            return this.password.equals(authenticationInfo.getPassword());
        }
        return Utils.compareSecure(this.hashWithSalt, SHA256.getHashWithSalt(authenticationInfo.getPassword().getBytes(), this.salt));
    }

    @Override
    public void configure(ConfigProperties configProperties) {
        String hashString;
        String userNamePatternString = configProperties.getStringValue("userNamePattern", null);
        if (userNamePatternString != null) {
            this.userNamePattern = Pattern.compile(userNamePatternString);
        }
        this.password = configProperties.getStringValue("password", this.password);
        String saltString = configProperties.getStringValue("salt", null);
        if (saltString != null) {
            this.salt = StringUtils.convertHexToBytes(saltString);
        }
        if ((hashString = configProperties.getStringValue("hash", null)) != null) {
            this.hashWithSalt = SHA256.getHashWithSalt(StringUtils.convertHexToBytes(hashString), this.salt);
        }
    }
}

