/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.store;

import java.io.OutputStream;
import java.util.Arrays;
import org.gridgain.internal.h2.store.Data;
import org.gridgain.internal.h2.store.DataHandler;
import org.gridgain.internal.h2.store.FileStore;
import org.gridgain.internal.h2.tools.CompressTool;

public class FileStoreOutputStream
extends OutputStream {
    private FileStore store;
    private final Data page;
    private final String compressionAlgorithm;
    private final CompressTool compress;
    private final byte[] buffer = new byte[]{0};

    public FileStoreOutputStream(FileStore store, DataHandler handler, String compressionAlgorithm) {
        this.store = store;
        if (compressionAlgorithm != null) {
            this.compress = CompressTool.getInstance();
            this.compressionAlgorithm = compressionAlgorithm;
        } else {
            this.compress = null;
            this.compressionAlgorithm = null;
        }
        this.page = Data.create(handler, 16, true);
    }

    @Override
    public void write(int b) {
        this.buffer[0] = (byte)b;
        this.write(this.buffer);
    }

    @Override
    public void write(byte[] buff) {
        this.write(buff, 0, buff.length);
    }

    @Override
    public void write(byte[] buff, int off, int len) {
        if (len > 0) {
            this.page.reset();
            if (this.compress != null) {
                if (off != 0 || len != buff.length) {
                    buff = Arrays.copyOfRange(buff, off, off + len);
                    off = 0;
                }
                int uncompressed = len;
                buff = this.compress.compress(buff, this.compressionAlgorithm);
                len = buff.length;
                this.page.checkCapacity(8 + len);
                this.page.writeInt(len);
                this.page.writeInt(uncompressed);
                this.page.write(buff, off, len);
            } else {
                this.page.checkCapacity(4 + len);
                this.page.writeInt(len);
                this.page.write(buff, off, len);
            }
            this.page.fillAligned();
            this.store.write(this.page.getBytes(), 0, this.page.length());
        }
    }

    @Override
    public void close() {
        if (this.store != null) {
            try {
                this.store.close();
            }
            finally {
                this.store = null;
            }
        }
    }
}

