/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.store.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonWritableChannelException;
import org.gridgain.internal.h2.store.fs.FakeFileChannel;
import org.gridgain.internal.h2.store.fs.FileBase;
import org.gridgain.internal.h2.store.fs.FileNioMemData;

class FileNioMem
extends FileBase {
    FileNioMemData data;
    private final boolean readOnly;
    private long pos;

    FileNioMem(FileNioMemData data, boolean readOnly) {
        this.data = data;
        this.readOnly = readOnly;
    }

    @Override
    public long size() {
        return this.data.length();
    }

    @Override
    public FileChannel truncate(long newLength) throws IOException {
        if (this.readOnly) {
            throw new NonWritableChannelException();
        }
        if (this.data == null) {
            throw new ClosedChannelException();
        }
        if (newLength < this.size()) {
            this.data.touch(this.readOnly);
            this.pos = Math.min(this.pos, newLength);
            this.data.truncate(newLength);
        }
        return this;
    }

    @Override
    public FileChannel position(long newPos) {
        this.pos = (int)newPos;
        return this;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (this.data == null) {
            throw new ClosedChannelException();
        }
        int len = src.remaining();
        if (len == 0) {
            return 0;
        }
        this.data.touch(this.readOnly);
        this.pos = this.data.readWrite(this.pos, src, 0, len, true);
        src.position(src.position() + len);
        return len;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (this.data == null) {
            throw new ClosedChannelException();
        }
        int len = dst.remaining();
        if (len == 0) {
            return 0;
        }
        long newPos = this.data.readWrite(this.pos, dst, dst.position(), len, false);
        len = (int)(newPos - this.pos);
        if (len <= 0) {
            return -1;
        }
        dst.position(dst.position() + len);
        this.pos = newPos;
        return len;
    }

    @Override
    public int read(ByteBuffer dst, long position) throws IOException {
        if (this.data == null) {
            throw new ClosedChannelException();
        }
        int len = dst.remaining();
        if (len == 0) {
            return 0;
        }
        long newPos = this.data.readWrite(position, dst, dst.position(), len, false);
        len = (int)(newPos - position);
        if (len <= 0) {
            return -1;
        }
        dst.position(dst.position() + len);
        return len;
    }

    @Override
    public long position() {
        return this.pos;
    }

    @Override
    public void implCloseChannel() throws IOException {
        this.pos = 0L;
        this.data = null;
    }

    @Override
    public void force(boolean metaData) throws IOException {
    }

    @Override
    public synchronized FileLock tryLock(long position, long size, boolean shared) throws IOException {
        if (this.data == null) {
            throw new ClosedChannelException();
        }
        if (shared ? !this.data.lockShared() : !this.data.lockExclusive()) {
            return null;
        }
        return new FileLock(FakeFileChannel.INSTANCE, position, size, shared){

            @Override
            public boolean isValid() {
                return true;
            }

            @Override
            public void release() throws IOException {
                FileNioMem.this.data.unlock();
            }
        };
    }

    public String toString() {
        return this.data == null ? "<closed>" : this.data.getName();
    }
}

