/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.tools;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.mvstore.MVStore;
import org.gridgain.internal.h2.security.SHA256;
import org.gridgain.internal.h2.store.FileLister;
import org.gridgain.internal.h2.store.FileStore;
import org.gridgain.internal.h2.store.fs.FileChannelInputStream;
import org.gridgain.internal.h2.store.fs.FileChannelOutputStream;
import org.gridgain.internal.h2.store.fs.FilePath;
import org.gridgain.internal.h2.store.fs.FilePathEncrypt;
import org.gridgain.internal.h2.store.fs.FileUtils;
import org.gridgain.internal.h2.util.Tool;

public class ChangeFileEncryption
extends Tool {
    private String directory;
    private String cipherType;
    private byte[] decrypt;
    private byte[] encrypt;
    private byte[] decryptKey;
    private byte[] encryptKey;

    public static void main(String ... args) {
        try {
            new ChangeFileEncryption().runTool(args);
        }
        catch (SQLException ex) {
            ex.printStackTrace(System.err);
            System.exit(1);
        }
    }

    @Override
    public void runTool(String ... args) throws SQLException {
        String dir = ".";
        String cipher = null;
        char[] decryptPassword = null;
        char[] encryptPassword = null;
        String db = null;
        boolean quiet = false;
        for (int i = 0; args != null && i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-dir")) {
                dir = args[++i];
                continue;
            }
            if (arg.equals("-cipher")) {
                cipher = args[++i];
                continue;
            }
            if (arg.equals("-db")) {
                db = args[++i];
                continue;
            }
            if (arg.equals("-decrypt")) {
                decryptPassword = args[++i].toCharArray();
                continue;
            }
            if (arg.equals("-encrypt")) {
                encryptPassword = args[++i].toCharArray();
                continue;
            }
            if (arg.equals("-quiet")) {
                quiet = true;
                continue;
            }
            if (arg.equals("-help") || arg.equals("-?")) {
                this.showUsage();
                return;
            }
            this.showUsageAndThrowUnsupportedOption(arg);
        }
        if (encryptPassword == null && decryptPassword == null || cipher == null) {
            this.showUsage();
            throw new SQLException("Encryption or decryption password not set, or cipher not set");
        }
        try {
            this.process(dir, db, cipher, decryptPassword, encryptPassword, quiet);
        }
        catch (Exception e) {
            throw DbException.toSQLException(e);
        }
    }

    private static byte[] getFileEncryptionKey(char[] password) {
        if (password == null) {
            return null;
        }
        return SHA256.getKeyPasswordHash("file", (char[])password.clone());
    }

    public static void execute(String dir, String db, String cipher, char[] decryptPassword, char[] encryptPassword, boolean quiet) throws SQLException {
        try {
            new ChangeFileEncryption().process(dir, db, cipher, decryptPassword, encryptPassword, quiet);
        }
        catch (Exception e) {
            throw DbException.toSQLException(e);
        }
    }

    private void process(String dir, String db, String cipher, char[] decryptPassword, char[] encryptPassword, boolean quiet) throws SQLException {
        dir = FileLister.getDir(dir);
        ChangeFileEncryption change = new ChangeFileEncryption();
        if (encryptPassword != null) {
            for (char c : encryptPassword) {
                if (c != ' ') continue;
                throw new SQLException("The file password may not contain spaces");
            }
            change.encryptKey = FilePathEncrypt.getPasswordBytes(encryptPassword);
            change.encrypt = ChangeFileEncryption.getFileEncryptionKey(encryptPassword);
        }
        if (decryptPassword != null) {
            change.decryptKey = FilePathEncrypt.getPasswordBytes(decryptPassword);
            change.decrypt = ChangeFileEncryption.getFileEncryptionKey(decryptPassword);
        }
        change.out = this.out;
        change.directory = dir;
        change.cipherType = cipher;
        ArrayList<String> files = FileLister.getDatabaseFiles(dir, db, true);
        FileLister.tryUnlockDatabase(files, "encryption");
        files = FileLister.getDatabaseFiles(dir, db, false);
        if (files.isEmpty() && !quiet) {
            this.printNoDatabaseFilesFound(dir, db);
        }
        for (String fileName : files) {
            String temp = dir + "/temp.db";
            FileUtils.delete(temp);
            FileUtils.move(fileName, temp);
            FileUtils.move(temp, fileName);
        }
        for (String fileName : files) {
            if (FileUtils.isDirectory(fileName)) continue;
            change.process(fileName, quiet, decryptPassword);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(String fileName, boolean quiet, char[] decryptPassword) throws SQLException {
        if (fileName.endsWith(".mv.db")) {
            try {
                this.copyMvStore(fileName, quiet, decryptPassword);
            }
            catch (IOException e) {
                throw DbException.convertIOException(e, "Error encrypting / decrypting file " + fileName);
            }
            return;
        }
        FileStore in = this.decrypt == null ? FileStore.open(null, fileName, "r") : FileStore.open(null, fileName, "r", this.cipherType, this.decrypt);
        try {
            in.init();
            this.copyPageStore(fileName, in, this.encrypt, quiet);
        }
        finally {
            in.closeSilently();
        }
    }

    private void copyMvStore(String fileName, boolean quiet, char[] decryptPassword) throws IOException, SQLException {
        if (FileUtils.isDirectory(fileName)) {
            return;
        }
        try {
            MVStore source = new MVStore.Builder().fileName(fileName).readOnly().encryptionKey(decryptPassword).open();
            source.close();
        }
        catch (IllegalStateException ex) {
            throw new SQLException("error decrypting file " + fileName, ex);
        }
        String temp = this.directory + "/temp.db";
        try (FileChannel fileIn = ChangeFileEncryption.getFileChannel(fileName, "r", this.decryptKey);
             FileChannelInputStream inStream = new FileChannelInputStream(fileIn, true);){
            FileUtils.delete(temp);
            try (FileChannelOutputStream outStream = new FileChannelOutputStream(ChangeFileEncryption.getFileChannel(temp, "rw", this.encryptKey), true);){
                long remaining;
                byte[] buffer = new byte[4096];
                long total = remaining = fileIn.size();
                long time = System.nanoTime();
                while (remaining > 0L) {
                    if (!quiet && System.nanoTime() - time > TimeUnit.SECONDS.toNanos(1L)) {
                        this.out.println(fileName + ": " + (100L - 100L * remaining / total) + "%");
                        time = System.nanoTime();
                    }
                    int len = (int)Math.min((long)buffer.length, remaining);
                    len = ((InputStream)inStream).read(buffer, 0, len);
                    ((OutputStream)outStream).write(buffer, 0, len);
                    remaining -= (long)len;
                }
            }
        }
        FileUtils.delete(fileName);
        FileUtils.move(temp, fileName);
    }

    private static FileChannel getFileChannel(String fileName, String r, byte[] decryptKey) throws IOException {
        FileChannel fileIn = FilePath.get(fileName).open(r);
        if (decryptKey != null) {
            fileIn = new FilePathEncrypt.FileEncrypt(fileName, decryptKey, fileIn);
        }
        return fileIn;
    }

    private void copyPageStore(String fileName, FileStore in, byte[] key, boolean quiet) {
        long remaining;
        if (FileUtils.isDirectory(fileName)) {
            return;
        }
        String temp = this.directory + "/temp.db";
        FileUtils.delete(temp);
        FileStore fileOut = key == null ? FileStore.open(null, temp, "rw") : FileStore.open(null, temp, "rw", this.cipherType, key);
        byte[] buffer = new byte[4096];
        fileOut.init();
        long total = remaining = in.length() - 48L;
        in.seek(48L);
        fileOut.seek(48L);
        long time = System.nanoTime();
        while (remaining > 0L) {
            if (!quiet && System.nanoTime() - time > TimeUnit.SECONDS.toNanos(1L)) {
                this.out.println(fileName + ": " + (100L - 100L * remaining / total) + "%");
                time = System.nanoTime();
            }
            int len = (int)Math.min((long)buffer.length, remaining);
            in.readFully(buffer, 0, len);
            fileOut.write(buffer, 0, len);
            remaining -= (long)len;
        }
        in.close();
        fileOut.close();
        FileUtils.delete(fileName);
        FileUtils.move(temp, fileName);
    }
}

