/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.tools;

import java.sql.SQLException;
import java.util.ArrayList;
import org.gridgain.internal.h2.store.FileLister;
import org.gridgain.internal.h2.store.fs.FileUtils;
import org.gridgain.internal.h2.util.Tool;

public class DeleteDbFiles
extends Tool {
    public static void main(String ... args) throws SQLException {
        new DeleteDbFiles().runTool(args);
    }

    @Override
    public void runTool(String ... args) throws SQLException {
        String dir = ".";
        String db = null;
        boolean quiet = false;
        for (int i = 0; args != null && i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-dir")) {
                dir = args[++i];
                continue;
            }
            if (arg.equals("-db")) {
                db = args[++i];
                continue;
            }
            if (arg.equals("-quiet")) {
                quiet = true;
                continue;
            }
            if (arg.equals("-help") || arg.equals("-?")) {
                this.showUsage();
                return;
            }
            this.showUsageAndThrowUnsupportedOption(arg);
        }
        this.process(dir, db, quiet);
    }

    public static void execute(String dir, String db, boolean quiet) {
        new DeleteDbFiles().process(dir, db, quiet);
    }

    private void process(String dir, String db, boolean quiet) {
        ArrayList<String> files = FileLister.getDatabaseFiles(dir, db, true);
        if (files.isEmpty() && !quiet) {
            this.printNoDatabaseFilesFound(dir, db);
        }
        for (String fileName : files) {
            DeleteDbFiles.process(fileName, quiet);
            if (quiet) continue;
            this.out.println("Processed: " + fileName);
        }
    }

    private static void process(String fileName, boolean quiet) {
        if (FileUtils.isDirectory(fileName)) {
            FileUtils.tryDelete(fileName);
        } else if (quiet || fileName.endsWith(".temp.db") || fileName.endsWith(".trace.db")) {
            FileUtils.tryDelete(fileName);
        } else {
            FileUtils.delete(fileName);
        }
    }
}

