/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.tools;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.gridgain.internal.h2.Driver;
import org.gridgain.internal.h2.util.JdbcUtils;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.util.Tool;

public class Script
extends Tool {
    public static void main(String ... args) throws SQLException {
        new Script().runTool(args);
    }

    @Override
    public void runTool(String ... args) throws SQLException {
        String url = null;
        String user = "";
        String password = "";
        String file = "backup.sql";
        String options1 = "";
        String options2 = "";
        for (int i = 0; args != null && i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-url")) {
                url = args[++i];
                continue;
            }
            if (arg.equals("-user")) {
                user = args[++i];
                continue;
            }
            if (arg.equals("-password")) {
                password = args[++i];
                continue;
            }
            if (arg.equals("-script")) {
                file = args[++i];
                continue;
            }
            if (arg.equals("-options")) {
                StringBuilder buff1 = new StringBuilder();
                StringBuilder buff2 = new StringBuilder();
                ++i;
                while (i < args.length) {
                    String a = args[i];
                    String upper = StringUtils.toUpperEnglish(a);
                    if ("SIMPLE".equals(upper) || upper.startsWith("NO") || "DROP".equals(upper)) {
                        buff1.append(' ');
                        buff1.append(args[i]);
                    } else if ("BLOCKSIZE".equals(upper)) {
                        buff1.append(' ');
                        buff1.append(args[i]);
                        buff1.append(' ');
                        buff1.append(args[++i]);
                    } else {
                        buff2.append(' ');
                        buff2.append(args[i]);
                    }
                    ++i;
                }
                options1 = buff1.toString();
                options2 = buff2.toString();
                continue;
            }
            if (arg.equals("-help") || arg.equals("-?")) {
                this.showUsage();
                return;
            }
            this.showUsageAndThrowUnsupportedOption(arg);
        }
        if (url == null) {
            this.showUsage();
            throw new SQLException("URL not set");
        }
        Script.process(url, user, password, file, options1, options2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void process(String url, String user, String password, String fileName, String options1, String options2) throws SQLException {
        Connection conn = null;
        try {
            Driver.load();
            conn = DriverManager.getConnection(url, user, password);
            Script.process(conn, fileName, options1, options2);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeSilently(conn);
            throw throwable;
        }
        JdbcUtils.closeSilently(conn);
    }

    public static void process(Connection conn, String fileName, String options1, String options2) throws SQLException {
        try (Statement stat = conn.createStatement();){
            String sql = "SCRIPT " + options1 + " TO '" + fileName + "' " + options2;
            stat.execute(sql);
        }
    }
}

