/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.util.geometry;

import java.io.ByteArrayOutputStream;
import org.gridgain.internal.h2.util.Bits;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.util.geometry.GeometryUtils;

public final class EWKBUtils {
    public static final int EWKB_Z = Integer.MIN_VALUE;
    public static final int EWKB_M = 0x40000000;
    public static final int EWKB_SRID = 0x20000000;

    public static byte[] ewkb2ewkb(byte[] ewkb) {
        GeometryUtils.DimensionSystemTarget dimensionTarget = new GeometryUtils.DimensionSystemTarget();
        EWKBUtils.parseEWKB(ewkb, dimensionTarget);
        return EWKBUtils.ewkb2ewkb(ewkb, dimensionTarget.getDimensionSystem());
    }

    public static byte[] ewkb2ewkb(byte[] ewkb, int dimensionSystem) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        EWKBTarget target = new EWKBTarget(output, dimensionSystem);
        EWKBUtils.parseEWKB(ewkb, target);
        return output.toByteArray();
    }

    public static void parseEWKB(byte[] ewkb, GeometryUtils.Target target) {
        try {
            EWKBUtils.parseEWKB(new EWKBSource(ewkb), target, 0);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException();
        }
    }

    public static int type2dimensionSystem(int type) {
        boolean useZ = (type & Integer.MIN_VALUE) != 0;
        boolean useM = (type & 0x40000000) != 0;
        switch ((type &= 0xFFFF) / 1000) {
            case 1: {
                useZ = true;
                break;
            }
            case 3: {
                useZ = true;
            }
            case 2: {
                useM = true;
            }
        }
        return (useZ ? 1 : 0) | (useM ? 2 : 0);
    }

    private static void parseEWKB(EWKBSource source, GeometryUtils.Target target, int parentType) {
        int srid;
        switch (source.readByte()) {
            case 0: {
                source.bigEndian = true;
                break;
            }
            case 1: {
                source.bigEndian = false;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        int type = source.readInt();
        boolean useZ = (type & Integer.MIN_VALUE) != 0;
        boolean useM = (type & 0x40000000) != 0;
        int n = srid = (type & 0x20000000) != 0 ? source.readInt() : 0;
        if (parentType == 0) {
            target.init(srid);
        }
        switch ((type &= 0xFFFF) / 1000) {
            case 1: {
                useZ = true;
                break;
            }
            case 3: {
                useZ = true;
            }
            case 2: {
                useM = true;
            }
        }
        target.dimensionSystem((useZ ? 1 : 0) | (useM ? 2 : 0));
        switch (type %= 1000) {
            case 1: {
                if (parentType != 0 && parentType != 4 && parentType != 7) {
                    throw new IllegalArgumentException();
                }
                target.startPoint();
                EWKBUtils.addCoordinate(source, target, useZ, useM, 0, 1);
                break;
            }
            case 2: {
                if (parentType != 0 && parentType != 5 && parentType != 7) {
                    throw new IllegalArgumentException();
                }
                int numPoints = source.readInt();
                if (numPoints < 0 || numPoints == 1) {
                    throw new IllegalArgumentException();
                }
                target.startLineString(numPoints);
                for (int i = 0; i < numPoints; ++i) {
                    EWKBUtils.addCoordinate(source, target, useZ, useM, i, numPoints);
                }
                break;
            }
            case 3: {
                if (parentType != 0 && parentType != 6 && parentType != 7) {
                    throw new IllegalArgumentException();
                }
                int numInner = source.readInt() - 1;
                if (numInner < 0) {
                    throw new IllegalArgumentException();
                }
                int size = source.readInt();
                if (size < 0 || size >= 1 && size <= 3) {
                    throw new IllegalArgumentException();
                }
                if (size == 0 && numInner > 0) {
                    throw new IllegalArgumentException();
                }
                target.startPolygon(numInner, size);
                if (size <= 0) break;
                EWKBUtils.addRing(source, target, useZ, useM, size);
                for (int i = 0; i < numInner; ++i) {
                    size = source.readInt();
                    if (size < 0 || size >= 1 && size <= 3) {
                        throw new IllegalArgumentException();
                    }
                    target.startPolygonInner(size);
                    EWKBUtils.addRing(source, target, useZ, useM, size);
                }
                target.endNonEmptyPolygon();
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                if (parentType != 0 && parentType != 7) {
                    throw new IllegalArgumentException();
                }
                int numItems = source.readInt();
                if (numItems < 0) {
                    throw new IllegalArgumentException();
                }
                target.startCollection(type, numItems);
                for (int i = 0; i < numItems; ++i) {
                    GeometryUtils.Target innerTarget = target.startCollectionItem(i, numItems);
                    EWKBUtils.parseEWKB(source, innerTarget, type);
                    target.endCollectionItem(innerTarget, i, numItems);
                }
                target.endCollection(type);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private static void addRing(EWKBSource source, GeometryUtils.Target target, boolean useZ, boolean useM, int size) {
        if (size >= 4) {
            double startX = source.readCoordinate();
            double startY = source.readCoordinate();
            target.addCoordinate(startX, startY, useZ ? source.readCoordinate() : Double.NaN, useM ? source.readCoordinate() : Double.NaN, 0, size);
            for (int i = 1; i < size - 1; ++i) {
                EWKBUtils.addCoordinate(source, target, useZ, useM, i, size);
            }
            double endX = source.readCoordinate();
            double endY = source.readCoordinate();
            if (startX != endX || startY != endY) {
                throw new IllegalArgumentException();
            }
            target.addCoordinate(endX, endY, useZ ? source.readCoordinate() : Double.NaN, useM ? source.readCoordinate() : Double.NaN, size - 1, size);
        }
    }

    private static void addCoordinate(EWKBSource source, GeometryUtils.Target target, boolean useZ, boolean useM, int index, int total) {
        target.addCoordinate(source.readCoordinate(), source.readCoordinate(), useZ ? source.readCoordinate() : Double.NaN, useM ? source.readCoordinate() : Double.NaN, index, total);
    }

    public static byte[] envelope2wkb(double[] envelope) {
        byte[] result;
        if (envelope == null) {
            return null;
        }
        double minX = envelope[0];
        double maxX = envelope[1];
        double minY = envelope[2];
        double maxY = envelope[3];
        if (minX == maxX && minY == maxY) {
            result = new byte[21];
            result[4] = 1;
            Bits.writeDouble(result, 5, minX);
            Bits.writeDouble(result, 13, minY);
        } else if (minX == maxX || minY == maxY) {
            result = new byte[41];
            result[4] = 2;
            result[8] = 2;
            Bits.writeDouble(result, 9, minX);
            Bits.writeDouble(result, 17, minY);
            Bits.writeDouble(result, 25, maxX);
            Bits.writeDouble(result, 33, maxY);
        } else {
            result = new byte[93];
            result[4] = 3;
            result[8] = 1;
            result[12] = 5;
            Bits.writeDouble(result, 13, minX);
            Bits.writeDouble(result, 21, minY);
            Bits.writeDouble(result, 29, minX);
            Bits.writeDouble(result, 37, maxY);
            Bits.writeDouble(result, 45, maxX);
            Bits.writeDouble(result, 53, maxY);
            Bits.writeDouble(result, 61, maxX);
            Bits.writeDouble(result, 69, minY);
            Bits.writeDouble(result, 77, minX);
            Bits.writeDouble(result, 85, minY);
        }
        return result;
    }

    private EWKBUtils() {
    }

    private static final class EWKBSource {
        private final byte[] ewkb;
        private int offset;
        boolean bigEndian;

        EWKBSource(byte[] ewkb) {
            this.ewkb = ewkb;
        }

        byte readByte() {
            return this.ewkb[this.offset++];
        }

        int readInt() {
            int result = this.bigEndian ? Bits.readInt(this.ewkb, this.offset) : Bits.readIntLE(this.ewkb, this.offset);
            this.offset += 4;
            return result;
        }

        double readCoordinate() {
            double v = this.bigEndian ? Bits.readDouble(this.ewkb, this.offset) : Bits.readDoubleLE(this.ewkb, this.offset);
            this.offset += 8;
            return GeometryUtils.toCanonicalDouble(v);
        }

        public String toString() {
            String s = StringUtils.convertBytesToHex(this.ewkb);
            int idx = this.offset * 2;
            return new StringBuilder(s.length() + 3).append(s, 0, idx).append("<*>").append(s, idx, s.length()).toString();
        }
    }

    public static final class EWKBTarget
    extends GeometryUtils.Target {
        private final ByteArrayOutputStream output;
        private final int dimensionSystem;
        private final byte[] buf = new byte[8];
        private int type;
        private int srid;

        public EWKBTarget(ByteArrayOutputStream output, int dimensionSystem) {
            this.output = output;
            this.dimensionSystem = dimensionSystem;
        }

        @Override
        protected void init(int srid) {
            this.srid = srid;
        }

        @Override
        protected void startPoint() {
            this.writeHeader(1);
        }

        @Override
        protected void startLineString(int numPoints) {
            this.writeHeader(2);
            this.writeInt(numPoints);
        }

        @Override
        protected void startPolygon(int numInner, int numPoints) {
            this.writeHeader(3);
            this.writeInt(numInner + 1);
            this.writeInt(numPoints);
        }

        @Override
        protected void startPolygonInner(int numInner) {
            this.writeInt(numInner);
        }

        @Override
        protected void startCollection(int type, int numItems) {
            this.writeHeader(type);
            this.writeInt(numItems);
        }

        private void writeHeader(int type) {
            this.type = type;
            switch (this.dimensionSystem) {
                case 1: {
                    type |= Integer.MIN_VALUE;
                    break;
                }
                case 3: {
                    type |= Integer.MIN_VALUE;
                }
                case 2: {
                    type |= 0x40000000;
                }
            }
            if (this.srid != 0) {
                type |= 0x20000000;
            }
            this.output.write(0);
            this.writeInt(type);
            if (this.srid != 0) {
                this.writeInt(this.srid);
                this.srid = 0;
            }
        }

        @Override
        protected GeometryUtils.Target startCollectionItem(int index, int total) {
            return this;
        }

        @Override
        protected void addCoordinate(double x, double y, double z, double m, int index, int total) {
            boolean check;
            boolean bl = check = this.type != 1 || !Double.isNaN(x) || !Double.isNaN(y) || !Double.isNaN(z) || !Double.isNaN(m);
            if (check) {
                GeometryUtils.checkFinite(x);
                GeometryUtils.checkFinite(y);
            }
            this.writeDouble(x);
            this.writeDouble(y);
            if ((this.dimensionSystem & 1) != 0) {
                this.writeDouble(check ? GeometryUtils.checkFinite(z) : z);
            }
            if ((this.dimensionSystem & 2) != 0) {
                this.writeDouble(check ? GeometryUtils.checkFinite(m) : m);
            }
        }

        private void writeInt(int v) {
            Bits.writeInt(this.buf, 0, v);
            this.output.write(this.buf, 0, 4);
        }

        private void writeDouble(double v) {
            v = GeometryUtils.toCanonicalDouble(v);
            Bits.writeDouble(this.buf, 0, v);
            this.output.write(this.buf, 0, 8);
        }
    }
}

