/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.value;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.gridgain.internal.h2.api.Interval;
import org.gridgain.internal.h2.api.IntervalQualifier;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.util.DateTimeUtils;
import org.gridgain.internal.h2.util.IntervalUtils;
import org.gridgain.internal.h2.value.CompareMode;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;

public class ValueInterval
extends Value {
    public static final int DEFAULT_PRECISION = 2;
    public static final int MAXIMUM_PRECISION = 18;
    static final int DEFAULT_SCALE = 6;
    public static final int MAXIMUM_SCALE = 9;
    private final int valueType;
    private TypeInfo type;
    private final boolean negative;
    private final long leading;
    private final long remaining;

    public static ValueInterval from(IntervalQualifier qualifier, boolean negative, long leading, long remaining) {
        negative = IntervalUtils.validateInterval(qualifier, negative, leading, remaining);
        return (ValueInterval)Value.cache(new ValueInterval(qualifier.ordinal() + 26, negative, leading, remaining));
    }

    public static int getDisplaySize(int type, int precision, int scale) {
        switch (type) {
            case 26: 
            case 29: {
                return 17 + precision;
            }
            case 27: {
                return 18 + precision;
            }
            case 28: {
                return 16 + precision;
            }
            case 30: {
                return 19 + precision;
            }
            case 31: {
                return scale > 0 ? 20 + precision + scale : 19 + precision;
            }
            case 32: {
                return 29 + precision;
            }
            case 33: {
                return 27 + precision;
            }
            case 34: {
                return 32 + precision;
            }
            case 35: {
                return scale > 0 ? 36 + precision + scale : 35 + precision;
            }
            case 36: {
                return 30 + precision;
            }
            case 37: {
                return scale > 0 ? 34 + precision + scale : 33 + precision;
            }
            case 38: {
                return scale > 0 ? 33 + precision + scale : 32 + precision;
            }
        }
        throw DbException.getUnsupportedException(Integer.toString(type));
    }

    private ValueInterval(int type, boolean negative, long leading, long remaining) {
        this.valueType = type;
        this.negative = negative;
        this.leading = leading;
        this.remaining = remaining;
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder) {
        return IntervalUtils.appendInterval(builder, this.getQualifier(), this.negative, this.leading, this.remaining);
    }

    @Override
    public TypeInfo getType() {
        TypeInfo type = this.type;
        if (type == null) {
            int precision = 0;
            for (long l = this.leading; l > 0L; l /= 10L) {
                ++precision;
            }
            if (precision == 0) {
                precision = 1;
            }
            this.type = type = new TypeInfo(this.valueType, precision, 0, ValueInterval.getDisplaySize(this.valueType, 18, 9), null);
        }
        return type;
    }

    @Override
    public int getValueType() {
        return this.valueType;
    }

    @Override
    public int getMemory() {
        return 48;
    }

    @Override
    public Value convertScale(boolean onlyToSmallerScale, int targetScale) {
        if (targetScale >= 9) {
            return this;
        }
        if (targetScale < 0) {
            throw DbException.getInvalidValueException("scale", targetScale);
        }
        IntervalQualifier qualifier = this.getQualifier();
        if (!qualifier.hasSeconds()) {
            return this;
        }
        long r = DateTimeUtils.convertScale(this.remaining, targetScale);
        if (r == this.remaining) {
            return this;
        }
        long l = this.leading;
        switch (this.valueType) {
            case 31: {
                if (r < 1000000000L) break;
                ++l;
                r -= 1000000000L;
                break;
            }
            case 35: {
                if (r < 86400000000000L) break;
                ++l;
                r -= 86400000000000L;
                break;
            }
            case 37: {
                if (r < 3600000000000L) break;
                ++l;
                r -= 3600000000000L;
                break;
            }
            case 38: {
                if (r < 60000000000L) break;
                ++l;
                r -= 60000000000L;
            }
        }
        return ValueInterval.from(qualifier, this.negative, l, r);
    }

    @Override
    public String getString() {
        return IntervalUtils.appendInterval(new StringBuilder(), this.getQualifier(), this.negative, this.leading, this.remaining).toString();
    }

    @Override
    public long getLong() {
        if (this.valueType <= 30) {
            return this.negative ? -this.leading : this.leading;
        }
        return this.getBigDecimal().setScale(0, RoundingMode.HALF_UP).longValue();
    }

    @Override
    public BigDecimal getBigDecimal() {
        long multiplier;
        switch (this.valueType) {
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                return BigDecimal.valueOf(this.negative ? -this.leading : this.leading);
            }
            case 31: {
                multiplier = 1000000000L;
                break;
            }
            case 32: {
                multiplier = 12L;
                break;
            }
            case 33: {
                multiplier = 24L;
                break;
            }
            case 34: {
                multiplier = 1440L;
                break;
            }
            case 35: {
                multiplier = 86400000000000L;
                break;
            }
            case 36: {
                multiplier = 60L;
                break;
            }
            case 37: {
                multiplier = 3600000000000L;
                break;
            }
            case 38: {
                multiplier = 60000000000L;
                break;
            }
            default: {
                throw DbException.getUnsupportedException("valueType = " + this.valueType);
            }
        }
        BigDecimal bd = BigDecimal.valueOf(this.leading);
        if (this.remaining != 0L) {
            BigDecimal m = BigDecimal.valueOf(multiplier);
            bd = bd.add(BigDecimal.valueOf(this.remaining).divide(m, m.precision(), RoundingMode.HALF_DOWN)).stripTrailingZeros();
        }
        return this.negative ? bd.negate() : bd;
    }

    @Override
    public Object getObject() {
        return new Interval(this.getQualifier(), this.negative, this.leading, this.remaining);
    }

    public IntervalQualifier getQualifier() {
        return IntervalQualifier.valueOf(this.valueType - 26);
    }

    public boolean isNegative() {
        return this.negative;
    }

    public long getLeading() {
        return this.leading;
    }

    public long getRemaining() {
        return this.remaining;
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setString(parameterIndex, this.getString());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.valueType;
        result = 31 * result + (this.negative ? 1231 : 1237);
        result = 31 * result + (int)(this.leading ^ this.leading >>> 32);
        result = 31 * result + (int)(this.remaining ^ this.remaining >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ValueInterval)) {
            return false;
        }
        ValueInterval other = (ValueInterval)obj;
        return this.valueType == other.valueType && this.negative == other.negative && this.leading == other.leading && this.remaining == other.remaining;
    }

    @Override
    public int compareTypeSafe(Value v, CompareMode mode) {
        ValueInterval other = (ValueInterval)v;
        if (this.negative != other.negative) {
            return this.negative ? -1 : 1;
        }
        int cmp = Long.compare(this.leading, other.leading);
        if (cmp == 0) {
            cmp = Long.compare(this.remaining, other.remaining);
        }
        return this.negative ? -cmp : cmp;
    }

    @Override
    public int getSignum() {
        return this.negative ? -1 : (this.leading == 0L && this.remaining == 0L ? 0 : 1);
    }

    @Override
    public Value add(Value v) {
        return IntervalUtils.intervalFromAbsolute(this.getQualifier(), IntervalUtils.intervalToAbsolute(this).add(IntervalUtils.intervalToAbsolute((ValueInterval)v)));
    }

    @Override
    public Value subtract(Value v) {
        return IntervalUtils.intervalFromAbsolute(this.getQualifier(), IntervalUtils.intervalToAbsolute(this).subtract(IntervalUtils.intervalToAbsolute((ValueInterval)v)));
    }

    @Override
    public Value negate() {
        if (this.leading == 0L && this.remaining == 0L) {
            return this;
        }
        return Value.cache(new ValueInterval(this.valueType, !this.negative, this.leading, this.remaining));
    }
}

